/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.demos;

import java.io.Closeable;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.raft.blocks.CounterService;
import org.jgroups.raft.blocks.RaftSyncCounter;
import org.jgroups.util.Util;

public class CounterServiceDemo {
    protected JChannel ch;
    protected CounterService counter_service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String props, String name, long repl_timeout, boolean allow_dirty_reads) throws Exception {
        this.ch = new JChannel(props).name(name);
        this.counter_service = new CounterService(this.ch).raftId(name).replTimeout(repl_timeout).allowDirtyReads(allow_dirty_reads);
        this.ch.setReceiver(new Receiver(){

            public void viewAccepted(View view) {
                System.out.println("-- view: " + view);
            }
        });
        try {
            this.ch.connect("cntrs");
            this.loop();
        }
        finally {
            Util.close((Closeable)this.ch);
        }
    }

    protected void loop() throws Exception {
        RaftSyncCounter counter = null;
        boolean looping = true;
        block14: while (looping) {
            try {
                int key = Util.keyPress((String)("[0] Initialize counter [1] Increment [2] Decrement [3] Compare and set\n[4] Dump log [5] Snapshot [6] Increment N times [7] increment N times (parallel) [x] Exit\nfirst-applied=" + this.firstApplied() + ", last-applied=" + this.counter_service.lastApplied() + ", commit-index=" + this.counter_service.commitIndex() + ", log size=" + this.logSize() + "\n"));
                if (counter == null) {
                    counter = this.counter_service.getOrCreateCounter("counter", 0L);
                }
                switch (key) {
                    case 48: {
                        long initial_value = Util.readLongFromStdin((String)"initial value: ");
                        counter = this.counter_service.getOrCreateCounter("counter", initial_value);
                        break;
                    }
                    case 49: {
                        long val = counter.incrementAndGet();
                        System.out.printf("%s: %s\n", counter.getName(), val);
                        break;
                    }
                    case 50: {
                        long val = counter.decrementAndGet();
                        System.out.printf("%s: %s\n", counter.getName(), val);
                        break;
                    }
                    case 51: {
                        long expect = Util.readLongFromStdin((String)"expected value: ");
                        long update = Util.readLongFromStdin((String)"update: ");
                        if (counter.compareAndSet(expect, update)) {
                            System.out.println("-- set counter \"" + counter.getName() + "\" to " + update + "\n");
                            break;
                        }
                        System.err.println("failed setting counter \"" + counter.getName() + "\" from " + expect + " to " + update + ", current value is " + counter.get() + "\n");
                        break;
                    }
                    case 52: {
                        this.dumpLog();
                        break;
                    }
                    case 53: {
                        this.counter_service.snapshot();
                        break;
                    }
                    case 54: {
                        int NUM = Util.readIntFromStdin((String)"num: ");
                        System.out.println();
                        int print = Math.max(1, NUM / 10);
                        long retval = 0L;
                        long start = System.currentTimeMillis();
                        for (int i = 0; i < NUM; ++i) {
                            retval = counter.incrementAndGet();
                            if (i <= 0 || i % print != 0) continue;
                            System.out.println("-- count=" + retval);
                        }
                        long diff = System.currentTimeMillis() - start;
                        System.out.printf("\n%d incrs took %d ms; %.2f ops /sec\n", NUM, diff, (double)NUM / ((double)diff / 1000.0));
                        break;
                    }
                    case 55: {
                        int NUM = Util.readIntFromStdin((String)"num: ");
                        System.out.println();
                        RaftSyncCounter ctr = counter;
                        for (int i = 1; i <= NUM; ++i) {
                            Thread t = new Thread(() -> {
                                long ret = ctr.incrementAndGet();
                                System.out.printf("[%d] val=%d\n", Thread.currentThread().getId(), ret);
                            });
                            t.start();
                        }
                        continue block14;
                    }
                    case 120: {
                        looping = false;
                        break;
                    }
                    case 10: {
                        System.out.println(counter.getName() + ": " + counter.get() + "\n");
                    }
                }
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
    }

    protected void dumpLog() {
        System.out.println("\nindex (term): command\n---------------------");
        this.counter_service.dumpLog();
        System.out.println();
    }

    protected long firstApplied() {
        RAFT raft = (RAFT)this.ch.getProtocolStack().findProtocol(RAFT.class);
        return raft.log().firstAppended();
    }

    protected long logSize() {
        return this.counter_service.logSize();
    }

    public static void main(String[] args) throws Exception {
        String properties = "raft.xml";
        String name = null;
        long repl_timeout = 5000L;
        boolean allow_dirty_reads = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                properties = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            if (args[i].equals("repl_timeout")) {
                repl_timeout = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-allow_dirty_reads")) {
                allow_dirty_reads = Boolean.parseBoolean(args[++i]);
                continue;
            }
            CounterServiceDemo.help();
            return;
        }
        new CounterServiceDemo().start(properties, name, repl_timeout, allow_dirty_reads);
    }

    private static void help() {
        System.out.println("CounterServiceDemo [-props props] [-name name] [-repl_timeout timeout] [-follower] [-allow_dirty_reads true|false]");
    }
}

