/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.raft.testfwk.RaftNode;

public abstract class MockRaftCluster {
    protected final Executor thread_pool = MockRaftCluster.createThreadPool(1000L);
    protected boolean async;

    public abstract void handleView(View var1);

    public abstract void send(Message var1);

    protected <T extends MockRaftCluster> T self() {
        return (T)this;
    }

    public boolean async() {
        return this.async;
    }

    public <T extends MockRaftCluster> T async(boolean b) {
        this.async = b;
        return this.self();
    }

    protected static Executor createThreadPool(long max_idle_ms) {
        int max_cores = Runtime.getRuntime().availableProcessors();
        return new ThreadPoolExecutor(0, max_cores, max_idle_ms, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    }

    protected void deliverAsync(RaftNode node, Message msg) {
        this.thread_pool.execute(() -> node.up(msg));
    }
}

