/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.raft.testfwk.MockRaftCluster;
import org.jgroups.raft.testfwk.RaftNode;

public class PartitionedRaftCluster
extends MockRaftCluster {
    protected final Map<Address, List<Address>> partitions = new ConcurrentHashMap<Address, List<Address>>();
    protected final Map<Address, RaftNode> nodes = new ConcurrentHashMap<Address, RaftNode>();

    public PartitionedRaftCluster clear() {
        this.nodes.clear();
        return this;
    }

    public PartitionedRaftCluster add(Address addr, RaftNode node) {
        this.nodes.put(addr, node);
        return this;
    }

    @Override
    public void handleView(View view) {
        List members = view.getMembers();
        for (Address member : members) {
            this.partitions.put(member, members);
        }
        for (Address member : members) {
            RaftNode node = this.nodes.get(member);
            node.handleView(view);
        }
    }

    @Override
    public void send(Message msg) {
        Address dest = msg.dest();
        Address src = msg.src();
        if (dest != null) {
            List<Address> connected = this.partitions.get(src);
            if (connected.contains(dest)) {
                RaftNode node = this.nodes.get(dest);
                this.send(node, msg);
            }
        } else {
            for (Address a : this.partitions.get(src)) {
                RaftNode node = this.nodes.get(a);
                this.send(node, msg);
            }
            if (!msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                RaftNode node = this.nodes.get(src);
                this.send(node, msg);
            }
        }
    }

    private void send(RaftNode node, Message msg) {
        if (this.async) {
            this.deliverAsync(node, msg);
        } else {
            node.up(msg);
        }
    }
}

