/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ObjLongConsumer;
import org.jgroups.Address;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.LogEntries;
import org.jgroups.protocols.raft.LogEntry;
import org.jgroups.raft.util.ArrayRingBuffer;

public class InMemoryLog
implements Log {
    public static final Map<String, Log> logs = new ConcurrentHashMap<String, Log>();
    private long current_term;
    private long first_appended;
    private long last_appended;
    private long commit_index;
    private ArrayRingBuffer<LogEntry> entries;
    protected String name;
    protected volatile Address voted_for;
    protected volatile ByteBuffer snapshot;

    @Override
    public void init(String log_name, Map<String, String> args) throws Exception {
        this.name = log_name;
        InMemoryLog existing = (InMemoryLog)logs.putIfAbsent(this.name, this);
        if (existing != null) {
            this.voted_for = existing.voted_for;
            this.current_term = existing.current_term;
            this.first_appended = existing.first_appended;
            this.last_appended = existing.last_appended;
            this.commit_index = existing.commit_index;
            this.entries = existing.entries;
        } else {
            this.voted_for = null;
            this.entries = new ArrayRingBuffer(16, 1L);
            this.current_term = 0L;
            this.first_appended = 0L;
            this.last_appended = 0L;
            this.commit_index = 0L;
        }
    }

    @Override
    public Log useFsync(boolean f) {
        return this;
    }

    @Override
    public boolean useFsync() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
        InMemoryLog l = (InMemoryLog)logs.remove(this.name);
        if (l != null) {
            l.current_term = 0L;
            l.first_appended = 0L;
            l.last_appended = 0L;
            l.commit_index = 0L;
        }
    }

    @Override
    public long currentTerm() {
        return this.current_term;
    }

    @Override
    public Log currentTerm(long new_term) {
        this.current_term = new_term;
        return this;
    }

    @Override
    public Address votedFor() {
        return this.voted_for;
    }

    @Override
    public Log votedFor(Address member) {
        this.voted_for = member;
        return this;
    }

    @Override
    public long commitIndex() {
        return this.commit_index;
    }

    @Override
    public Log commitIndex(long new_index) {
        this.commit_index = new_index;
        return this;
    }

    @Override
    public long firstAppended() {
        return this.first_appended;
    }

    @Override
    public long lastAppended() {
        return this.last_appended;
    }

    @Override
    public void setSnapshot(ByteBuffer sn) {
        this.snapshot = sn;
    }

    @Override
    public ByteBuffer getSnapshot() {
        return this.snapshot != null ? this.snapshot.duplicate() : null;
    }

    @Override
    public long append(long index, LogEntries entries) {
        long candidate_term = entries.entries.get((int)(entries.size() - 1)).term;
        long candidate_last = index + (long)entries.size() - 1L;
        for (LogEntry entry : entries) {
            this.entries.add(entry);
        }
        this.last_appended = Math.max(this.last_appended, candidate_last);
        this.current_term = Math.max(this.current_term, candidate_term);
        return this.last_appended;
    }

    @Override
    public LogEntry get(long index) {
        if (index <= 0L) {
            return null;
        }
        int real_index = (int)(index - this.first_appended);
        return real_index < 0 || this.entries.isEmpty() || real_index > this.entries.size() ? null : this.entries.get(index);
    }

    @Override
    public void truncate(long index_exclusive) {
        long actual_index = Math.min(index_exclusive, this.commit_index);
        this.entries.dropHeadUntil(actual_index);
        this.first_appended = actual_index;
        if (this.last_appended < actual_index) {
            this.last_appended = actual_index;
        }
    }

    @Override
    public void reinitializeTo(long index, LogEntry entry) {
        this.current_term = entry.term();
        this.entries.dropHeadUntil(index);
        this.entries.dropTailToHead();
        this.commit_index = this.last_appended = index;
        this.first_appended = this.last_appended;
    }

    @Override
    public void deleteAllEntriesStartingFrom(long start_index) {
        int idx = (int)(start_index - this.first_appended);
        if (idx < 0 || idx > this.entries.size()) {
            return;
        }
        assert (start_index > this.commit_index);
        this.entries.dropTailTo(start_index);
        LogEntry last = this.get(start_index - 1L);
        this.current_term = last != null ? last.term : 0L;
        this.last_appended = start_index - 1L;
        if (this.commit_index > this.last_appended) {
            this.commit_index = this.last_appended;
        }
    }

    @Override
    public void forEach(ObjLongConsumer<LogEntry> function, long start_index, long end_index) {
        long start = Math.max(start_index, this.entries.getHeadSequence());
        long end = Math.min(end_index, this.entries.getTailSequence());
        for (long i = start; i < end; ++i) {
            LogEntry entry = this.entries.get(i);
            function.accept(entry, i);
        }
    }

    @Override
    public void forEach(ObjLongConsumer<LogEntry> function) {
        this.forEach(function, Math.max(1L, this.entries.getHeadSequence()), this.entries.getTailSequence());
    }

    @Override
    public long sizeInBytes() {
        AtomicLong size = new AtomicLong(0L);
        this.entries.forEach((? super T entry, long ignore) -> size.addAndGet(entry.length));
        return size.longValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("first_appended=").append(this.first_appended).append(", last_appended=").append(this.last_appended).append(", commit_index=").append(this.commit_index).append(", current_term=").append(this.current_term);
        return sb.toString();
    }
}

