/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft.state;

import java.util.Objects;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.jgroups.Address;
import org.jgroups.protocols.raft.Log;
import org.jgroups.protocols.raft.RAFT;

@ThreadSafe
public class RaftState {
    private final RAFT raft;
    private final Consumer<Address> onLeaderUpdate;
    private Address leader;
    private long term;
    private Address votedFor;

    public RaftState(RAFT raft, Consumer<Address> onLeaderUpdate) {
        this.raft = raft;
        this.onLeaderUpdate = onLeaderUpdate;
        this.reload();
    }

    public synchronized Address leader() {
        return this.leader;
    }

    public synchronized long currentTerm() {
        return this.term;
    }

    public synchronized Address votedFor() {
        return this.votedFor;
    }

    public long advanceTermForElection() {
        long current;
        while (this.tryAdvanceTerm((current = this.currentTerm()) + 1L) != 1) {
        }
        return this.currentTerm();
    }

    public int tryAdvanceTerm(long newTerm) {
        return this.tryAdvanceTermAndLeader(newTerm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryAdvanceTermAndLeader(long newTerm, Address newLeader) {
        boolean saveVote = false;
        boolean saveTerm = false;
        RaftState raftState = this;
        synchronized (raftState) {
            if (newTerm > 0L && newTerm < this.term) {
                return -1;
            }
            if (newTerm == this.term && newLeader == null) {
                return 0;
            }
            if (newTerm > this.term) {
                this.raft.getLog().trace("%s: changed term from %d -> %d", new Object[]{this.raft.addr(), this.term, newTerm});
                this.term = newTerm;
                saveTerm = true;
                saveVote = this.setVotedFor(null, false);
                this.leader = null;
            }
            this.setLeader(newLeader);
        }
        Log log = this.raft.log();
        if (log != null) {
            if (saveTerm) {
                log.currentTerm(this.currentTerm());
            }
            if (saveVote) {
                log.votedFor(this.votedFor());
            }
        }
        return saveTerm ? 1 : 0;
    }

    public synchronized void setLeader(Address newLeader) {
        if (this.leader != null && newLeader != null && !Objects.equals(this.leader, newLeader)) {
            throw new IllegalStateException(String.format("Changing leader %s to %s illegally", this.leader, newLeader));
        }
        boolean updated = newLeader == null || this.leader == null;
        this.leader = newLeader;
        if (updated) {
            this.raft.getLog().trace("%s: change leader from %s -> %s", new Object[]{this.raft.addr(), this.leader, newLeader});
            this.onLeaderUpdate.accept(this.leader);
        }
    }

    public void setVotedFor(Address votedFor) {
        Objects.requireNonNull(votedFor, "Voted for must not be null");
        this.setVotedFor(votedFor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Log log = this.raft.log();
        if (log != null) {
            RaftState raftState = this;
            synchronized (raftState) {
                this.term = log.currentTerm();
                this.votedFor = log.votedFor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setVotedFor(Address votedFor, boolean save) {
        Log log;
        RaftState raftState = this;
        synchronized (raftState) {
            if (votedFor != null && this.votedFor != null && !Objects.equals(votedFor, this.votedFor)) {
                throw new IllegalStateException(String.format("Changing vote %s to %s illegally", this.votedFor, votedFor));
            }
            if (Objects.equals(this.votedFor, votedFor)) {
                return false;
            }
            this.votedFor = votedFor;
        }
        if (votedFor != null && this.raft.getLog().isTraceEnabled()) {
            this.raft.getLog().trace("%s: voted for %s in term %d", new Object[]{this.raft.addr(), votedFor, this.currentTerm()});
        }
        if (save && (log = this.raft.log()) != null) {
            log.votedFor(this.votedFor());
        }
        return true;
    }

    public String toString() {
        return "[leader=" + String.valueOf(this.leader) + ", term=" + this.term + ", voted=" + String.valueOf(this.votedFor) + "]";
    }
}

