/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.filelog;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.jgroups.Address;
import org.jgroups.raft.filelog.FileStorage;
import org.jgroups.util.ByteBufferInputStream;
import org.jgroups.util.Util;

public class MetadataStorage {
    private static final String FILE_NAME = "metadata.raft";
    private static final int COMMIT_INDEX_POS = 0;
    private static final int CURRENT_TERM_POS = 8;
    private static final int VOTED_FOR_POS = 16;
    private final FileStorage fileStorage;
    private MappedByteBuffer commitAndTermBytes;
    private boolean fsync;

    public MetadataStorage(File parentDir, boolean fsync) {
        this.fileStorage = new FileStorage(new File(parentDir, FILE_NAME));
        this.fsync = fsync;
    }

    public void useFsync(boolean value) {
        this.fsync = value;
    }

    public boolean useFsync() {
        return this.fsync;
    }

    public void open() throws IOException {
        this.fileStorage.open();
        this.commitAndTermBytes = FileChannel.open(this.fileStorage.getStorageFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE).map(FileChannel.MapMode.READ_WRITE, 0L, 16L);
    }

    public void close() throws IOException {
        this.fileStorage.close();
        this.commitAndTermBytes = null;
    }

    public void delete() throws IOException {
        this.fileStorage.delete();
        this.commitAndTermBytes = null;
    }

    public long getCommitIndex() {
        return this.commitAndTermBytes.getLong(0);
    }

    public void setCommitIndex(long commitIndex) throws IOException {
        this.commitAndTermBytes.putLong(0, commitIndex);
    }

    public long getCurrentTerm() {
        return this.commitAndTermBytes.getLong(8);
    }

    public void setCurrentTerm(long term) throws IOException {
        this.commitAndTermBytes.putLong(8, term);
        if (this.fsync) {
            this.commitAndTermBytes.force();
        }
    }

    public Address getVotedFor() throws IOException, ClassNotFoundException {
        ByteBuffer dataLengthBuffer = this.fileStorage.read(16L, 4);
        if (dataLengthBuffer.remaining() != 4) {
            return null;
        }
        int addressLength = dataLengthBuffer.getInt(0);
        ByteBuffer addressLengthBuffer = this.fileStorage.read(20L, addressLength);
        if (addressLengthBuffer.remaining() != addressLength) {
            return null;
        }
        return MetadataStorage.readAddress(addressLengthBuffer);
    }

    public void setVotedFor(Address address) throws IOException {
        if (address == null) {
            this.fileStorage.truncateTo(16L);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.writeAddress((Address)address, (DataOutput)new DataOutputStream(baos));
        byte[] data = baos.toByteArray();
        ByteBuffer buffer = this.fileStorage.ioBufferWith(4 + data.length);
        buffer.putInt(data.length);
        buffer.put(data);
        buffer.flip();
        this.fileStorage.write(16L);
    }

    private static Address readAddress(ByteBuffer buffer) throws IOException, ClassNotFoundException {
        return Util.readAddress((DataInput)new ByteBufferInputStream(buffer));
    }
}

