/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.testfwk;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jgroups.Message;
import org.jgroups.util.CompletableFutures;

@ThreadSafe
public final class BlockingMessageInterceptor {
    private final Predicate<Message> predicate;
    @GuardedBy(value="this")
    private final Queue<Waiter> waiters;

    public BlockingMessageInterceptor(Predicate<Message> predicate) {
        this.predicate = predicate;
        this.waiters = new ArrayDeque<Waiter>();
    }

    public boolean shouldBlock(Message message) {
        return this.predicate.test(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockMessage(Message message, boolean async, Runnable onComplete) {
        assert (!async || onComplete != null) : "Async operations need to pass runnable on complete";
        Waiter waiter = new Waiter(message, async);
        BlockingMessageInterceptor blockingMessageInterceptor = this;
        synchronized (blockingMessageInterceptor) {
            this.waiters.offer(waiter);
        }
        CompletableFuture<Void> cf = waiter.block();
        if (async) {
            cf.thenRun(onComplete);
        }
    }

    public void blockMessage(Message message) {
        this.blockMessage(message, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNext() {
        Waiter waiter;
        BlockingMessageInterceptor blockingMessageInterceptor = this;
        synchronized (blockingMessageInterceptor) {
            waiter = this.waiters.poll();
        }
        if (waiter == null) {
            throw new IllegalStateException("No blocked messages");
        }
        waiter.done();
    }

    public void assertNumberOfBlockedMessages(int size) {
        int s = this.numberOfBlockedMessages();
        assert (s == size) : String.format("Expected %d waiters, found %d", size, s);
    }

    public void assertNoBlockedMessages() {
        this.assertNumberOfBlockedMessages(0);
    }

    public synchronized int numberOfBlockedMessages() {
        return this.waiters.size();
    }

    private static class Waiter {
        private final Message message;
        private final CompletableFuture<Void> cf;
        private final boolean async;

        private Waiter(Message message, boolean async) {
            this.message = message;
            this.cf = new CompletableFuture();
            this.async = async;
        }

        private void done() {
            this.cf.complete(null);
        }

        private CompletableFuture<Void> block() {
            try {
                if (this.async) {
                    return this.cf.orTimeout(60L, TimeUnit.SECONDS);
                }
                this.cf.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | TimeoutException e) {
                throw new RuntimeException(String.format("Operation never released: %s", this.message), e);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            return CompletableFutures.completedNull();
        }
    }
}

