/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.raft;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.raft.RaftHeader;
import org.jgroups.protocols.raft.election.BaseElection;
import org.jgroups.protocols.raft.election.PreVoteRequest;
import org.jgroups.protocols.raft.election.PreVoteResponse;
import org.jgroups.raft.util.Utils;
import org.jgroups.util.ResponseCollector;

@MBean(description="Performs leader election with a pre-voting phase.")
public class ELECTION2
extends BaseElection {
    protected static final short ELECTION_ID = 524;
    private final PreVotingMechanism preVotingMechanism = new PreVotingMechanism();

    @ManagedAttribute(description="Whether the pre-voting is running? (Coordinator only)")
    public boolean isPreVoteThreadRunning() {
        return this.preVotingMechanism.isRunning();
    }

    @Override
    protected void handleView(View v) {
        View previousView = this.view;
        this.view = v;
        Utils.Majority result = Utils.computeMajority(previousView, v, this.raft);
        this.log.debug("%s: existing view: %s, new view: %s, result: %s", new Object[]{this.local_addr, previousView, v, result});
        List joiners = View.newMembers((View)previousView, (View)v);
        boolean has_new_members = joiners != null && !joiners.isEmpty();
        switch (result) {
            case no_change: {
                if (this.raft.isLeader() && has_new_members) {
                    this.sendLeaderElectedMessage(this.raft.leader(), this.raft.currentTerm());
                    break;
                }
                if (!Utils.viewCoordinatorChanged(previousView, v) || !this.isViewCoordinator() || this.view.size() < this.raft.majority()) break;
                this.preVotingMechanism.start();
                break;
            }
            case reached: 
            case leader_lost: {
                if (!this.isViewCoordinator()) break;
                this.stopVotingThread();
                this.preVotingMechanism.stop();
                this.preVotingMechanism.start();
                break;
            }
            case lost: {
                this.preVotingMechanism.stop();
                this.stopVotingThread();
                this.raft.setLeaderAndTerm(null);
            }
        }
    }

    @Override
    protected void handleMessage(Message msg, RaftHeader hdr) {
        if (hdr instanceof PreVoteRequest) {
            this.handlePreVoteRequest(msg, (PreVoteRequest)hdr);
            return;
        }
        if (hdr instanceof PreVoteResponse) {
            this.handlePreVoteResponse(msg, (PreVoteResponse)hdr);
            return;
        }
        super.handleMessage(msg, hdr);
    }

    private void handlePreVoteRequest(Message message, PreVoteRequest hdr) {
        this.sendPreVoteResponse(message.getSrc());
    }

    private void handlePreVoteResponse(Message msg, PreVoteResponse hdr) {
        if (this.isVotingThreadRunning() || !this.isViewCoordinator() || !this.preVotingMechanism.isRunning()) {
            return;
        }
        this.preVotingMechanism.includeResponse(msg.getSrc(), hdr);
    }

    private void sendPreVotingRequest() {
        PreVoteRequest hdr = new PreVoteRequest();
        Message msg = new EmptyMessage(null).putHeader(this.id, (Header)hdr).setFlag(new Message.Flag[]{Message.Flag.OOB});
        this.log.trace("%s -> all: %s", new Object[]{this.local_addr, hdr});
        this.down_prot.down(msg);
    }

    private void sendPreVoteResponse(Address dest) {
        PreVoteResponse hdr = new PreVoteResponse(this.raft.leader());
        Message msg = new EmptyMessage(dest).putHeader(this.id, (Header)hdr).setFlag(new Message.Flag[]{Message.Flag.OOB});
        this.log.trace("%s -> %s: %s", new Object[]{this.local_addr, dest, hdr});
        this.down_prot.down(msg);
    }

    static {
        ClassConfigurator.addProtocol((short)524, ELECTION2.class);
        ClassConfigurator.add((short)3006, PreVoteRequest.class);
        ClassConfigurator.add((short)3007, PreVoteResponse.class);
    }

    private class PreVotingMechanism {
        protected final ResponseCollector<PreVoteResponse> preVotingResponses = new ResponseCollector();

        private PreVotingMechanism() {
        }

        public boolean isRunning() {
            return this.preVotingResponses.size() > 0;
        }

        public void start() {
            int majority = ELECTION2.this.raft.majority();
            if (!this.isRunning() && ELECTION2.this.isViewCoordinator() && !ELECTION2.this.isVotingThreadRunning() && ELECTION2.this.view.getMembers().size() >= majority) {
                ELECTION2.this.log.trace("%s: starting pre-voting mechanism", new Object[]{ELECTION2.this.local_addr});
                this.startPreVotingPhase();
            }
        }

        public void stop() {
            ELECTION2.this.log.trace("%s: stopping pre-voting thread", new Object[]{ELECTION2.this.local_addr});
            this.preVotingResponses.reset();
        }

        public void includeResponse(Address sender, PreVoteResponse hdr) {
            this.preVotingResponses.add(sender, (Object)hdr);
            int majority = ELECTION2.this.raft.majority();
            if (this.preVotingResponses.hasAllResponses() && this.preVotingResponses.numberOfValidResponses() >= majority) {
                Map<Address, PreVoteResponse> responses = Map.copyOf(this.preVotingResponses.getResults());
                this.stopPreVotingPhase(responses);
                this.stop();
            } else if (ELECTION2.this.log.isTraceEnabled()) {
                ELECTION2.this.log.trace("%s: collected pre-vote responses %s", new Object[]{ELECTION2.this.local_addr, this.preVotingResponses.getResults()});
            }
        }

        private void startPreVotingPhase() {
            this.preVotingResponses.reset((Collection)ELECTION2.this.view.getMembers());
            ELECTION2.this.sendPreVotingRequest();
        }

        private void stopPreVotingPhase(Map<Address, PreVoteResponse> responses) {
            int acceptStartVoting = 0;
            Address localLeader = ELECTION2.this.raft.leader();
            ELECTION2.this.log.trace("%s: validating pre-vote responses from %s", new Object[]{ELECTION2.this.local_addr, responses});
            Address remoteLeader = null;
            for (Object response2 : responses.values()) {
                if (response2 == null) continue;
                Address leader = response2.leader();
                if (leader == null || leader.equals((Object)localLeader)) {
                    ++acceptStartVoting;
                    continue;
                }
                assert (remoteLeader == null || remoteLeader.equals((Object)leader)) : "Somehow the leader is different!!";
                remoteLeader = leader;
            }
            if (acceptStartVoting >= ELECTION2.this.raft.majority()) {
                ELECTION2.this.log.debug("%s: pre-voting phase finished and starting the voting phase", new Object[]{ELECTION2.this.local_addr});
                ELECTION2.this.raft.setLeaderAndTerm(null);
                ELECTION2.this.startVotingThread();
                return;
            }
            ELECTION2.this.log.trace("%s: did not met majority, taking slow-path %s", new Object[]{ELECTION2.this.local_addr, responses});
            HashMap<Address, Integer> votes = new HashMap<Address, Integer>();
            for (Object response3 : responses.values()) {
                if (response3 == null || response3.leader() == null) continue;
                votes.compute(response3.leader(), (k, v) -> v == null ? 1 : v + 1);
            }
            Address leader = null;
            for (Map.Entry entry : votes.entrySet()) {
                if (leader != null && (Integer)entry.getValue() <= (Integer)votes.get(leader)) continue;
                leader = (Address)entry.getKey();
            }
            assert (leader != null) : "Leader should not be null at this stage: " + String.valueOf(responses);
            PreVoteResponse response = responses.get(leader);
            if (response == null || !leader.equals((Object)response.leader())) {
                ELECTION2.this.log.debug("%s: pre-voting phase finished and starting the voting phase", new Object[]{ELECTION2.this.local_addr});
                ELECTION2.this.startVotingThread();
                return;
            }
            ELECTION2.this.log.trace("%s: not able to start voting, majority sees %s as leader", new Object[]{ELECTION2.this.local_addr, leader});
        }
    }
}

