/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.raft.client;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.jgroups.Address;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.blocks.cs.TcpClient;
import org.jgroups.raft.demos.ReplicatedStateMachineDemo;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class ReplicatedStateMachineClient
implements Receiver,
ConnectionListener {
    protected TcpClient client;
    protected volatile boolean running = true;
    protected volatile boolean verbose = false;
    protected static final byte[] SHOW_ALL_CMD = new byte[]{(byte)ReplicatedStateMachineDemo.Command.SHOW_ALL.ordinal()};
    protected static final byte[] DUMP_CMD = new byte[]{(byte)ReplicatedStateMachineDemo.Command.DUMP_LOG.ordinal()};
    protected static final byte[] SNAPSHOT_CMD = new byte[]{(byte)ReplicatedStateMachineDemo.Command.SNAPSHOT.ordinal()};
    protected static final byte[] GET_VIEW_CMD = new byte[]{(byte)ReplicatedStateMachineDemo.Command.GET_VIEW.ordinal()};

    public ReplicatedStateMachineClient(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InetAddress host, int port) throws Exception {
        this.client = new TcpClient(null, 0, host, port);
        this.client.receiver((Receiver)this);
        this.client.addConnectionListener((ConnectionListener)this);
        try {
            this.client.start();
            this.eventLoop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            Util.close((Closeable)this.client);
        }
    }

    public void receive(Address sender, byte[] buf, int offset, int length) {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        try {
            this.receive(sender, (DataInput)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void receive(Address sender, ByteBuffer buf) {
        Util.bufferToArray((Address)sender, (ByteBuffer)buf, (Receiver)this);
    }

    public void receive(Address sender, DataInput in) throws Exception {
        Object obj = Util.objectFromStream((DataInput)in);
        if (obj instanceof Exception) {
            throw (Exception)obj;
        }
        if (obj != null) {
            if (this.verbose) {
                System.out.printf("-- result from %s: %s\n", sender, obj);
            } else {
                System.out.println(obj);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        InetAddress host = InetAddress.getLocalHost();
        int port = 2065;
        boolean verbose = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-host")) {
                host = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-verbose")) {
                verbose = true;
                continue;
            }
            System.out.printf("\n%s [-host host] [-port port] [-verbose]\n\n", ReplicatedStateMachineClient.class.getSimpleName());
            return;
        }
        ReplicatedStateMachineClient cl = new ReplicatedStateMachineClient(verbose);
        cl.start(host, port);
    }

    public void connectionClosed(Connection conn) {
        this.client.stop();
        this.running = false;
        System.out.printf("connection to %s closed\n", conn.peerAddress());
    }

    public void connectionEstablished(Connection conn) {
    }

    protected void eventLoop() throws Exception {
        while (this.running) {
            int input = Util.keyPress((String)"[1] add [2] get [3] remove [4] show all [5] dump log [6] snapshot [v] view [x] exit\n");
            switch (input) {
                case 49: {
                    this.put(ReplicatedStateMachineClient.read("key"), ReplicatedStateMachineClient.read("value"));
                    break;
                }
                case 50: {
                    this.get(ReplicatedStateMachineClient.read("key"));
                    break;
                }
                case 51: {
                    this.remove(ReplicatedStateMachineClient.read("key"));
                    break;
                }
                case 52: {
                    this.showAll();
                    break;
                }
                case 53: {
                    this.dumpLog();
                    break;
                }
                case 54: {
                    this.snapshot();
                    break;
                }
                case 118: {
                    this.getView();
                    break;
                }
                case 120: {
                    this.client.stop();
                    this.running = false;
                }
            }
        }
    }

    protected void put(String key, String value) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
        out.writeByte(ReplicatedStateMachineDemo.Command.PUT.ordinal());
        Util.objectToStream((Object)key, (DataOutput)out);
        Util.objectToStream((Object)value, (DataOutput)out);
        this.client.send(out.buffer(), 0, out.position());
    }

    protected void get(String key) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
        out.writeByte(ReplicatedStateMachineDemo.Command.GET.ordinal());
        Util.objectToStream((Object)key, (DataOutput)out);
        this.client.send(out.buffer(), 0, out.position());
    }

    protected void remove(String key) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream();
        out.writeByte(ReplicatedStateMachineDemo.Command.REMOVE.ordinal());
        Util.objectToStream((Object)key, (DataOutput)out);
        this.client.send(out.buffer(), 0, out.position());
    }

    protected void showAll() throws Exception {
        this.client.send(SHOW_ALL_CMD, 0, SHOW_ALL_CMD.length);
    }

    protected void dumpLog() throws Exception {
        this.client.send(DUMP_CMD, 0, DUMP_CMD.length);
    }

    protected void snapshot() throws Exception {
        this.client.send(SNAPSHOT_CMD, 0, SNAPSHOT_CMD.length);
    }

    protected void getView() throws Exception {
        this.client.send(GET_VIEW_CMD, 0, GET_VIEW_CMD.length);
    }

    protected static String read(String name) {
        try {
            return Util.readStringFromStdin((String)(name + ": "));
        }
        catch (Exception e) {
            return null;
        }
    }
}

