/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.quarkus.extension;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import org.jboss.logging.Logger;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.quarkus.extension.JChannelConfig;
import org.jgroups.quarkus.extension.JChannelProducer;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

@Recorder
public class JChannelTemplate {
    static final Logger log = Logger.getLogger(JChannelTemplate.class);

    public void createChannel(BeanContainer container, JChannelConfig config) throws Exception {
        TCPPING tcpping;
        JChannelProducer channel = (JChannelProducer)container.instance(JChannelProducer.class, new Annotation[0]);
        log.debugf("creating channel based on config %s", (Object)config);
        channel.create(config);
        TP transport = channel.channel().getProtocolStack().getTransport();
        if (config.bind_addr != null && !config.bind_addr.isEmpty()) {
            InetAddress new_bind_addr = Util.getAddress((String)config.bind_addr, (StackType)Util.getIpStackType());
            log.debugf("changed %s.bind_addr from %s to %s", (Object)transport.getClass().getSimpleName(), (Object)transport.getBindAddress(), (Object)new_bind_addr);
            transport.setBindAddress(new_bind_addr);
        }
        if (config.initial_hosts != null && !config.initial_hosts.isEmpty() && (tcpping = (TCPPING)channel.channel().getProtocolStack().findProtocol(TCPPING.class)) != null) {
            int port_range = tcpping.getPortRange();
            List initial_hosts = Util.parseCommaDelimitedHosts2((String)config.initial_hosts, (int)port_range);
            log.debugf("set TCPPING.initial_hosts to %s", (Object)initial_hosts);
            tcpping.setInitialHosts((Collection)initial_hosts);
        }
    }

    public void connectChannel(BeanContainer container, JChannelConfig cfg) throws Exception {
        JChannelProducer channel = (JChannelProducer)container.instance(JChannelProducer.class, new Annotation[0]);
        channel.connect(cfg.cluster);
    }
}

