/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay3;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.relay_server.JoinRequest;
import org.jgroups.relay_server.Message;
import org.jgroups.relay_server.RelayServiceGrpc;
import org.jgroups.relay_server.Request;
import org.jgroups.relay_server.Response;
import org.jgroups.stack.Protocol;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;

@MBean(description="Protocol that redirects all messages to/from a RelayServer")
public class RELAY3
extends Protocol {
    @Property(description="Whether or not to perform relaying via the relay server")
    protected boolean active;
    @Property(description="The IP address (or symbolic name) of the relay server")
    protected String server_address = "localhost";
    @Property(description="The port on which the relay server is listening")
    protected int server_port = 50051;
    protected Address local_addr;
    protected View local_view;
    protected String cluster;
    protected ManagedChannel channel;
    protected RelayServiceGrpc.RelayServiceStub asyncStub;
    protected RelayServiceGrpc.RelayServiceBlockingStub blocking_stub;
    protected StreamObserver<Request> send_stream;

    public void start() throws Exception {
        super.start();
        this.channel = ManagedChannelBuilder.forAddress((String)this.server_address, (int)this.server_port).usePlaintext(true).build();
        this.asyncStub = RelayServiceGrpc.newStub((Channel)this.channel);
        this.blocking_stub = RelayServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public void stop() {
        super.stop();
        this.channel.shutdown();
    }

    public Object down(Event evt) {
        switch (evt.type()) {
            case 8: {
                this.local_addr = (Address)evt.arg();
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster = (String)evt.arg();
                Object ret = this.down_prot.down(evt);
                this.connect(this.cluster);
                return ret;
            }
            case 4: {
                Object ret = this.down_prot.down(evt);
                this.disconnect();
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    public Object up(Event evt) {
        switch (evt.type()) {
            case 6: {
                this.local_view = (View)evt.arg();
                if (!this.active) break;
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Message msg) {
        if (this.active) {
            Request req = Request.newBuilder().setMessage(RELAY3.jgroupsMessageToProtobufMessage(this.cluster, msg)).build();
            this.send_stream.onNext((Object)req);
            return null;
        }
        return this.down_prot.down(msg);
    }

    protected synchronized void connect(String cluster) {
        this.send_stream = this.asyncStub.connect((StreamObserver)new StreamObserver<Response>(){

            public void onNext(Response rsp) {
                if (rsp.hasMessage()) {
                    RELAY3.this.handleMessage(rsp.getMessage());
                    return;
                }
                if (rsp.hasView()) {
                    RELAY3.this.handleView(rsp.getView());
                    return;
                }
                throw new IllegalStateException(String.format("response is illegal: %s", rsp));
            }

            public void onError(Throwable t) {
                RELAY3.this.log.error("exception from server: %s", t);
            }

            public void onCompleted() {
                RELAY3.this.log.debug("server is done");
            }
        });
        org.jgroups.relay_server.Address pbuf_addr = RELAY3.jgroupsAddressToProtobufAddress(this.local_addr);
        JoinRequest join_req = JoinRequest.newBuilder().setAddress(pbuf_addr).setClusterName(cluster).build();
        Request req = Request.newBuilder().setJoinReq(join_req).build();
        this.send_stream.onNext((Object)req);
    }

    protected synchronized void disconnect() {
        this.send_stream.onCompleted();
    }

    protected void handleView(org.jgroups.relay_server.View view) {
        View jg_view = RELAY3.protobufViewToJGroupsView(view);
        this.up_prot.up(new Event(6, (Object)jg_view));
    }

    protected void handleMessage(org.jgroups.relay_server.Message m) {
        Message msg = RELAY3.protobufMessageToJGroupsMessage(m);
        this.up_prot.up(msg);
    }

    protected static org.jgroups.relay_server.Address jgroupsAddressToProtobufAddress(Address jgroups_addr) {
        if (jgroups_addr == null) {
            return org.jgroups.relay_server.Address.newBuilder().build();
        }
        if (!(jgroups_addr instanceof UUID)) {
            throw new IllegalArgumentException(String.format("JGroups address has to be of type UUID but is %s", jgroups_addr.getClass().getSimpleName()));
        }
        UUID uuid = (UUID)jgroups_addr;
        String name = NameCache.get((Address)jgroups_addr);
        org.jgroups.relay_server.UUID pbuf_uuid = org.jgroups.relay_server.UUID.newBuilder().setLeastSig(uuid.getLeastSignificantBits()).setMostSig(uuid.getMostSignificantBits()).build();
        return org.jgroups.relay_server.Address.newBuilder().setUuid(pbuf_uuid).setName(name).build();
    }

    protected static Address protobufAddressToJGroupsAddress(org.jgroups.relay_server.Address pbuf_addr) {
        if (pbuf_addr == null) {
            return null;
        }
        org.jgroups.relay_server.UUID pbuf_uuid = pbuf_addr.hasUuid() ? pbuf_addr.getUuid() : null;
        return pbuf_uuid == null ? null : new UUID(pbuf_uuid.getMostSig(), pbuf_uuid.getLeastSig());
    }

    protected static org.jgroups.relay_server.Message jgroupsMessageToProtobufMessage(String cluster, Message jgroups_msg) {
        if (jgroups_msg == null) {
            return null;
        }
        Address destination = jgroups_msg.getDest();
        Address sender = jgroups_msg.getSrc();
        byte[] payload = jgroups_msg.getBuffer();
        Message.Builder msg_builder = org.jgroups.relay_server.Message.newBuilder().setClusterName(cluster);
        if (destination != null) {
            msg_builder.setDestination(RELAY3.jgroupsAddressToProtobufAddress(destination));
        }
        if (sender != null) {
            msg_builder.setSender(RELAY3.jgroupsAddressToProtobufAddress(sender));
        }
        if (payload != null) {
            msg_builder.setPayload(ByteString.copyFrom((byte[])payload));
        }
        return msg_builder.build();
    }

    protected static Message protobufMessageToJGroupsMessage(org.jgroups.relay_server.Message msg) {
        ByteString payload;
        Message jgroups_mgs = new Message();
        if (msg.hasDestination()) {
            jgroups_mgs.setDest(RELAY3.protobufAddressToJGroupsAddress(msg.getDestination()));
        }
        if (msg.hasSender()) {
            jgroups_mgs.setSrc(RELAY3.protobufAddressToJGroupsAddress(msg.getSender()));
        }
        if (!(payload = msg.getPayload()).isEmpty()) {
            jgroups_mgs.setBuffer(payload.toByteArray());
        }
        return jgroups_mgs;
    }

    protected static View protobufViewToJGroupsView(org.jgroups.relay_server.View v) {
        org.jgroups.relay_server.ViewId pbuf_vid = v.getViewId();
        List pbuf_mbrs = v.getMemberList();
        ViewId jg_vid = new ViewId(RELAY3.protobufAddressToJGroupsAddress(pbuf_vid.getCreator()), pbuf_vid.getId());
        ArrayList members = new ArrayList();
        pbuf_mbrs.stream().map(RELAY3::protobufAddressToJGroupsAddress).forEach(members::add);
        return new View(jg_vid, members);
    }

    protected static String print(org.jgroups.relay_server.Message msg) {
        return String.format("cluster: %s sender: %s dest: %s %d bytes\n", msg.getClusterName(), msg.hasDestination() ? msg.getDestination().getName() : "null", msg.hasSender() ? msg.getSender().getName() : "null", msg.getPayload().isEmpty() ? 0 : msg.getPayload().size());
    }

    public static String print(org.jgroups.relay_server.View v) {
        if (v.hasViewId()) {
            org.jgroups.relay_server.ViewId view_id = v.getViewId();
            return String.format("%s|%d [%s]", view_id.getCreator().getName(), view_id.getId(), v.getMemberList().stream().map(org.jgroups.relay_server.Address::getName).collect(Collectors.joining(", ")));
        }
        return String.format("[%s]", v.getMemberList().stream().map(org.jgroups.relay_server.Address::getName).collect(Collectors.joining(", ")));
    }
}

