/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.upgrade;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Protocol;
import org.jgroups.upgrade_server.JoinRequest;
import org.jgroups.upgrade_server.LeaveRequest;
import org.jgroups.upgrade_server.Message;
import org.jgroups.upgrade_server.Request;
import org.jgroups.upgrade_server.Response;
import org.jgroups.upgrade_server.RpcHeader;
import org.jgroups.upgrade_server.UpgradeServiceGrpc;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;

@MBean(description="Protocol that redirects all messages to/from an UpgradeServer")
public class UPGRADE
extends Protocol {
    @Property(description="Whether or not to perform relaying via the UpgradeServer", writable=false)
    protected volatile boolean active;
    @Property(description="The IP address (or symbolic name) of the UpgradeServer")
    protected String server_address = "localhost";
    @Property(description="The port on which the UpgradeServer is listening")
    protected int server_port = 50051;
    @ManagedAttribute(description="The local address")
    protected Address local_addr;
    @ManagedAttribute(description="Shows the local view")
    protected View local_view;
    @ManagedAttribute(description="The global view (provided by the UpgradeServer)")
    protected View global_view;
    @ManagedAttribute(description="The cluster this member is a part of")
    protected String cluster;
    protected ManagedChannel channel;
    protected UpgradeServiceGrpc.UpgradeServiceStub asyncStub;
    protected StreamObserver<Request> send_stream;
    protected static final short REQ_ID = ClassConfigurator.getProtocolId(RequestCorrelator.class);

    @ManagedOperation(description="Enable forwarding and receiving of messages to/from the UpgradeServer")
    public synchronized void activate() {
        if (!this.active) {
            this.connect(this.cluster);
            this.active = true;
        }
    }

    @ManagedOperation(description="Disable forwarding and receiving of messages to/from the UpgradeServer")
    public synchronized void deactivate() {
        if (this.active) {
            this.disconnect();
            this.active = false;
        }
    }

    public void start() throws Exception {
        super.start();
        this.channel = ManagedChannelBuilder.forAddress((String)this.server_address, (int)this.server_port).usePlaintext().build();
        this.asyncStub = UpgradeServiceGrpc.newStub((Channel)this.channel);
    }

    public void stop() {
        super.stop();
        this.channel.shutdown();
    }

    public Object down(Event evt) {
        switch (evt.type()) {
            case 8: {
                this.local_addr = (Address)evt.arg();
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster = (String)evt.arg();
                Object ret = this.down_prot.down(evt);
                if (this.active) {
                    this.connect(this.cluster);
                }
                return ret;
            }
            case 4: {
                Object ret = this.down_prot.down(evt);
                this.disconnect();
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    public Object up(Event evt) {
        switch (evt.type()) {
            case 6: {
                this.local_view = (View)evt.arg();
                if (!this.active) break;
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Message msg) {
        if (!this.active) {
            return this.down_prot.down(msg);
        }
        if (this.send_stream != null) {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            Request req = Request.newBuilder().setMessage(UPGRADE.jgroupsMessageToProtobufMessage(this.cluster, msg)).build();
            this.send_stream.onNext((Object)req);
        }
        return null;
    }

    protected synchronized void connect(String cluster) {
        this.send_stream = this.asyncStub.connect((StreamObserver)new StreamObserver<Response>(){

            public void onNext(Response rsp) {
                if (rsp.hasMessage()) {
                    UPGRADE.this.handleMessage(rsp.getMessage());
                    return;
                }
                if (rsp.hasView()) {
                    UPGRADE.this.handleView(rsp.getView());
                    return;
                }
                throw new IllegalStateException(String.format("response is illegal: %s", rsp));
            }

            public void onError(Throwable t) {
                UPGRADE.this.log.error("exception from server: %s", t);
            }

            public void onCompleted() {
                UPGRADE.this.log.debug("server is done");
            }
        });
        org.jgroups.upgrade_server.Address pbuf_addr = UPGRADE.jgroupsAddressToProtobufAddress(this.local_addr);
        JoinRequest join_req = JoinRequest.newBuilder().setAddress(pbuf_addr).setClusterName(cluster).build();
        Request req = Request.newBuilder().setJoinReq(join_req).build();
        this.send_stream.onNext((Object)req);
    }

    protected synchronized void disconnect() {
        if (this.send_stream != null) {
            if (this.local_addr != null && this.cluster != null) {
                org.jgroups.upgrade_server.Address local = UPGRADE.jgroupsAddressToProtobufAddress(this.local_addr);
                LeaveRequest leave_req = LeaveRequest.newBuilder().setClusterName(this.cluster).setLeaver(local).build();
                Request request = Request.newBuilder().setLeaveReq(leave_req).build();
                this.send_stream.onNext((Object)request);
            }
            this.send_stream.onCompleted();
        }
        this.global_view = null;
    }

    protected void handleView(org.jgroups.upgrade_server.View view) {
        View jg_view;
        this.global_view = jg_view = UPGRADE.protobufViewToJGroupsView(view);
        this.up_prot.up(new Event(6, (Object)jg_view));
    }

    protected void handleMessage(org.jgroups.upgrade_server.Message m) {
        Message msg = UPGRADE.protobufMessageToJGroupsMessage(m);
        this.up_prot.up(msg);
    }

    protected static org.jgroups.upgrade_server.Address jgroupsAddressToProtobufAddress(Address jgroups_addr) {
        if (jgroups_addr == null) {
            return org.jgroups.upgrade_server.Address.newBuilder().build();
        }
        if (!(jgroups_addr instanceof UUID)) {
            throw new IllegalArgumentException(String.format("JGroups address has to be of type UUID but is %s", jgroups_addr.getClass().getSimpleName()));
        }
        UUID uuid = (UUID)jgroups_addr;
        String name = NameCache.get((Address)jgroups_addr);
        org.jgroups.upgrade_server.UUID pbuf_uuid = org.jgroups.upgrade_server.UUID.newBuilder().setLeastSig(uuid.getLeastSignificantBits()).setMostSig(uuid.getMostSignificantBits()).build();
        return org.jgroups.upgrade_server.Address.newBuilder().setUuid(pbuf_uuid).setName(name).build();
    }

    protected static Address protobufAddressToJGroupsAddress(org.jgroups.upgrade_server.Address pbuf_addr) {
        if (pbuf_addr == null) {
            return null;
        }
        org.jgroups.upgrade_server.UUID pbuf_uuid = pbuf_addr.hasUuid() ? pbuf_addr.getUuid() : null;
        return pbuf_uuid == null ? null : new UUID(pbuf_uuid.getMostSig(), pbuf_uuid.getLeastSig());
    }

    protected static org.jgroups.upgrade_server.Message jgroupsMessageToProtobufMessage(String cluster, Message jgroups_msg) {
        if (jgroups_msg == null) {
            return null;
        }
        Address destination = jgroups_msg.getDest();
        Address sender = jgroups_msg.getSrc();
        byte[] payload = jgroups_msg.getBuffer();
        RequestCorrelator.Header hdr = (RequestCorrelator.Header)jgroups_msg.getHeader(REQ_ID);
        Message.Builder msg_builder = org.jgroups.upgrade_server.Message.newBuilder().setClusterName(cluster);
        if (destination != null) {
            msg_builder.setDestination(UPGRADE.jgroupsAddressToProtobufAddress(destination));
        }
        if (sender != null) {
            msg_builder.setSender(UPGRADE.jgroupsAddressToProtobufAddress(sender));
        }
        if (payload != null) {
            msg_builder.setPayload(ByteString.copyFrom((byte[])payload));
        }
        if (hdr != null) {
            RpcHeader pbuf_hdr = UPGRADE.jgroupsReqHeaderToProtobufRpcHeader(hdr);
            msg_builder.setRpcHeader(pbuf_hdr);
        }
        return msg_builder.build();
    }

    protected static Message protobufMessageToJGroupsMessage(org.jgroups.upgrade_server.Message msg) {
        ByteString payload;
        Message jgroups_mgs = new Message();
        if (msg.hasDestination()) {
            jgroups_mgs.setDest(UPGRADE.protobufAddressToJGroupsAddress(msg.getDestination()));
        }
        if (msg.hasSender()) {
            jgroups_mgs.setSrc(UPGRADE.protobufAddressToJGroupsAddress(msg.getSender()));
        }
        if (!(payload = msg.getPayload()).isEmpty()) {
            jgroups_mgs.setBuffer(payload.toByteArray());
        }
        if (msg.hasRpcHeader()) {
            RequestCorrelator.Header hdr = UPGRADE.protobufRpcHeaderToJGroupsReqHeader(msg.getRpcHeader());
            jgroups_mgs.putHeader(REQ_ID, (Header)hdr);
        }
        return jgroups_mgs;
    }

    protected static View protobufViewToJGroupsView(org.jgroups.upgrade_server.View v) {
        org.jgroups.upgrade_server.ViewId pbuf_vid = v.getViewId();
        List pbuf_mbrs = v.getMemberList();
        ViewId jg_vid = new ViewId(UPGRADE.protobufAddressToJGroupsAddress(pbuf_vid.getCreator()), pbuf_vid.getId());
        ArrayList members = new ArrayList();
        pbuf_mbrs.stream().map(UPGRADE::protobufAddressToJGroupsAddress).forEach(members::add);
        return new View(jg_vid, members);
    }

    protected static RpcHeader jgroupsReqHeaderToProtobufRpcHeader(RequestCorrelator.Header hdr) {
        return RpcHeader.newBuilder().setType((int)hdr.type).setRequestId(hdr.req_id).setCorrId((int)hdr.corrId).build();
    }

    protected static RequestCorrelator.Header protobufRpcHeaderToJGroupsReqHeader(RpcHeader hdr) {
        byte type = (byte)hdr.getType();
        long request_id = hdr.getRequestId();
        short corr_id = (short)hdr.getCorrId();
        return (RequestCorrelator.Header)new RequestCorrelator.Header(type, request_id, corr_id).setProtId(REQ_ID);
    }

    protected static String print(org.jgroups.upgrade_server.Message msg) {
        return String.format("cluster: %s sender: %s dest: %s %d bytes\n", msg.getClusterName(), msg.hasDestination() ? msg.getDestination().getName() : "null", msg.hasSender() ? msg.getSender().getName() : "null", msg.getPayload().isEmpty() ? 0 : msg.getPayload().size());
    }

    public static String print(org.jgroups.upgrade_server.View v) {
        if (v.hasViewId()) {
            org.jgroups.upgrade_server.ViewId view_id = v.getViewId();
            return String.format("%s|%d [%s]", view_id.getCreator().getName(), view_id.getId(), v.getMemberList().stream().map(org.jgroups.upgrade_server.Address::getName).collect(Collectors.joining(", ")));
        }
        return String.format("[%s]", v.getMemberList().stream().map(org.jgroups.upgrade_server.Address::getName).collect(Collectors.joining(", ")));
    }
}

