/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.jibx.binding.model.BindingDirectory;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.schema.support.LazyList;
import org.jibx.util.HolderBase;

public class BindingHolder
extends HolderBase {
    private final BindingDirectory m_directory;
    private BindingElement m_binding;
    private boolean m_finished;
    private final LazyList m_formats;
    private final LazyList m_includes;
    private final LazyList m_mappings;

    public BindingHolder(String uri, int index, BindingDirectory dir) {
        super(uri);
        this.m_directory = dir;
        this.m_binding = new BindingElement();
        this.m_formats = new LazyList();
        this.m_includes = new LazyList();
        this.m_mappings = new LazyList();
        if (uri != null) {
            NamespaceElement ns = new NamespaceElement();
            ns.setDefaultName("elements");
            ns.setUri(uri);
            ns.setPrefix("ns" + index);
            this.m_binding.addTopChild(ns);
            this.m_binding.addNamespaceDecl("tns", uri);
        }
    }

    public BindingDirectory getDirectory() {
        return this.m_directory;
    }

    public BindingElement getBinding() {
        return this.m_binding;
    }

    public void setBinding(BindingElement bind) {
        this.m_binding = bind;
    }

    private void checkModifiable() {
        if (this.m_finished) {
            throw new IllegalStateException("Internal error - attempt to modify binding after finalized");
        }
    }

    protected void addNamespaceDecl(String prefix, String uri) {
        this.checkModifiable();
        this.m_binding.addNamespaceDecl(prefix, uri);
    }

    public void addFormat(FormatElement format) {
        this.checkModifiable();
        this.m_formats.add((Object)format);
    }

    public void addInclude(IncludeElement include) {
        this.checkModifiable();
        this.m_includes.add((Object)include);
    }

    public void addMapping(MappingElement mapping) {
        this.checkModifiable();
        this.m_mappings.add((Object)mapping);
    }

    public void addDependency(String uri) {
        this.checkModifiable();
        this.m_directory.addDependency(uri, this);
    }

    public void finish() {
        if (!this.m_finished) {
            Iterator iter = this.getReferences().iterator();
            while (iter.hasNext()) {
                this.getPrefix(((BindingHolder)iter.next()).getNamespace());
            }
            ArrayList topchilds = this.m_binding.topChildren();
            topchilds.addAll(this.m_formats);
            topchilds.addAll(this.m_includes);
            topchilds.addAll(this.m_mappings);
            this.m_finished = true;
        }
    }
}

