/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jibx.binding.Compile;
import org.jibx.maven.AbstractJibxMojo;
import org.jibx.runtime.JiBXException;

public abstract class AbstractBaseBindingMojo
extends AbstractJibxMojo {
    boolean load;
    boolean validate;
    boolean verbose;
    boolean verify;
    @Deprecated
    private String directory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] classpaths;
        String[] bindings;
        String mode;
        this.checkConfiguration();
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Not running JiBX binding compiler for pom packaging");
            return;
        }
        if (this.isMultiModuleMode()) {
            mode = this.isRestrictedMultiModuleMode() ? "restricted multi-module" : "multi-module";
            bindings = this.getMultiModuleBindings();
            classpaths = this.getMultiModuleClasspaths();
        } else {
            mode = "single-module";
            bindings = this.getSingleModuleBindings();
            classpaths = this.getSingleModuleClasspaths();
        }
        this.getBaseBindings(bindings);
        if (bindings.length == 0) {
            this.getLog().info((CharSequence)("Not running JiBX binding compiler (" + mode + " mode) - no binding files"));
        } else {
            this.getLog().info((CharSequence)("Running JiBX binding compiler (" + mode + " mode) on " + bindings.length + " binding file(s)"));
            this.compile(classpaths, bindings);
        }
    }

    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.includes != null && this.includes.size() > 0) {
            this.includeSchemaBindings.addAll(this.includes);
        }
        if (this.excludes != null && this.excludes.size() > 0) {
            this.excludeSchemaBindings.addAll(this.excludes);
        }
        if (this.excludeSchemaBindings.size() == 0 && this.includeSchemaBindings.size() == 0) {
            this.includeSchemaBindings.add("binding.xml");
        }
    }

    private void compile(String[] classpaths, String[] bindings) throws MojoExecutionException {
        try {
            Compile compiler = new Compile();
            compiler.setLoad(this.load);
            compiler.setSkipValidate(!this.validate);
            compiler.setVerbose(this.verbose);
            compiler.setVerify(this.verify);
            compiler.compile(classpaths, bindings);
        }
        catch (JiBXException e) {
            Throwable cause = e.getRootCause() != null ? e.getRootCause() : e;
            throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
        }
    }

    protected String getSchemaBindingDirectory() {
        if (this.schemaBindingDirectory != null) {
            return this.schemaBindingDirectory;
        }
        if (this.directory != null) {
            return this.directory;
        }
        return super.getSchemaBindingDirectory();
    }
}

