/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jibx.maven.AbstractBaseBindingMojo;
import org.jibx.runtime.JiBXException;
import org.jibx.ws.wsdl.tools.Jibx2Wsdl;

public abstract class AbstractJibx2WsdlMojo
extends AbstractBaseBindingMojo {
    private ArrayList<String> interfaceClassNames;
    private String outputDirectory;
    private ArrayList<String> customizations;
    private ArrayList<String> sourceDirectories;
    private static final String DEFAULT_SOURCE_DIRECTORY = "src/main/java";
    private Map<String, String> options;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] classpaths;
        String[] bindings;
        String mode;
        this.checkConfiguration();
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Not running JiBX binding compiler for pom packaging");
            return;
        }
        if (this.isMultiModuleMode()) {
            mode = this.isRestrictedMultiModuleMode() ? "restricted multi-module" : "multi-module";
            bindings = this.getMultiModuleBindings();
            classpaths = this.getMultiModuleClasspaths();
        } else {
            mode = "single-module";
            bindings = this.getSingleModuleBindings();
            classpaths = this.getSingleModuleClasspaths();
        }
        if (this.interfaceClassNames.size() == 0) {
            this.getLog().info((CharSequence)("Not running JiBX2WSDL (" + mode + " mode) - no class interface files"));
        } else {
            this.getLog().info((CharSequence)("Running JiBX binding compiler (" + mode + " mode) on " + this.interfaceClassNames.size() + " interface file(s)"));
            try {
                StringBuilder arg;
                Vector<String> args = new Vector<String>();
                for (int i = 0; i < classpaths.length; ++i) {
                    args.add("-p");
                    args.add(classpaths[i]);
                }
                args.add("-t");
                args.add(this.outputDirectory);
                if (this.customizations.size() > 0) {
                    args.add("-c");
                    for (String customization : this.customizations) {
                        args.add(customization);
                    }
                }
                for (Map.Entry<String, String> entry : this.options.entrySet()) {
                    String option = "--" + entry.getKey() + "=" + entry.getValue();
                    if (entry.getKey().toString().length() == 1 && Character.isLowerCase(entry.getKey().toString().charAt(0))) {
                        this.getLog().debug((CharSequence)("Adding option : -" + entry.getKey() + " " + entry.getValue()));
                        args.add("-" + entry.getKey());
                        args.add(entry.getValue());
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Adding option: " + option));
                    args.add(option);
                }
                if (bindings.length > 0) {
                    args.add("-u");
                    arg = new StringBuilder();
                    for (int i = 0; i < bindings.length; ++i) {
                        if (arg.length() > 0) {
                            arg.append(';');
                        }
                        arg.append(bindings[i]);
                    }
                    args.add(arg.toString());
                }
                if (this.sourceDirectories.size() > 0 && this.sourceDirectories.get(0) != null && this.sourceDirectories.get(0).toString().length() > 0) {
                    args.add("-s");
                    arg = new StringBuilder();
                    for (int i = 0; i < this.sourceDirectories.size(); ++i) {
                        if (arg.length() > 0) {
                            arg.append(';');
                        }
                        arg.append(this.sourceDirectories.get(i).toString());
                    }
                    args.add(arg.toString());
                }
                if (this.verbose) {
                    args.add("-v");
                }
                for (String interfaceName : this.interfaceClassNames) {
                    args.add(interfaceName);
                }
                Jibx2Wsdl.main((String[])args.toArray(new String[args.size()]));
            }
            catch (JiBXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.customizations == null) {
            this.customizations = new ArrayList();
        }
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        if (this.sourceDirectories == null) {
            this.sourceDirectories = new ArrayList();
            this.sourceDirectories.add(DEFAULT_SOURCE_DIRECTORY);
        }
    }
}

