/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jibx.custom.CustomizationCommandLineBase;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.codegen.custom.SchemasetCustom;
import org.jibx.schema.validation.ProblemConsoleLister;
import org.jibx.schema.validation.ProblemHandler;
import org.jibx.schema.validation.ProblemLogLister;
import org.jibx.schema.validation.ProblemMultiHandler;
import org.jibx.util.ReflectionUtilities;

public class CodeGenCommandLine
extends CustomizationCommandLineBase {
    private static final Logger s_logger = Logger.getLogger((String)(class$org$jibx$schema$codegen$CodeGenCommandLine == null ? (class$org$jibx$schema$codegen$CodeGenCommandLine = CodeGenCommandLine.class$("org.jibx.schema.codegen.CodeGenCommandLine")) : class$org$jibx$schema$codegen$CodeGenCommandLine).getName());
    private static final String[] EXTRA_USAGE_LINES = new String[]{" -b name      generated root binding name", " -d file      data model class structure for difference comparison", " -i path,...  include existing bindings (one or more), and use for matching\n              schema global definitions", " -m file      file for dumping the generated data model class structure", " -n pack      default package for no-namespace schema definitions", " -p pack      default package for all schema definitions", " -s path      schema root directory path", " -u uri       namespace applied for code generation when no-namespaced schemas\n              are found"};
    private String m_nonamespacePackage;
    private String m_defaultPackage;
    private String m_rootPath;
    private String m_bindingName;
    private String m_usingNamespace;
    private URL m_schemaRoot;
    private File m_schemaDir;
    private File m_modelFile;
    private File m_differenceFile;
    private SchemasetCustom m_customRoot;
    private List m_includePaths = new ArrayList();
    static /* synthetic */ Class class$org$jibx$schema$codegen$CodeGenCommandLine;

    public CodeGenCommandLine() {
        super(EXTRA_USAGE_LINES);
    }

    public URL getSchemaRoot() {
        return this.m_schemaRoot;
    }

    public File getSchemaDir() {
        return this.m_schemaDir;
    }

    public String getBindingName() {
        return this.m_bindingName;
    }

    public String getUsingNamespace() {
        return this.m_usingNamespace;
    }

    public SchemasetCustom getCustomRoot() {
        return this.m_customRoot;
    }

    public String getNonamespacePackage() {
        return this.m_nonamespacePackage;
    }

    public File getModelFile() {
        return this.m_modelFile;
    }

    public File getDifferenceFile() {
        return this.m_differenceFile;
    }

    public List getIncludePaths() {
        return this.m_includePaths;
    }

    protected boolean checkParameter(CustomizationCommandLineBase.ArgList alist) {
        boolean match = true;
        String arg = alist.current();
        if ("-b".equalsIgnoreCase(arg)) {
            this.m_bindingName = alist.next();
        } else if ("-d".equalsIgnoreCase(arg)) {
            this.m_differenceFile = new File(alist.next());
        } else if ("-i".equalsIgnoreCase(arg)) {
            int split;
            String text = alist.next();
            int base = 0;
            while ((split = text.indexOf(44, base)) >= 0) {
                this.m_includePaths.add(text.substring(base, split));
                base = split + 1;
            }
            this.m_includePaths.add(text.substring(base));
        } else if ("-m".equalsIgnoreCase(arg)) {
            this.m_modelFile = new File(alist.next());
        } else if ("-n".equalsIgnoreCase(arg)) {
            this.m_nonamespacePackage = alist.next();
        } else if ("-p".equalsIgnoreCase(arg)) {
            this.m_defaultPackage = alist.next();
        } else if ("-s".equalsIgnoreCase(arg)) {
            this.m_rootPath = alist.next();
        } else if ("-u".equalsIgnoreCase(arg)) {
            this.m_usingNamespace = alist.next();
        } else {
            match = super.checkParameter(alist);
        }
        return match;
    }

    protected void finishParameters(CustomizationCommandLineBase.ArgList alist) {
        super.finishParameters(alist);
        try {
            if (this.m_rootPath == null) {
                this.m_schemaDir = new File(".").getCanonicalFile();
                this.m_schemaRoot = this.m_schemaDir.toURI().toURL();
            } else {
                String path = this.m_rootPath;
                File pathfile = new File(path).getCanonicalFile();
                if (pathfile.exists()) {
                    if (pathfile.isDirectory()) {
                        this.m_schemaDir = pathfile;
                        this.m_schemaRoot = pathfile.toURI().toURL();
                    } else {
                        System.out.println("Schema root path '" + this.m_rootPath + "' must be a directory");
                        alist.setValid(false);
                    }
                } else {
                    if (!path.endsWith("/")) {
                        path = path + '/';
                    }
                    this.m_schemaRoot = new URL(path);
                    if (this.m_schemaRoot.getProtocol().equals("file")) {
                        this.m_schemaDir = new File(this.m_schemaRoot.getPath()).getCanonicalFile();
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            System.out.println("Root path '" + this.m_rootPath + "' not found as file and not recognized as URL");
            alist.setValid(false);
        }
        catch (IOException e) {
            System.out.println("Error processing root path '" + this.m_rootPath + '\'');
            alist.setValid(false);
        }
    }

    protected boolean loadCustomizations(String path) throws JiBXException, IOException {
        ProblemMultiHandler handler = new ProblemMultiHandler();
        handler.addHandler((ProblemHandler)new ProblemConsoleLister());
        handler.addHandler((ProblemHandler)new ProblemLogLister(s_logger));
        this.m_customRoot = SchemasetCustom.loadCustomizations(path, (ProblemHandler)handler);
        if (this.m_defaultPackage != null) {
            this.m_customRoot.setPackage(this.m_defaultPackage);
        }
        return true;
    }

    protected Map applyOverrides(Map overmap) {
        return ReflectionUtilities.applyKeyValueMap((Map)overmap, (Object)this.m_customRoot);
    }

    public void printUsage() {
        System.out.println("\nUsage: java org.jibx.schema.codegen.CodeGen [options] schema1 schema2 ...\nwhere options are:");
        String[] usages = this.getUsageLines();
        for (int i = 0; i < usages.length; ++i) {
            System.out.println(usages[i]);
        }
        System.out.println("The schema# files are different schemas to be included in the generation\n(references from these schemas will also be included).\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

