/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.apache.log4j.Logger;
import org.jibx.runtime.QName;
import org.jibx.schema.IArity;
import org.jibx.schema.ISchemaListener;
import org.jibx.schema.SchemaContextTracker;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.SchemaVisitor;
import org.jibx.schema.TreeWalker;
import org.jibx.schema.codegen.DefinitionItem;
import org.jibx.schema.codegen.GroupItem;
import org.jibx.schema.codegen.JavaType;
import org.jibx.schema.codegen.custom.GlobalExtension;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AnyElement;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.AttributeGroupRefElement;
import org.jibx.schema.elements.CommonCompositorDefinition;
import org.jibx.schema.elements.CommonTypeDefinition;
import org.jibx.schema.elements.ComplexExtensionElement;
import org.jibx.schema.elements.ComplexRestrictionElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.GroupRefElement;
import org.jibx.schema.elements.ListElement;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.schema.elements.SimpleExtensionElement;
import org.jibx.schema.elements.SimpleRestrictionElement;
import org.jibx.schema.elements.SimpleTypeElement;
import org.jibx.schema.elements.UnionElement;
import org.jibx.schema.support.SchemaTypes;

public class ItemVisitor
extends SchemaVisitor {
    private static final Logger s_logger = Logger.getLogger((String)(class$org$jibx$schema$codegen$ItemVisitor == null ? (class$org$jibx$schema$codegen$ItemVisitor = ItemVisitor.class$("org.jibx.schema.codegen.ItemVisitor")) : class$org$jibx$schema$codegen$ItemVisitor).getName());
    private GlobalExtension m_global;
    private GroupItem m_group;
    private int m_nestingDepth;
    static /* synthetic */ Class class$org$jibx$schema$codegen$ItemVisitor;

    public DefinitionItem buildGlobal(AnnotatedBase comp) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(SchemaUtils.getIndentation((int)this.m_nestingDepth) + "Building structure for global definition " + SchemaUtils.describeComponent((SchemaBase)comp)));
            ++this.m_nestingDepth;
        }
        DefinitionItem definition = new DefinitionItem(comp);
        this.m_group = definition;
        this.m_global = (GlobalExtension)comp.getExtension();
        this.m_global.setDefinition(definition);
        TreeWalker wlkr = new TreeWalker(null, (ISchemaListener)new SchemaContextTracker());
        wlkr.walkElement((SchemaBase)comp, (SchemaVisitor)this);
        if (s_logger.isDebugEnabled()) {
            --this.m_nestingDepth;
            s_logger.debug((Object)(SchemaUtils.getIndentation((int)this.m_nestingDepth) + "Completed structure for global definition " + SchemaUtils.describeComponent((SchemaBase)comp) + " with " + this.m_group.getChildCount() + " child items"));
        }
        return definition;
    }

    private GroupItem buildStructure(boolean isenum, AnnotatedBase comp) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(SchemaUtils.getIndentation((int)this.m_nestingDepth) + "building structure for component " + SchemaUtils.describeComponent((SchemaBase)comp)));
            ++this.m_nestingDepth;
        }
        GroupItem hold = this.m_group;
        this.m_group = hold.addGroup(comp);
        this.m_group.setEnumeration(isenum);
        TreeWalker wlkr = new TreeWalker(null, (ISchemaListener)new SchemaContextTracker());
        wlkr.walkChildren((SchemaBase)comp, (SchemaVisitor)this);
        GroupItem ret = this.m_group;
        if (s_logger.isDebugEnabled()) {
            --this.m_nestingDepth;
            s_logger.debug((Object)(SchemaUtils.getIndentation((int)this.m_nestingDepth) + "completed structure for component " + SchemaUtils.describeComponent((SchemaBase)comp) + " with " + this.m_group.getChildCount() + " child items"));
        }
        this.m_group = hold;
        return ret;
    }

    private void addReference(AnnotatedBase comp, AnnotatedBase ref) {
        DefinitionItem definition = ((GlobalExtension)ref.getExtension()).getDefinition();
        if (definition == null) {
            GroupItem holdstruct = this.m_group;
            int holddepth = this.m_nestingDepth;
            definition = this.buildGlobal(ref);
            this.m_group = holdstruct;
            this.m_nestingDepth = holddepth;
        }
        this.m_group.addReference(comp, definition);
    }

    private JavaType getSchemaType(CommonTypeDefinition def) {
        String name = def.getName();
        JavaType type = (JavaType)this.m_global.getSchemaTypes().get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown schema type '" + name + '\'');
        }
        return type;
    }

    private void addTypeRefItem(AnnotatedBase comp, CommonTypeDefinition def) {
        if (def.isPredefinedType()) {
            GroupItem group = this.m_group.addGroup(comp);
            group.addValue(comp, def.getQName(), this.getSchemaType(def));
        } else {
            this.addReference(comp, (AnnotatedBase)def);
        }
    }

    public boolean visit(AnyElement node) {
        if (!SchemaUtils.isProhibited((IArity)node)) {
            this.m_group.addAny((AnnotatedBase)node);
        }
        return false;
    }

    public boolean visit(AttributeElement node) {
        if (node.getUse() != 1) {
            AttributeElement refattr = node.getReference();
            if (refattr == null) {
                if (node.getType() == null) {
                    this.buildStructure(false, (AnnotatedBase)node);
                } else {
                    this.addTypeRefItem((AnnotatedBase)node, node.getTypeDefinition());
                }
            } else {
                this.addReference((AnnotatedBase)node, (AnnotatedBase)node.getReference());
            }
        }
        return false;
    }

    public boolean visit(AttributeGroupRefElement node) {
        this.addReference((AnnotatedBase)node, (AnnotatedBase)node.getReference());
        return false;
    }

    public boolean visit(CommonCompositorDefinition node) {
        this.buildStructure(false, (AnnotatedBase)node);
        return false;
    }

    public boolean visit(ComplexExtensionElement node) {
        CommonTypeDefinition base = node.getBaseType();
        if (base != SchemaTypes.ANY_TYPE) {
            this.addReference((AnnotatedBase)node, (AnnotatedBase)base);
        }
        return true;
    }

    public boolean visit(ComplexRestrictionElement node) {
        CommonTypeDefinition base = node.getBaseType();
        if (base != SchemaTypes.ANY_TYPE) {
            this.addReference((AnnotatedBase)node, (AnnotatedBase)base);
        }
        return false;
    }

    public boolean visit(ElementElement node) {
        if (!SchemaUtils.isProhibited((IArity)node)) {
            ElementElement refelem = node.getReference();
            if (refelem == null) {
                if (node.getType() == null || node.getType().equals((Object)SchemaTypes.ANY_TYPE.getQName())) {
                    this.buildStructure(false, (AnnotatedBase)node);
                } else {
                    this.addTypeRefItem((AnnotatedBase)node, node.getTypeDefinition());
                }
            } else {
                this.addReference((AnnotatedBase)node, (AnnotatedBase)refelem);
            }
        }
        return false;
    }

    public boolean visit(GroupRefElement node) {
        this.addReference((AnnotatedBase)node, (AnnotatedBase)node.getReference());
        return false;
    }

    public boolean visit(ListElement node) {
        QName type = node.getItemType();
        if (type == null) {
            this.buildStructure(false, (AnnotatedBase)node);
        } else {
            this.addTypeRefItem((AnnotatedBase)node, node.getItemTypeDefinition());
        }
        return false;
    }

    public boolean visit(SimpleExtensionElement node) {
        this.addTypeRefItem((AnnotatedBase)node, node.getBaseType());
        return true;
    }

    public boolean visit(SimpleRestrictionElement node) {
        CommonTypeDefinition type = node.getBaseType();
        if (type == null) {
            this.buildStructure(false, (AnnotatedBase)node.getDerivation());
        } else {
            this.addTypeRefItem((AnnotatedBase)node, type);
        }
        return false;
    }

    public boolean visit(SimpleTypeElement node) {
        if (SchemaUtils.isEnumeration((AnnotatedBase)node)) {
            if (this.m_group.getSchemaComponent() == node) {
                this.m_group.setEnumeration(true);
            } else {
                this.buildStructure(true, (AnnotatedBase)node);
                return false;
            }
        }
        return true;
    }

    public boolean visit(UnionElement node) {
        GroupItem struct = this.buildStructure(false, (AnnotatedBase)node);
        CommonTypeDefinition[] types = node.getMemberTypeDefinitions();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                CommonTypeDefinition type = types[i];
                if (type.isPredefinedType()) {
                    struct.addValue((AnnotatedBase)node, type.getQName(), this.getSchemaType(type));
                    continue;
                }
                GroupItem hold = this.m_group;
                this.m_group = struct;
                this.addReference((AnnotatedBase)node, (AnnotatedBase)type);
                this.m_group = hold;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

