/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.jibx.schema.codegen.ClassBuilder;
import org.jibx.schema.codegen.ImportsTracker;
import org.jibx.schema.codegen.PackageHolder;

public class SourceBuilder {
    private static final Logger s_logger = Logger.getLogger((String)(class$org$jibx$schema$codegen$SourceBuilder == null ? (class$org$jibx$schema$codegen$SourceBuilder = SourceBuilder.class$("org.jibx.schema.codegen.SourceBuilder")) : class$org$jibx$schema$codegen$SourceBuilder).getName());
    private static final Map s_primitiveTypeCodes = new HashMap();
    private final AST m_ast;
    private final PackageHolder m_package;
    private final String m_name;
    private final CompilationUnit m_compilationUnit;
    protected final ImportsTracker m_importsTracker;
    private ArrayList m_classes;
    static /* synthetic */ Class class$org$jibx$schema$codegen$SourceBuilder;

    public SourceBuilder(AST ast, PackageHolder pack, String name, ImportsTracker imports) {
        this.m_ast = ast;
        this.m_package = pack;
        this.m_name = name;
        this.m_importsTracker = imports;
        this.m_classes = new ArrayList();
        this.m_compilationUnit = ast.newCompilationUnit();
        String pname = pack.getName();
        if (pname.length() > 0) {
            PackageDeclaration packageDeclaration = ast.newPackageDeclaration();
            packageDeclaration.setName(ast.newName(pname));
            this.m_compilationUnit.setPackage(packageDeclaration);
        }
    }

    AST getAST() {
        return this.m_ast;
    }

    public String getPackageName() {
        return this.m_package.getName();
    }

    private AbstractTypeDeclaration createClass(String cname, boolean isenum) {
        EnumDeclaration abstype;
        if (isenum) {
            abstype = this.m_ast.newEnumDeclaration();
        } else {
            TypeDeclaration type = this.m_ast.newTypeDeclaration();
            type.setInterface(false);
            abstype = type;
        }
        abstype.modifiers().add(this.m_ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        abstype.setName(this.m_ast.newSimpleName(cname));
        return abstype;
    }

    public ClassBuilder newMainClass(String cname, boolean isenum) {
        AbstractTypeDeclaration decl = this.createClass(cname, isenum);
        this.m_compilationUnit.types().add(decl);
        ClassBuilder builder = new ClassBuilder(decl, this);
        this.m_classes.add(builder);
        return builder;
    }

    public ClassBuilder newInnerClass(String cname, ClassBuilder outer, boolean isenum) {
        AbstractTypeDeclaration decl = this.createClass(cname, isenum);
        decl.modifiers().add(this.m_ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        return new ClassBuilder(decl, outer);
    }

    protected Name createTypeName(String type) {
        String name = this.m_importsTracker.getName(type);
        if (name.indexOf(46) > 0) {
            return this.m_ast.newName(name);
        }
        return this.m_ast.newSimpleName(name);
    }

    public Type createType(String type) {
        PrimitiveType.Code code;
        int arraydepth = 0;
        while (type.endsWith("[]")) {
            ++arraydepth;
            type = type.substring(0, type.length() - 2);
        }
        String typeparms = null;
        int split = type.indexOf(60);
        if (split > 0) {
            typeparms = type.substring(split + 1, type.length() - 1);
            type = type.substring(0, split);
        }
        Object tdef = (code = (PrimitiveType.Code)s_primitiveTypeCodes.get(type)) == null ? this.getAST().newSimpleType(this.createTypeName(type)) : this.getAST().newPrimitiveType(code);
        if (typeparms != null) {
            ParameterizedType ptype = this.getAST().newParameterizedType((Type)tdef);
            while ((split = typeparms.indexOf(44)) > 0) {
                ptype.typeArguments().add(this.createType(typeparms.substring(0, split)));
                typeparms = typeparms.substring(split + 1);
            }
            ptype.typeArguments().add(this.createType(typeparms));
            tdef = ptype;
        }
        if (arraydepth > 0) {
            tdef = this.getAST().newArrayType((Type)tdef, arraydepth);
        }
        return tdef;
    }

    public Type createParameterizedType(String type, String param) {
        ParameterizedType ptype = this.getAST().newParameterizedType(this.createType(type));
        ptype.typeArguments().add(this.createType(param));
        return ptype;
    }

    public void finish(boolean verbose) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.m_classes.size(); ++i) {
            ClassBuilder builder = (ClassBuilder)this.m_classes.get(i);
            builder.finish();
        }
        List imports = this.m_importsTracker.freeze(this.m_name);
        Iterator iter = imports.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            ImportDeclaration imp = this.m_ast.newImportDeclaration();
            imp.setName(this.m_ast.newName(type));
            this.m_compilationUnit.imports().add(imp);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.formatter.lineSplit", "80");
        options.put("org.eclipse.jdt.core.formatter.comment.line_length", "80");
        options.put("org.eclipse.jdt.core.formatter.comment.format_source_code", "true");
        options.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
        options.put("org.eclipse.jdt.core.formatter.tabulation.size", "4");
        options.put("org.eclipse.jdt.core.formatter.blank_lines_after_package", "1");
        options.put("org.eclipse.jdt.core.formatter.blank_lines_after_imports", "1");
        options.put("org.eclipse.jdt.core.formatter.blank_lines_before_package", "1");
        options.put("org.eclipse.jdt.core.formatter.blank_lines_before_imports", "1");
        options.put("org.eclipse.jdt.core.formatter.blank_lines_before_method", "1");
        options.put("org.eclipse.jdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.jdt.core.formatter.alignment_for_superinterfaces_in_type_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)2));
        options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        options.put("org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        Document doc = new Document(this.m_compilationUnit.toString());
        CodeFormatter fmtr = ToolFactory.createCodeFormatter(options);
        String text = doc.get();
        TextEdit edits = fmtr.format(8, text, 0, text.length(), 0, null);
        File gendir = this.m_package.getGenerateDirectory();
        if (gendir != null) {
            try {
                File file = new File(gendir, this.m_name + ".java");
                FileWriter fwrit = new FileWriter(file);
                WriterVisitor visitor = new WriterVisitor(text, fwrit);
                edits.accept((TextEditVisitor)visitor);
                visitor.finish();
                fwrit.flush();
                fwrit.close();
                s_logger.info((Object)("Generated class file " + file.getCanonicalPath() + " (writing AST took " + (System.currentTimeMillis() - start) + " ms.)"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Error in source generation: " + e.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_primitiveTypeCodes.put("boolean", PrimitiveType.BOOLEAN);
        s_primitiveTypeCodes.put("byte", PrimitiveType.BYTE);
        s_primitiveTypeCodes.put("char", PrimitiveType.CHAR);
        s_primitiveTypeCodes.put("double", PrimitiveType.DOUBLE);
        s_primitiveTypeCodes.put("float", PrimitiveType.FLOAT);
        s_primitiveTypeCodes.put("int", PrimitiveType.INT);
        s_primitiveTypeCodes.put("long", PrimitiveType.LONG);
        s_primitiveTypeCodes.put("short", PrimitiveType.SHORT);
        s_primitiveTypeCodes.put("void", PrimitiveType.VOID);
    }

    private static class WriterVisitor
    extends TextEditVisitor {
        private final String m_base;
        private final Writer m_writer;
        private int m_offset;

        public WriterVisitor(String base, Writer writer) {
            this.m_base = base;
            this.m_writer = writer;
        }

        private void skip(int offset) {
            if (offset > this.m_offset) {
                this.m_offset = offset;
            } else if (offset < this.m_offset) {
                throw new IllegalStateException();
            }
        }

        private void copy(int offset) {
            if (offset > this.m_offset) {
                try {
                    this.m_writer.write(this.m_base, this.m_offset, offset - this.m_offset);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error writing to file", e);
                }
                this.m_offset = offset;
            } else if (offset < this.m_offset) {
                throw new IllegalStateException();
            }
        }

        public boolean visit(DeleteEdit edit) {
            this.copy(edit.getOffset());
            this.skip(edit.getOffset() + edit.getLength());
            return super.visit(edit);
        }

        public boolean visit(InsertEdit edit) {
            this.copy(edit.getOffset());
            try {
                this.m_writer.write(edit.getText());
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to file", e);
            }
            return super.visit(edit);
        }

        public boolean visit(ReplaceEdit edit) {
            this.copy(edit.getOffset());
            this.skip(edit.getOffset() + edit.getLength());
            try {
                this.m_writer.write(edit.getText());
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing to file", e);
            }
            return super.visit(edit);
        }

        public void finish() {
            this.copy(this.m_base.length());
        }
    }
}

