/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.apache.log4j.Logger;
import org.jibx.runtime.QName;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.codegen.AnyItem;
import org.jibx.schema.codegen.ClassHolder;
import org.jibx.schema.codegen.DefinitionItem;
import org.jibx.schema.codegen.Item;
import org.jibx.schema.codegen.JavaType;
import org.jibx.schema.codegen.ReferenceItem;
import org.jibx.schema.codegen.TypeData;
import org.jibx.schema.codegen.ValueItem;
import org.jibx.schema.codegen.custom.ComponentExtension;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.ComplexExtensionElement;
import org.jibx.schema.elements.SchemaBase;

public class GroupItem
extends Item {
    private static final Logger s_logger = Logger.getLogger((String)GroupItem.class.getName());
    private boolean m_enumeration;
    private boolean m_inline;
    private String m_className;
    private int m_size;
    private Item m_head;
    private Item m_tail;
    private TypeData m_generateClass;
    private boolean m_allOptional;
    private boolean m_attributePresent;
    private boolean m_elementPresent;
    private boolean m_contentPresent;

    protected GroupItem(AnnotatedBase comp, GroupItem parent) {
        super(comp, parent);
        ComponentExtension exten = this.getComponentExtension();
        this.m_className = exten.getClassName();
        this.m_allOptional = true;
    }

    GroupItem(GroupItem original, Item ref, GroupItem parent) {
        super(original, ref, original.getComponentExtension(), parent);
        this.m_enumeration = original.m_enumeration;
        for (Item child = original.getFirstChild(); child != null; child = child.getNext()) {
            this.appendChild(child.copy(null, this));
        }
        this.m_inline = original.m_inline;
        this.m_className = original.m_className;
        if (parent == null || parent.getSchemaComponent() != this.getSchemaComponent()) {
            GroupItem top = (GroupItem)original.getTopmost();
            this.m_allOptional = top.m_allOptional;
            this.m_attributePresent = top.m_attributePresent;
            this.m_elementPresent = top.m_elementPresent;
            this.m_contentPresent = top.m_contentPresent;
        }
    }

    GroupItem(ReferenceItem reference, ComponentExtension ext) {
        super(reference, reference, ext, reference.getParent());
        this.m_inline = true;
        DefinitionItem definition = reference.getDefinition();
        int type = reference.getSchemaComponent().type();
        if (type == 6 || type == 16) {
            this.m_allOptional = definition.isAllOptional();
        }
        this.m_attributePresent = definition.isAttributePresent();
        this.m_elementPresent = definition.isElementPresent();
        this.m_contentPresent = definition.isContentPresent();
        this.appendChild(new GroupItem(definition, reference, this));
    }

    public boolean isEnumeration() {
        return this.m_enumeration;
    }

    public void setEnumeration(boolean enumeration) {
        this.m_enumeration = enumeration;
    }

    private void appendChild(Item item) {
        if (this.m_head == null) {
            this.m_head = this.m_tail = item;
        } else {
            this.m_tail.m_next = item;
            item.m_last = this.m_tail;
            this.m_tail = item;
        }
        ++this.m_size;
    }

    public GroupItem addGroup(AnnotatedBase comp) {
        GroupItem group = new GroupItem(comp, this);
        this.appendChild(group);
        return group;
    }

    public ReferenceItem addReference(AnnotatedBase comp, DefinitionItem ref) {
        ReferenceItem reference = new ReferenceItem(comp, this, ref);
        this.appendChild(reference);
        return reference;
    }

    public ValueItem addValue(AnnotatedBase comp, QName type, JavaType ref) {
        ValueItem item = new ValueItem(comp, type, ref, this);
        this.appendChild(item);
        return item;
    }

    public AnyItem addAny(AnnotatedBase comp) {
        AnyItem item = new AnyItem(comp, this);
        this.appendChild(item);
        return item;
    }

    void replaceChild(Item current, Item replace) {
        Item last = current.m_last;
        Item next = current.m_next;
        if (last == null) {
            this.m_head = replace;
        } else {
            last.m_next = replace;
        }
        replace.m_last = last;
        if (next == null) {
            this.m_tail = replace;
        } else {
            next.m_last = replace;
        }
        replace.m_next = next;
    }

    void adoptChildren(GroupItem group) {
        this.m_size = group.m_size;
        this.m_head = group.m_head;
        this.m_tail = group.m_tail;
        Item item = this.m_head;
        while (item != null) {
            item.reparent(this);
            item = item.m_next;
        }
    }

    public boolean isInline() {
        return this.m_inline;
    }

    public void setInline(boolean inline) {
        this.m_inline = inline;
    }

    public String getEffectiveClassName() {
        GroupItem item = this;
        while (item.getClassName() == null) {
            if ((item = item.getParent()) != null) continue;
            throw new IllegalStateException("Inherited class name with nothing to inherit");
        }
        return item.getClassName();
    }

    public String getClassName() {
        return this.m_className;
    }

    public boolean isFixedClassName() {
        return this.getComponentExtension().getClassName() != null;
    }

    public void setClassName(String name) {
        if (this.isFixedClassName()) {
            throw new IllegalStateException("Internal error - attempt to change configured class name");
        }
        this.m_className = name;
    }

    public int getChildCount() {
        return this.m_size;
    }

    public Item getFirstChild() {
        return this.m_head;
    }

    public TypeData getGenerateClass() {
        return this.m_generateClass;
    }

    public void setGenerateClass(TypeData clas) {
        this.m_generateClass = clas;
    }

    public boolean isExtensionReference() {
        return this.m_head instanceof ReferenceItem && this.m_head.getSchemaComponent().type() == 13;
    }

    public void convertTypeReference() {
        if (this.m_head instanceof ReferenceItem && (this.m_head == this.m_tail || this.m_head.getSchemaComponent() instanceof ComplexExtensionElement)) {
            DefinitionItem def = ((ReferenceItem)this.m_head).getDefinition();
            if (this.isEnumeration() == def.isEnumeration()) {
                TypeData base = def.getGenerateClass();
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Setting base class for " + this.m_generateClass.getFullName() + " to " + base.getFullName()));
                }
                ((ClassHolder)this.m_generateClass).setSuperClass(base);
                this.m_head.setImplicit(true);
            }
        }
    }

    protected Item copy(Item ref, GroupItem parent) {
        return new GroupItem(this, ref, parent);
    }

    protected void forceAttributePresent() {
        GroupItem parent;
        if (!this.m_attributePresent && this.getSchemaComponent().type() != 11 && (parent = this.getParent()) != null) {
            parent.forceAttributePresent();
        }
        this.m_attributePresent = true;
    }

    protected void forceElementPresent() {
        GroupItem parent;
        if (!this.m_elementPresent && this.getSchemaComponent().type() != 11 && (parent = this.getParent()) != null) {
            parent.forceElementPresent();
        }
        this.m_elementPresent = true;
    }

    protected void forceContentPresent() {
        GroupItem parent;
        if (!this.m_contentPresent && this.getSchemaComponent().type() != 11 && (parent = this.getParent()) != null) {
            parent.forceContentPresent();
        }
        this.m_contentPresent = true;
    }

    protected void forceRequiredPresent() {
        if (this.m_allOptional) {
            GroupItem parent;
            int type = this.getSchemaComponent().type();
            boolean skip = false;
            switch (type) {
                case 0: 
                case 7: 
                case 11: {
                    skip = true;
                    break;
                }
                case 35: {
                    skip = this.isOptional();
                }
            }
            if (!skip && (parent = this.getParent()) != null) {
                parent.forceContentPresent();
            }
        }
        this.m_allOptional = false;
    }

    protected void classifyContent() {
        super.classifyContent();
        for (Item item = this.m_head; item != null; item = item.getNext()) {
            item.classifyContent();
        }
        if (this.m_allOptional && !this.isOptional()) {
            switch (this.getSchemaComponent().type()) {
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    this.m_allOptional = false;
                }
            }
        }
    }

    public DefinitionItem convertToDefinition() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Converting " + SchemaUtils.describeComponent((SchemaBase)this.getSchemaComponent()) + " to freestanding definition"));
        }
        GroupItem parent = this;
        while (!(parent instanceof DefinitionItem)) {
            parent = parent.getParent();
        }
        DefinitionItem def = new DefinitionItem(this);
        if (def.getClassName() == null) {
            def.setClassName(this.getEffectiveClassName());
        }
        if (def.getName() == null) {
            def.setName(this.getEffectiveName());
        }
        ReferenceItem ref = new ReferenceItem(this, def);
        this.getParent().replaceChild(this, ref);
        return def;
    }

    public String nestedString(int depth, boolean classified) {
        ++depth;
        StringBuffer buff = new StringBuffer(400);
        for (Item child = this.getFirstChild(); child != null; child = child.getNext()) {
            buff.append(child.describe(depth, classified));
        }
        return buff.toString();
    }

    public boolean isAllOptional() {
        return this.m_allOptional;
    }

    public boolean isAttributePresent() {
        return this.m_attributePresent;
    }

    public boolean isElementPresent() {
        return this.m_elementPresent;
    }

    public boolean isContentPresent() {
        return this.m_contentPresent;
    }

    protected String describe(int depth, boolean classified) {
        StringBuffer buff = new StringBuffer(depth + 50);
        buff.append(this.leadString(depth));
        if (this.isInline()) {
            buff.append("inlined ");
        }
        if (this.m_enumeration) {
            buff.append("enumeration ");
        }
        AnnotatedBase comp = this.getSchemaComponent();
        if (this.isTopmost()) {
            if (classified) {
                if (this.m_attributePresent) {
                    if (this.m_contentPresent) {
                        buff.append("attribute+content ");
                    } else {
                        buff.append("attribute ");
                    }
                } else if (this.m_contentPresent) {
                    buff.append("content ");
                }
            }
        } else {
            buff.append("duplicate ");
        }
        buff.append("group with class name ");
        buff.append(this.getClassName());
        buff.append(" and value name ");
        buff.append(this.getName());
        if (classified && this.isTopmost()) {
            buff.append(this.m_allOptional ? " (all items optional)" : " (not all items optional)");
        }
        buff.append(": ");
        buff.append(SchemaUtils.describeComponent((SchemaBase)comp));
        buff.append('\n');
        buff.append(this.nestedString(depth, classified));
        return buff.toString();
    }
}

