/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl.tools;

public class SignatureParser {
    public static final int END_EVENT = 0;
    public static final int TYPE_EVENT = 1;
    public static final int METHOD_PARAMETERS_START_EVENT = 2;
    public static final int METHOD_PARAMETERS_END_EVENT = 3;
    public static final int TYPE_PARAMETERS_START_EVENT = 4;
    public static final int TYPE_PARAMETERS_END_EVENT = 5;
    private static final String STRING_SIGNATURE = "java/lang/String;";
    private static final String STRING_TYPE = "java.lang.String";
    private static final String OBJECT_SIGNATURE = "java/lang/Object;";
    private static final String OBJECT_TYPE = "java.lang.Object";
    private final String m_signature;
    private int m_offset;
    private int m_event;
    private boolean m_isPrimitive;
    private boolean m_isParameterized;
    private String m_type;

    public SignatureParser(String sig) {
        if (sig.startsWith("Signature(") && sig.endsWith(")")) {
            this.m_signature = sig.substring(10, sig.length() - 1);
            this.m_event = -1;
        } else if (sig.startsWith("Signature: (") && sig.indexOf(")") != -1) {
            this.m_signature = sig.indexOf(")") == sig.length() ? sig.substring(12, sig.length() - 1) : sig.substring(11, sig.length());
            this.m_event = -1;
        } else {
            throw new IllegalArgumentException("Internal error: not a valid Signature");
        }
    }

    public boolean isParameterized() {
        if (this.m_event == 1) {
            return this.m_isParameterized;
        }
        throw new IllegalStateException("Internal error: not at TYPE_EVENT");
    }

    public boolean isPrimitive() {
        if (this.m_event == 1) {
            return this.m_isPrimitive;
        }
        throw new IllegalStateException("Internal error: not at TYPE_EVENT");
    }

    public int getEvent() {
        return this.m_event;
    }

    public String getType() {
        if (this.m_event == 1) {
            return this.m_type;
        }
        throw new IllegalStateException("Internal error: not at TYPE_EVENT");
    }

    public int next() {
        if (this.m_event == 0) {
            throw new IllegalStateException("Internal error: cannot advance parser");
        }
        if (this.m_offset >= this.m_signature.length()) {
            this.m_event = 0;
        } else {
            this.m_event = 1;
            this.m_isPrimitive = true;
            this.m_isParameterized = false;
            char chr = this.m_signature.charAt(this.m_offset++);
            switch (chr) {
                case '(': {
                    this.m_event = 2;
                    break;
                }
                case ')': {
                    this.m_event = 3;
                    break;
                }
                case '<': {
                    this.m_event = 4;
                    break;
                }
                case '>': {
                    this.m_event = 5;
                    if (this.m_offset >= this.m_signature.length() || this.m_signature.charAt(this.m_offset) != ';') break;
                    ++this.m_offset;
                    break;
                }
                case 'B': {
                    this.m_type = "byte";
                    break;
                }
                case 'C': {
                    this.m_type = "char";
                    break;
                }
                case 'D': {
                    this.m_type = "double";
                    break;
                }
                case 'F': {
                    this.m_type = "float";
                    break;
                }
                case 'I': {
                    this.m_type = "int";
                    break;
                }
                case 'J': {
                    this.m_type = "long";
                    break;
                }
                case 'S': {
                    this.m_type = "short";
                    break;
                }
                case 'V': {
                    this.m_type = "void";
                    break;
                }
                case 'Z': {
                    this.m_type = "boolean";
                    break;
                }
                case 'L': {
                    this.m_isPrimitive = false;
                    if (this.m_signature.startsWith(STRING_SIGNATURE, this.m_offset)) {
                        this.m_offset += STRING_SIGNATURE.length();
                        this.m_type = STRING_TYPE;
                        break;
                    }
                    if (this.m_signature.startsWith(OBJECT_SIGNATURE, this.m_offset)) {
                        this.m_offset += OBJECT_SIGNATURE.length();
                        this.m_type = OBJECT_TYPE;
                        break;
                    }
                    StringBuffer buff = new StringBuffer();
                    boolean done = false;
                    while (this.m_offset < this.m_signature.length()) {
                        if ((chr = this.m_signature.charAt(this.m_offset++)) == '/') {
                            buff.append('.');
                            continue;
                        }
                        if (chr == ';') {
                            done = true;
                            break;
                        }
                        if (chr == '<') {
                            done = true;
                            --this.m_offset;
                            this.m_isParameterized = true;
                            break;
                        }
                        buff.append(chr);
                    }
                    if (!done) {
                        throw new IllegalStateException("Internal error: cannot interpret type");
                    }
                    this.m_type = buff.toString();
                    break;
                }
                default: {
                    throw new IllegalStateException("Internal error: signature parse state");
                }
            }
        }
        return this.m_event;
    }
}

