/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jibx.custom.CustomizationCommandLineBase;
import org.jibx.custom.classes.GlobalCustom;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.schema.generator.SchemaGenCommandLine;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.util.IClassLocator;
import org.jibx.util.ReflectionUtilities;
import org.jibx.ws.wsdl.tools.custom.WsdlCustom;

public class WsdlGeneratorCommandLine
extends SchemaGenCommandLine {
    private static final String[] EXTRA_USAGE_LINES = new String[]{" -b       generated root binding name (default is 'binding.xml')", " -d use pure doc/lit (not wrapped) style", " -u binding,...;schema,... existing bindings and schemas (separated by\n          semicolon) to be used for messages (referenced schemas are included\n          in WSDL)", " -x class,... names of extra classes to be included in binding"};
    private GlobalCustom m_global;
    private WsdlCustom m_wsdlCustom;
    private List m_extraTypes = new ArrayList();
    private List m_useBindings = new ArrayList();
    private List m_useSchemas = new ArrayList();
    private String m_bindingName = "binding.xml";
    private boolean m_docLit;

    public WsdlGeneratorCommandLine() {
        super(EXTRA_USAGE_LINES);
    }

    @Override
    public GlobalCustom getGlobal() {
        return this.m_global;
    }

    public WsdlCustom getWsdlCustom() {
        return this.m_wsdlCustom;
    }

    public String getBindingName() {
        return this.m_bindingName;
    }

    public List getExtraTypes() {
        return this.m_extraTypes;
    }

    public List getUseBindings() {
        return this.m_useBindings;
    }

    public List getUseSchemas() {
        return this.m_useSchemas;
    }

    public boolean isDocLit() {
        return this.m_docLit;
    }

    @Override
    protected boolean checkParameter(CustomizationCommandLineBase.ArgList alist) {
        String arg = alist.current();
        boolean match = true;
        if ("-b".equalsIgnoreCase(arg)) {
            this.m_bindingName = alist.next();
        } else if ("-d".equalsIgnoreCase(arg)) {
            this.m_docLit = true;
        } else if ("-u".equalsIgnoreCase(arg)) {
            String text = alist.next();
            int split = text.indexOf(59);
            if (split >= 0) {
                WsdlGeneratorCommandLine.splitItems(text.substring(split + 1), this.m_useSchemas);
                text = text.substring(0, split);
            }
            WsdlGeneratorCommandLine.splitItems(text, this.m_useBindings);
        } else if ("-x".equalsIgnoreCase(arg)) {
            String text = alist.next();
            if (text != null) {
                int split;
                int base = 0;
                while ((split = text.indexOf(44, base)) > 0) {
                    this.m_extraTypes.add(text.substring(base, split));
                    base = split + 1;
                }
                this.m_extraTypes.add(text.substring(base));
            }
        } else {
            match = super.checkParameter(alist);
        }
        return match;
    }

    @Override
    protected void loadCustomizations(String path, IClassLocator loc, ValidationContext vctx) throws JiBXException, IOException {
        this.setLocator(loc);
        this.m_global = new GlobalCustom(loc);
        if (path == null) {
            this.m_global.setAddConstructors(true);
            this.m_global.setForceClasses(true);
            this.m_global.setMapAbstract(Boolean.TRUE);
        } else {
            IBindingFactory fact = BindingDirectory.getFactory(WsdlCustom.class);
            IUnmarshallingContext ictx = fact.createUnmarshallingContext();
            FileInputStream is = new FileInputStream(path);
            ictx.setDocument((InputStream)is, null);
            ictx.setUserContext((Object)vctx);
            ((IUnmarshallable)this.m_global).unmarshal(ictx);
        }
        WsdlCustom custom = null;
        List extens = this.m_global.getExtensionChildren();
        for (Object exten : extens) {
            if (!(exten instanceof WsdlCustom)) continue;
            custom = (WsdlCustom)exten;
            break;
        }
        if (custom == null) {
            custom = new WsdlCustom(this.m_global);
            this.m_global.addExtensionChild(custom);
        }
        this.m_wsdlCustom = custom;
    }

    @Override
    protected Map applyOverrides(Map overmap) {
        Map unknowns = ReflectionUtilities.applyKeyValueMap((Map)overmap, (Object)this.m_global);
        unknowns = ReflectionUtilities.applyKeyValueMap((Map)unknowns, (Object)this.m_wsdlCustom);
        this.m_global.initClasses();
        this.m_global.fillClasses();
        return unknowns;
    }

    @Override
    public void printUsage() {
        System.out.println("\nUsage: java org.jibx.wsdl.Jibx2Wsdl [options] class1 class2 ...\nwhere options are:");
        String[] usages = this.getUsageLines();
        for (int i = 0; i < usages.length; ++i) {
            System.out.println(usages[i]);
        }
        System.out.println("The class# files are different classes to be exposed as services (references\nfrom these classes will automatically be included in the generated bindings).\n");
    }
}

