/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.codec;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jibx.ws.codec.CodecFactory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.codec.XmlCodec;

public final class CodecDirectory {
    public static final String TEXT_MEDIA_CODE = "xml";
    public static final MediaType TEXT_XML_MEDIA_TYPE = new MediaType("text", "xml");
    private static final String CODEC_PROPERTIES_PATH = "/codec.properties";
    private static final List s_orderedMediaTypes;
    private static final Map s_mediaMap;
    static /* synthetic */ Class class$org$jibx$ws$codec$CodecDirectory;
    static /* synthetic */ Class class$org$jibx$ws$codec$CodecFactory;

    private CodecDirectory() {
    }

    public static List getMediaTypes() {
        return s_orderedMediaTypes;
    }

    public static XmlCodec getCodec(MediaType mediaType) {
        String key = CodecDirectory.getCodecKey(mediaType);
        CodecFactory factory = (CodecFactory)s_mediaMap.get(key);
        if (factory == null) {
            return null;
        }
        return factory.createInstance(mediaType);
    }

    public static String getCodecKey(MediaType mediaType) {
        return mediaType.getBaseType();
    }

    public static boolean hasCodecFor(MediaType type) {
        return s_mediaMap.containsKey(type.getBaseType());
    }

    public static MediaType getAcceptableMediaType(String acceptString, MediaType contentType) throws ParseException {
        if (acceptString == null) {
            if (CodecDirectory.hasCodecFor(contentType)) {
                return contentType;
            }
            return (MediaType)s_orderedMediaTypes.get(0);
        }
        MediaType[] acceptTypes = CodecDirectory.parseAcceptString(acceptString);
        MediaType match = CodecDirectory.findSpecificTypeMatch(acceptTypes);
        if (match != null) {
            return match;
        }
        match = CodecDirectory.findTypeRangeMatch(acceptTypes);
        if (match != null) {
            return match;
        }
        if (CodecDirectory.containsMatchAll(acceptTypes)) {
            if (CodecDirectory.hasCodecFor(contentType)) {
                return contentType;
            }
            return (MediaType)s_orderedMediaTypes.get(0);
        }
        return null;
    }

    private static MediaType[] parseAcceptString(String acceptString) throws ParseException {
        StringTokenizer toke = new StringTokenizer(acceptString, ",");
        MediaType[] acceptTypes = new MediaType[toke.countTokens()];
        int i = 0;
        while (toke.hasMoreTokens()) {
            acceptTypes[i++] = new MediaType(toke.nextToken(), true);
        }
        return acceptTypes;
    }

    private static MediaType findSpecificTypeMatch(MediaType[] acceptTypes) {
        Iterator iterator = s_orderedMediaTypes.iterator();
        while (iterator.hasNext()) {
            MediaType mediaType = (MediaType)iterator.next();
            for (int i = 0; i < acceptTypes.length; ++i) {
                MediaType acceptType = acceptTypes[i];
                if (acceptType.getSubType().equals("*") || !acceptType.getSubType().equals(mediaType.getSubType()) || !acceptType.getPrimaryType().equals(mediaType.getPrimaryType())) continue;
                return mediaType;
            }
        }
        return null;
    }

    private static MediaType findTypeRangeMatch(MediaType[] acceptTypes) {
        Iterator iterator = s_orderedMediaTypes.iterator();
        while (iterator.hasNext()) {
            MediaType mediaType = (MediaType)iterator.next();
            for (int i = 0; i < acceptTypes.length; ++i) {
                MediaType acceptType = acceptTypes[i];
                if (!acceptType.getSubType().equals("*") || acceptType.getPrimaryType().equals("*") || !acceptType.getPrimaryType().equals(mediaType.getPrimaryType())) continue;
                return mediaType;
            }
        }
        return null;
    }

    private static boolean containsMatchAll(MediaType[] acceptTypes) {
        for (int i = 0; i < acceptTypes.length; ++i) {
            MediaType acceptType = acceptTypes[i];
            if (!acceptType.getSubType().equals("*") || !acceptType.getPrimaryType().equals("*")) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        InputStream in = null;
        try {
            final ArrayList mediaTypes = new ArrayList();
            Properties props = new Properties(){

                public synchronized Object put(Object arg0, Object arg1) {
                    try {
                        mediaTypes.add(new MediaType((String)arg0).freeze());
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Invalid media type '" + arg0 + "' in properties file '" + CodecDirectory.CODEC_PROPERTIES_PATH + "'");
                    }
                    return super.put(arg0, arg1);
                }
            };
            in = (class$org$jibx$ws$codec$CodecDirectory == null ? (class$org$jibx$ws$codec$CodecDirectory = CodecDirectory.class$("org.jibx.ws.codec.CodecDirectory")) : class$org$jibx$ws$codec$CodecDirectory).getResourceAsStream(CODEC_PROPERTIES_PATH);
            if (in == null) {
                throw new RuntimeException("Unable to load required properties file '/codec.properties'");
            }
            props.load(in);
            s_orderedMediaTypes = Collections.unmodifiableList(mediaTypes);
            s_mediaMap = new HashMap();
            Iterator<Object> iter = props.keySet().iterator();
            while (iter.hasNext()) {
                String mediatype = (String)iter.next();
                String classname = props.getProperty(mediatype);
                try {
                    Class<?> clas = (class$org$jibx$ws$codec$CodecDirectory == null ? CodecDirectory.class$("org.jibx.ws.codec.CodecDirectory") : class$org$jibx$ws$codec$CodecDirectory).getClassLoader().loadClass(classname);
                    if (!(class$org$jibx$ws$codec$CodecFactory == null ? CodecDirectory.class$("org.jibx.ws.codec.CodecFactory") : class$org$jibx$ws$codec$CodecFactory).isAssignableFrom(clas)) throw new IllegalStateException("Class " + classname + ", specified for format '" + mediatype + "', is not an org.jibx.ws.encoding.CodecFactory implementation");
                    s_mediaMap.put(mediatype.toLowerCase(), clas.newInstance());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to load encoding class " + classname);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Error creating an instance of encoding class " + classname);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unable to create an instance of encoding class " + classname);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load required properties file '/codec.properties'");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

