/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.codec;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jibx.ws.WsException;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.codec.XmlCodec;
import org.jibx.ws.util.ExpandingPool;

public final class CodecPool {
    private final Map m_codecMap = new HashMap();

    public CodecPool() {
        List mediaTypes = CodecDirectory.getMediaTypes();
        for (int i = 0; i < mediaTypes.size(); ++i) {
            MediaType mediaType = (MediaType)mediaTypes.get(i);
            XmlCodec codec = CodecDirectory.getCodec(mediaType);
            if (codec == null) continue;
            InstancePool pool = new InstancePool(mediaType);
            pool.releaseInstance(codec);
            this.m_codecMap.put(CodecDirectory.getCodecKey(mediaType), pool);
        }
    }

    public XmlCodec getCodec(MediaType mediaType) throws IOException, WsException {
        String key = CodecDirectory.getCodecKey(mediaType);
        InstancePool pool = (InstancePool)this.m_codecMap.get(key);
        if (pool == null) {
            throw new IOException("Unsupported media type '" + mediaType + "'");
        }
        return (XmlCodec)pool.getInstance();
    }

    public void releaseCodec(XmlCodec codec) {
        String key = CodecDirectory.getCodecKey(codec.getMediaType());
        InstancePool pool = (InstancePool)this.m_codecMap.get(key);
        pool.releaseInstance(codec);
    }

    private static class InstancePool
    extends ExpandingPool {
        private final MediaType m_mediaType;

        public InstancePool(MediaType mediaType) {
            this.m_mediaType = mediaType;
        }

        protected Object createInstance() {
            return CodecDirectory.getCodec(this.m_mediaType);
        }
    }
}

