/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.codec;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class MediaType {
    private final String m_primaryType;
    private final String m_subtype;
    private List m_parameterList;
    private int m_hashCode;
    public static final MediaType ALL_MEDIA_TYPES = new MediaType("*", "*");
    private String m_longString;
    private String m_baseType;
    private boolean m_frozen;

    public MediaType(String primaryType, String subType, List parameterList) {
        if (primaryType == null || primaryType.length() == 0 || subType == null || subType.length() == 0) {
            throw new IllegalArgumentException("Media type and subtype must both be non-null, non-empty strings");
        }
        if (parameterList == null) {
            throw new IllegalArgumentException("ParameterList must be non-null");
        }
        this.m_primaryType = primaryType.toLowerCase();
        this.m_subtype = subType.toLowerCase();
        this.m_parameterList = parameterList;
    }

    public MediaType(String primaryType, String subType) {
        this(primaryType, subType, Collections.EMPTY_LIST);
    }

    public MediaType(String mediaType) throws ParseException {
        this(mediaType, false);
    }

    public MediaType(String mediaType, boolean ignoreParameters) throws ParseException {
        try {
            StringTokenizer st = new StringTokenizer(mediaType, "/");
            this.m_primaryType = st.nextToken().trim().toLowerCase();
            this.m_subtype = st.nextToken(";").trim().toLowerCase().substring(1);
            if (this.m_primaryType.length() == 0 || this.m_subtype.length() == 0) {
                throw new ParseException("Type and subtype must contain values in '" + mediaType + "'", -1);
            }
            if (ignoreParameters) {
                this.m_parameterList = Collections.EMPTY_LIST;
            } else {
                this.m_parameterList = new ArrayList();
                while (st.hasMoreTokens()) {
                    this.addParameter(Parameter.parse(st.nextToken().trim()));
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new ParseException("Unable to parse mediaType '" + mediaType + "'", -1);
        }
    }

    public void addParameter(Parameter parameter) {
        if (this.m_frozen) {
            throw new IllegalStateException("MediaType is frozen");
        }
        if (this.m_parameterList.isEmpty()) {
            this.m_parameterList = new ArrayList();
        }
        this.m_parameterList.add(parameter);
        this.m_longString = null;
    }

    public String getPrimaryType() {
        return this.m_primaryType;
    }

    public String getSubType() {
        return this.m_subtype;
    }

    public List getParameterList() {
        return Collections.unmodifiableList(this.m_parameterList);
    }

    public String toString() {
        if (this.m_longString == null) {
            StringBuffer buff = new StringBuffer(64);
            buff.append(this.getBaseType());
            Iterator iterator = this.m_parameterList.iterator();
            while (iterator.hasNext()) {
                Parameter param = (Parameter)iterator.next();
                buff.append("; ").append(param.m_name).append('=').append(param.m_value);
            }
            this.m_longString = buff.toString();
        }
        return this.m_longString;
    }

    public String toStringWithParams(Parameter[] extraParams) {
        StringBuffer buff = new StringBuffer(64);
        buff.append(this.toString());
        for (int i = 0; i < extraParams.length; ++i) {
            Parameter param = extraParams[i];
            if (param == null) continue;
            buff.append("; ").append(param.m_name).append('=').append(param.m_value);
        }
        return buff.toString();
    }

    public String getBaseType() {
        if (this.m_baseType == null) {
            StringBuffer buff = new StringBuffer(64);
            buff.append(this.m_primaryType).append('/').append(this.m_subtype);
            this.m_baseType = buff.toString();
        }
        return this.m_baseType;
    }

    public int hashCode() {
        int prime = 31;
        if (this.m_hashCode == 0) {
            this.m_hashCode = 1;
            this.m_hashCode = 31 * this.m_hashCode + (this.m_parameterList == null ? 0 : ((Object)this.m_parameterList).hashCode());
            this.m_hashCode = 31 * this.m_hashCode + (this.m_subtype == null ? 0 : this.m_subtype.hashCode());
            this.m_hashCode = 31 * this.m_hashCode + (this.m_primaryType == null ? 0 : this.m_primaryType.hashCode());
        }
        return this.m_hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaType other = (MediaType)obj;
        if (!this.m_subtype.equals(other.m_subtype)) {
            return false;
        }
        if (!this.m_primaryType.equals(other.m_primaryType)) {
            return false;
        }
        return ((Object)this.m_parameterList).equals(other.m_parameterList);
    }

    public boolean accepts(MediaType other) {
        if (this == ALL_MEDIA_TYPES) {
            return true;
        }
        if (this.m_subtype.equals("*") && (this.m_primaryType.equals(other.m_primaryType) || this.m_primaryType.equals("*"))) {
            return true;
        }
        return this.m_subtype.equals(other.m_subtype) && this.m_primaryType.equals(other.m_primaryType);
    }

    public MediaType freeze() {
        this.m_frozen = true;
        return this;
    }

    public static final class Parameter {
        private final String m_name;
        private final String m_value;
        private int m_hashCode;

        public Parameter(String name) {
            this(name, null);
        }

        public Parameter(String name, String value) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("Media type parameter name must be non-null, non-empty string");
            }
            this.m_name = name;
            this.m_value = value;
        }

        private static Parameter parse(String mediaTypeParam) {
            int sep = mediaTypeParam.indexOf(61);
            if (sep == -1) {
                return new Parameter(mediaTypeParam);
            }
            return new Parameter(mediaTypeParam.substring(0, sep), mediaTypeParam.substring(sep + 1));
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }

        public int hashCode() {
            int prime = 31;
            if (this.m_hashCode == 0) {
                this.m_hashCode = 1;
                this.m_hashCode = 31 * this.m_hashCode + this.m_name.hashCode();
                this.m_hashCode = 31 * this.m_hashCode + (this.m_value == null ? 0 : this.m_value.hashCode());
            }
            return this.m_hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            if (!this.m_name.equals(other.m_name)) {
                return false;
            }
            if (this.m_value == null) {
                return other.m_value == null;
            }
            return this.m_value.equals(other.m_value);
        }
    }
}

