/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.encoding.dime;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.ws.encoding.dime.DimeCommon;

public class DimeInputBuffer
implements IInByteBuffer {
    private static final Log s_logger = LogFactory.getLog((Class)(class$org$jibx$ws$encoding$dime$DimeInputBuffer == null ? (class$org$jibx$ws$encoding$dime$DimeInputBuffer = DimeInputBuffer.class$("org.jibx.ws.encoding.dime.DimeInputBuffer")) : class$org$jibx$ws$encoding$dime$DimeInputBuffer));
    private int m_messageState = 3;
    private IInByteBuffer m_byteBuffer;
    private byte[] m_buffer;
    private int m_endOffset;
    private int m_emptyOffset;
    private int m_sizeRemaining;
    private int m_paddingNeeded;
    private boolean m_chunked;
    private String m_partIdentifier;
    private int m_partTypeCode;
    private String m_partTypeText;
    static /* synthetic */ Class class$org$jibx$ws$encoding$dime$DimeInputBuffer;

    public void setBuffer(IInByteBuffer buff) {
        if (this.m_byteBuffer != null && this.m_byteBuffer != buff) {
            try {
                this.m_byteBuffer.finish();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_byteBuffer = buff;
        this.m_buffer = buff.getBuffer();
        this.m_messageState = 3;
        this.m_sizeRemaining = 0;
        this.m_endOffset = 0;
        this.m_emptyOffset = 0;
        this.m_chunked = false;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Set buffer to instance of " + buff.getClass().getName()));
        }
    }

    private int buildShort(int offset) {
        return ((this.m_buffer[offset] & 0xFF) << 8) + (this.m_buffer[offset + 1] & 0xFF);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readHeader(int retain) throws IOException {
        if (!this.m_byteBuffer.require(retain + 12 + this.m_paddingNeeded)) {
            return false;
        }
        this.m_buffer = this.m_byteBuffer.getBuffer();
        byte[] buffer = this.m_buffer;
        int start = this.m_byteBuffer.getOffset();
        int offset = start + retain + this.m_paddingNeeded;
        boolean debug = s_logger.isDebugEnabled();
        if (debug) {
            s_logger.debug((Object)("Read header:" + DimeCommon.dumpBytes(buffer, offset, 12)));
        }
        boolean first = true;
        this.m_chunked = false;
        byte byt = buffer[offset];
        int version = byt & 0xF8;
        if (version != 8) {
            s_logger.error((Object)("Invalid DIME version: " + version));
            throw new IOException("Invalid DIME version");
        }
        if ((byt & 4) != 0) {
            if (this.m_messageState != 0) {
                s_logger.error((Object)"Unexpected MB (Message Begin) DIME record");
                throw new IOException("Unexpected MB (Message Begin) DIME record");
            }
            this.m_messageState = 1;
        } else if (this.m_messageState == 0) {
            s_logger.error((Object)"Missing expected MB (Message Begin) DIME record");
            throw new IOException("Missing expected MB (Message Begin) DIME record");
        }
        if ((byt & 1) != 0) {
            this.m_chunked = true;
            if (this.m_messageState == 1) {
                this.m_messageState = 2;
            } else {
                if (this.m_messageState != 2) {
                    s_logger.error((Object)"Invalid CF (Chunk Flag) DIME record");
                    throw new IOException("Invalid CF (Chunk Flag) DIME record");
                }
                first = false;
            }
        } else if (this.m_messageState == 2) {
            this.m_messageState = 1;
            first = false;
        }
        if ((byt & 2) != 0) {
            if (this.m_messageState != 1) {
                s_logger.error((Object)"Unexpected ME (Message End) DIME record");
                throw new IOException("Unexpected ME (Message End) DIME record");
            }
            this.m_messageState = 3;
        }
        byt = buffer[offset + 1];
        if (!first) {
            if (byt != 0) {
                s_logger.error((Object)"DIME chunk record read with non-zero type or reserved field");
                throw new IOException("DIME chunk record read with non-zero type or reserved field");
            }
        } else {
            this.m_partTypeCode = byt & 0xF0;
            if ((byt & 0xFFFFFF0F) != 0) {
                s_logger.error((Object)"DIME record read with non-zero reserved field");
                throw new IOException("DIME record read with non-zero reserved field");
            }
        }
        int optlength = this.buildShort(offset + 2);
        int idlength = this.buildShort(offset + 4);
        int typelength = this.buildShort(offset + 6);
        int length = (this.buildShort(offset + 8) << 16) + this.buildShort(offset + 10);
        if (first) {
            int optpadded = optlength + 3 & 0xFFFFFFFC;
            int idpadded = idlength + 3 & 0xFFFFFFFC;
            int typepadded = typelength + 3 & 0xFFFFFFFC;
            this.m_byteBuffer.require(length + optpadded + idpadded + typepadded);
            buffer = this.m_byteBuffer.getBuffer();
            start = this.m_byteBuffer.getOffset();
            offset = start + retain + this.m_paddingNeeded + 12 + optpadded;
            if (idlength > 0) {
                this.m_partIdentifier = new String(buffer, offset, idlength, "UTF-8");
                offset += idpadded;
            } else {
                this.m_partIdentifier = null;
            }
            if (typelength > 0) {
                this.m_partTypeText = new String(buffer, offset, typelength, "UTF-8");
                offset += typepadded;
            } else {
                this.m_partTypeText = null;
            }
        } else {
            if (optlength != 0 || idlength != 0 || typelength != 0) {
                s_logger.error((Object)"DIME chunk record read with non-zero field length(s)");
                throw new IOException("DIME chunk record read with non-zero field length(s)");
            }
            offset += 12;
        }
        if (retain > 0) {
            System.arraycopy(buffer, start, buffer, offset -= retain, retain);
            this.m_byteBuffer.setOffset(offset);
        }
        this.m_buffer = buffer;
        this.m_emptyOffset = offset;
        this.m_endOffset = this.m_byteBuffer.getLimit();
        int limit = offset + retain + length;
        if (this.m_endOffset > limit) {
            this.m_sizeRemaining = 0;
            this.m_endOffset = limit;
        } else {
            this.m_sizeRemaining = limit - this.m_endOffset;
        }
        this.m_paddingNeeded = (length + 3 & 0xFFFFFFFC) - length;
        if (debug) {
            s_logger.debug((Object)("Processed header with data size " + length + " and message state " + this.m_messageState + ", empty at " + this.m_emptyOffset + " and limit " + this.m_endOffset + ", with " + this.m_sizeRemaining + " remaining in block (needs " + this.m_paddingNeeded + " bytes padding)"));
        }
        return true;
    }

    private boolean nextChunk() throws IOException {
        if (this.m_chunked) {
            this.m_byteBuffer.setOffset(this.m_emptyOffset);
            if (this.readHeader(this.m_endOffset - this.m_emptyOffset)) {
                return true;
            }
            s_logger.error((Object)"Missing final DIME record chunk");
            throw new IOException("Missing final DIME record chunk");
        }
        return false;
    }

    public boolean nextPart() throws IOException {
        s_logger.debug((Object)"Advancing to next part");
        while (true) {
            if (this.m_sizeRemaining > 0) {
                this.m_byteBuffer.setOffset(this.m_endOffset);
                this.m_byteBuffer.require(1);
                int offset = this.m_byteBuffer.getOffset();
                this.m_endOffset = this.m_byteBuffer.getLimit();
                int avail = this.m_endOffset - offset;
                if (avail >= this.m_sizeRemaining) {
                    this.m_endOffset = offset + this.m_sizeRemaining;
                    this.m_sizeRemaining = 0;
                    continue;
                }
                this.m_sizeRemaining -= avail;
                continue;
            }
            this.m_emptyOffset = this.m_endOffset;
            if (!this.nextChunk()) break;
        }
        this.m_byteBuffer.setOffset(this.m_emptyOffset);
        if (this.m_messageState != 3) {
            if (this.readHeader(0)) {
                return true;
            }
            s_logger.error((Object)"End of input before end of message");
            throw new IOException("End of input before end of message");
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"End of message reached");
        }
        return false;
    }

    public String getPartIdentifier() {
        return this.m_partIdentifier;
    }

    public int getPartTypeCode() {
        return this.m_partTypeCode;
    }

    public String getPartTypeText() {
        return this.m_partTypeText;
    }

    public boolean nextMessage() throws IOException {
        s_logger.debug((Object)"Checking for next message");
        while (this.nextPart()) {
            this.m_byteBuffer.setOffset(this.m_endOffset);
        }
        this.m_messageState = 0;
        int size = 12 + this.m_paddingNeeded;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Attempting to read required " + size + " bytes of data"));
        }
        boolean ret = this.m_byteBuffer.require(size);
        this.m_buffer = null;
        this.m_emptyOffset = this.m_endOffset = this.m_byteBuffer.getOffset();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Returning " + ret));
        }
        return ret;
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public int getOffset() {
        return this.m_emptyOffset;
    }

    public void setOffset(int offset) {
        this.m_emptyOffset = offset;
        this.m_byteBuffer.setOffset(offset);
    }

    public int getLimit() {
        return this.m_endOffset;
    }

    public boolean require(int size) throws IOException {
        if (this.m_buffer == null) {
            throw new IllegalStateException("Internal error - not inside message part");
        }
        int avail = this.m_endOffset - this.m_emptyOffset;
        if (size > avail) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Require " + size + " with " + avail + " available and " + this.m_sizeRemaining + " remaining in block"));
            }
            do {
                if (this.m_sizeRemaining == 0) {
                    if (!this.nextChunk()) {
                        return false;
                    }
                    avail = this.m_endOffset - this.m_emptyOffset;
                    continue;
                }
                int request = size;
                int limit = avail + this.m_sizeRemaining;
                if (size > limit) {
                    request = limit;
                }
                this.m_byteBuffer.setOffset(this.m_emptyOffset);
                boolean result = this.m_byteBuffer.require(request);
                this.m_buffer = this.m_byteBuffer.getBuffer();
                this.m_emptyOffset = this.m_byteBuffer.getOffset();
                this.m_endOffset = this.m_byteBuffer.getLimit();
                avail = this.m_endOffset - this.m_emptyOffset;
                if (avail > limit) {
                    this.m_endOffset = this.m_emptyOffset + limit;
                    this.m_sizeRemaining = 0;
                } else {
                    this.m_sizeRemaining = limit - avail;
                }
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Requested more data with result " + result + ", empty at " + this.m_emptyOffset + " and limit " + this.m_endOffset + ", with " + this.m_sizeRemaining + " remaining in block"));
                }
                if (result) continue;
                return false;
            } while (size > avail);
            s_logger.debug((Object)"Got required bytes");
            return true;
        }
        return true;
    }

    public void finish() throws IOException {
        while (this.nextPart()) {
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

