/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.http.client.javase;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.text.ParseException;
import java.util.Iterator;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.InByteBuffer;
import org.jibx.runtime.impl.OutByteBuffer;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.codec.CodecCache;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.http.client.javase.HttpTransportOptions;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.transport.Channel;
import org.jibx.ws.transport.DuplexConnection;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;
import org.jibx.ws.transport.OutConnection;
import org.jibx.ws.transport.OutConnectionBase;
import org.jibx.ws.transport.SimpleDuplexConnection;
import org.jibx.ws.transport.StreamBufferInPool;
import org.jibx.ws.transport.StreamBufferOutPool;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;

public final class HttpChannel
implements Channel {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET_KEY = "charset";
    private static final String ACTION_KEY = "action";
    private static final String ACCEPT_TYPE = "Accept";
    private static final int BUFFER_SIZE = 8192;
    private final URL m_url;
    private final CodecCache m_codecCache;
    private final StreamBufferInPool m_inBufferCache;
    private final StreamBufferOutPool m_outBufferCache;
    private HttpTransportOptions m_transportOptions;

    public HttpChannel(URL url, HttpTransportOptions transportOptions) {
        this.m_url = url;
        this.m_transportOptions = transportOptions;
        this.m_codecCache = new CodecCache();
        this.m_inBufferCache = new StreamBufferInPool(8192);
        this.m_outBufferCache = new StreamBufferOutPool(8192);
    }

    private static void setupOutput(HttpURLConnection connection, MessageProperties props) throws ProtocolException {
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty(CONTENT_TYPE, HttpChannel.getContentTypeProperty(props));
        connection.setRequestProperty(ACCEPT_TYPE, HttpChannel.getAcceptTypeProperty(props));
        Iterator iter = props.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            connection.setRequestProperty(propertyName, props.getProperty(propertyName));
        }
    }

    private static String getContentTypeProperty(MessageProperties props) {
        MediaType contentType = props.getContentType();
        MediaType.Parameter charset = null;
        MediaType.Parameter action = null;
        if (props.getCharset() != null) {
            charset = new MediaType.Parameter(CHARSET_KEY, props.getCharset().toLowerCase());
        }
        if (props.getOperation() != null) {
            action = new MediaType.Parameter(ACTION_KEY, props.getOperation());
        }
        return contentType.toStringWithParams(new MediaType.Parameter[]{charset, action});
    }

    private static String getAcceptTypeProperty(MessageProperties props) {
        MediaType[] acceptTypes = props.getAcceptTypes();
        if (acceptTypes == null || acceptTypes.length == 0) {
            throw new IllegalArgumentException("Internal JiBX/WS error. Expected Accept media type(s) to be set.");
        }
        StringBuffer buff = new StringBuffer(64);
        for (int i = 0; i < acceptTypes.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(acceptTypes[i].toString());
        }
        return buff.toString();
    }

    public InConnection getInbound() throws IOException, WsConfigurationException {
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        connection.connect();
        return this.createInConnection(connection);
    }

    public OutConnection getOutbound(MessageProperties properties, XmlOptions xmlOptions) throws IOException, WsConfigurationException {
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        connection.setDoInput(false);
        HttpChannel.setupOutput(connection, properties);
        connection.connect();
        return this.createOutConnection(connection, properties, xmlOptions);
    }

    public DuplexConnection getDuplex(MessageProperties properties, XmlOptions xmlOptions) throws IOException, WsConfigurationException {
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        connection.setDoInput(true);
        HttpChannel.setupOutput(connection, properties);
        connection.connect();
        return new SimpleDuplexConnection(this.createInConnection(connection), this.createOutConnection(connection, properties, xmlOptions));
    }

    private HttpInConnection createInConnection(HttpURLConnection connection) throws WsConfigurationException {
        HttpInConnection inConn = new HttpInConnection(connection);
        if (this.m_transportOptions.getInputStreamInterceptor() != null) {
            inConn.setInterceptor(this.m_transportOptions.getInputStreamInterceptor());
        }
        return inConn;
    }

    private HttpOutConnection createOutConnection(HttpURLConnection connection, MessageProperties properties, XmlOptions xmlOptions) throws WsConfigurationException {
        HttpOutConnection outConn = new HttpOutConnection(connection, properties, xmlOptions);
        if (this.m_transportOptions.getOutputStreamInterceptor() != null) {
            outConn.setInterceptor(this.m_transportOptions.getOutputStreamInterceptor());
        }
        return outConn;
    }

    public void close() {
    }

    private class HttpOutConnection
    extends OutConnectionBase {
        private final HttpURLConnection m_connection;
        private OutByteBuffer m_buffer;
        private IXMLWriter m_writer;
        private OutputStreamInterceptor m_interceptor;
        private MessageProperties m_msgProps;

        public HttpOutConnection(HttpURLConnection connection, MessageProperties msgProps, XmlOptions xmlOptions) {
            super(xmlOptions);
            this.m_connection = connection;
            this.m_msgProps = msgProps;
        }

        public IXMLWriter getNormalWriter(String[] uris) throws IOException, WsException {
            if (this.m_writer == null) {
                this.m_buffer = (OutByteBuffer)HttpChannel.this.m_outBufferCache.getInstance();
                OutputStream outputStream = this.m_connection.getOutputStream();
                if (this.m_interceptor != null) {
                    outputStream = this.m_interceptor.intercept(outputStream);
                }
                this.m_buffer.setOutput(outputStream);
                this.m_writer = HttpChannel.this.m_codecCache.getCodec(this.m_msgProps.getContentType()).getWriter((IOutByteBuffer)this.m_buffer, null, uris);
                this.initializeWriter(this.m_writer);
            }
            return this.m_writer;
        }

        public IXMLWriter getFaultWriter(String[] uris) throws IOException, WsException {
            return this.getNormalWriter(uris);
        }

        public void setInterceptor(OutputStreamInterceptor interceptor) throws WsConfigurationException {
            if (this.m_interceptor != null) {
                throw new WsConfigurationException("Only a single output stream interceptor is supported.");
            }
            this.m_interceptor = interceptor;
        }

        public void outputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.outputComplete();
            }
        }

        public void close() throws IOException {
            if (this.m_writer != null) {
                this.m_writer.close();
                this.m_writer.reset();
            }
            if (this.m_buffer != null) {
                HttpChannel.this.m_outBufferCache.endUsage(this.m_buffer);
                this.m_buffer = null;
            }
        }
    }

    private class HttpInConnection
    implements InConnection {
        private static final int MIN_HTTP_ERROR_CODE = 400;
        private static final int ERROR_BUFFER_SIZE = 4000;
        private final HttpURLConnection m_connection;
        private InByteBuffer m_buffer;
        private IXMLReader m_reader;
        private InputStreamInterceptor m_interceptor;

        public HttpInConnection(HttpURLConnection connection) {
            this.m_connection = connection;
        }

        public void init() throws IOException, WsException {
            this.getReader();
            this.m_reader.init();
        }

        public String getCharacterEncoding() {
            return this.m_connection.getContentEncoding();
        }

        public String getContentType() {
            return this.m_connection.getContentType();
        }

        public String getDestination() {
            return null;
        }

        public String getId() {
            return null;
        }

        public String getOperationName() {
            int i;
            String opname = null;
            String contentTypeProp = this.getProperty(HttpChannel.CONTENT_TYPE);
            if (contentTypeProp != null && (i = contentTypeProp.indexOf("action=")) != -1) {
                opname = contentTypeProp.substring(i);
            }
            return opname;
        }

        public String getOrigin() {
            return null;
        }

        public String getProperty(String name) {
            return this.m_connection.getHeaderField(name);
        }

        public IXMLReader getReader() throws IOException, WsException {
            if (this.m_reader == null) {
                MediaType mediaType = this.getContentMediaType();
                this.m_buffer = (InByteBuffer)HttpChannel.this.m_inBufferCache.getInstance();
                InputStream inputStream = this.hasError() ? this.m_connection.getErrorStream() : this.m_connection.getInputStream();
                if (this.m_interceptor != null) {
                    inputStream = this.m_interceptor.intercept(inputStream);
                }
                this.m_buffer.setInput(inputStream);
                this.m_reader = HttpChannel.this.m_codecCache.getCodec(mediaType).getReader((IInByteBuffer)this.m_buffer, this.getCharacterEncoding(), this.m_connection.getURL().toExternalForm(), true);
            }
            return this.m_reader;
        }

        private MediaType getContentMediaType() throws IOException {
            MediaType mediaType = null;
            String ctype = this.getContentType();
            if (ctype != null) {
                MediaType contentType;
                try {
                    contentType = new MediaType(ctype);
                }
                catch (ParseException e) {
                    throw new IOException("Unable to parse content-type '" + ctype + "'");
                }
                if (CodecDirectory.hasCodecFor(contentType)) {
                    mediaType = contentType;
                }
            }
            if (mediaType == null) {
                mediaType = CodecDirectory.TEXT_XML_MEDIA_TYPE;
            }
            return mediaType;
        }

        public boolean hasError() throws IOException {
            return this.m_connection.getResponseCode() >= 400;
        }

        public String getErrorMessage() throws IOException {
            String line;
            if (!this.hasError()) {
                return null;
            }
            StringBuffer error = new StringBuffer(4000);
            String newLine = System.getProperty("line.separator");
            error.append(this.m_connection.getResponseCode()).append(" ").append(this.m_connection.getResponseMessage()).append(newLine);
            InputStream errorStream = this.m_connection.getErrorStream();
            if (this.m_interceptor != null) {
                errorStream = this.m_interceptor.intercept(errorStream);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(errorStream));
            while ((line = in.readLine()) != null) {
                error.append(line).append(newLine);
            }
            return error.toString();
        }

        public void setInterceptor(InputStreamInterceptor interceptor) throws WsConfigurationException {
            if (this.m_interceptor != null) {
                throw new WsConfigurationException("Only a single input stream interceptor is supported.");
            }
            this.m_interceptor = interceptor;
        }

        public void inputComplete() {
            if (this.m_interceptor != null) {
                this.m_interceptor.inputComplete();
            }
        }

        public void close() throws IOException {
            if (this.m_buffer != null) {
                HttpChannel.this.m_inBufferCache.endUsage(this.m_buffer);
                this.m_buffer = null;
            }
            this.m_reader = null;
        }
    }
}

