/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.http.servlet;

import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.http.servlet.HttpServletOptionsDefinition;
import org.jibx.ws.server.TransportOptions;
import org.jibx.ws.transport.interceptor.InputStreamInterceptor;
import org.jibx.ws.transport.interceptor.OutputStreamInterceptor;

public final class HttpServletOptions
implements TransportOptions {
    private InputStreamInterceptor m_inputStreamInterceptor;
    private OutputStreamInterceptor m_outputStreamInterceptor;

    public HttpServletOptions(HttpServletOptionsDefinition hsodef) throws WsConfigurationException {
        Object interceptor;
        if (hsodef.getInputStreamInterceptorDefinition() != null) {
            interceptor = hsodef.getInputStreamInterceptorDefinition().getObject();
            if (!(interceptor instanceof InputStreamInterceptor)) {
                throw new WsConfigurationException("Error: Interceptor class '" + interceptor.getClass() + "' must implement InputStreamInterceptor");
            }
            this.m_inputStreamInterceptor = (InputStreamInterceptor)interceptor;
        }
        if (hsodef.getOutputStreamInterceptorDefinition() != null) {
            interceptor = hsodef.getOutputStreamInterceptorDefinition().getObject();
            if (!(interceptor instanceof OutputStreamInterceptor)) {
                throw new WsConfigurationException("Error: Interceptor class '" + interceptor.getClass() + "' must implement OutputStreamInterceptor");
            }
            this.m_outputStreamInterceptor = (OutputStreamInterceptor)interceptor;
        }
    }

    public void setMessageContexts(InContext inCtx, OutContext outCtx) {
        if (this.m_inputStreamInterceptor != null) {
            this.m_inputStreamInterceptor.setMessageContext(inCtx);
        }
        if (this.m_outputStreamInterceptor != null) {
            this.m_outputStreamInterceptor.setMessageContext(outCtx);
        }
    }

    public InputStreamInterceptor getInputStreamInterceptor() {
        return this.m_inputStreamInterceptor;
    }

    public OutputStreamInterceptor getOutputStreamInterceptor() {
        return this.m_outputStreamInterceptor;
    }
}

