/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.ws.WsException;
import org.jibx.ws.http.servlet.ServiceMapper;
import org.jibx.ws.protocol.ProtocolDirectory;
import org.jibx.ws.server.Service;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceFactory;
import org.jibx.ws.server.ServicePool;

public final class PathBasedServiceMapper
implements ServiceMapper {
    private static final long serialVersionUID = -4161361963133295719L;
    private static final Log logger = LogFactory.getLog((Class)(class$org$jibx$ws$http$servlet$PathBasedServiceMapper == null ? (class$org$jibx$ws$http$servlet$PathBasedServiceMapper = PathBasedServiceMapper.class$("org.jibx.ws.http.servlet.PathBasedServiceMapper")) : class$org$jibx$ws$http$servlet$PathBasedServiceMapper));
    private static HashMap s_servletMap = new HashMap();
    private Map m_serviceDefnMap;
    static /* synthetic */ Class class$org$jibx$ws$http$servlet$PathBasedServiceMapper;
    static /* synthetic */ Class class$org$jibx$ws$server$ServiceDefinition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PathBasedServiceMapper(HttpServlet servlet) throws UnavailableException {
        String key;
        String sname = servlet.getServletName();
        if (sname.equals(servlet.getClass().getName())) {
            sname = "";
        }
        if ((key = servlet.getServletContext().getServletContextName()) == null) {
            key = "";
        }
        key = key + "|" + sname;
        HashMap hashMap = s_servletMap;
        synchronized (hashMap) {
            this.m_serviceDefnMap = (HashMap)s_servletMap.get(key);
            if (this.m_serviceDefnMap == null) {
                this.m_serviceDefnMap = this.createServiceDefinitions(servlet);
                s_servletMap.put(key, this.m_serviceDefnMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map createServiceDefinitions(HttpServlet servlet) throws UnavailableException {
        IUnmarshallingContext ctx = null;
        try {
            IBindingFactory factory = BindingDirectory.getFactory((Class)(class$org$jibx$ws$server$ServiceDefinition == null ? (class$org$jibx$ws$server$ServiceDefinition = PathBasedServiceMapper.class$("org.jibx.ws.server.ServiceDefinition")) : class$org$jibx$ws$server$ServiceDefinition));
            ctx = factory.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            logger.error((Object)"Unable to initialize unmarshalling", (Throwable)e);
            throw new UnavailableException("Unable to initialize unmarshalling. \n" + this.getErrorDetails(e));
        }
        String path = null;
        String file = null;
        try {
            HashMap<String, ServiceDefinition> map = new HashMap<String, ServiceDefinition>();
            Enumeration pnum = servlet.getInitParameterNames();
            ServletContext serv = servlet.getServletContext();
            while (pnum.hasMoreElements()) {
                path = (String)pnum.nextElement();
                file = "/WEB-INF/" + servlet.getInitParameter(path);
                InputStream is = null;
                try {
                    is = serv.getResourceAsStream(file);
                    if (is == null) {
                        logger.error((Object)("Service definition not found for service " + path + " at " + file));
                        throw new UnavailableException("Service definition not found for service " + path + " at " + file + ". Check configuration of servlet " + servlet.getServletName() + " in WEB-INF/web.xml.");
                    }
                    ServiceDefinition sdef = (ServiceDefinition)ctx.unmarshalDocument(is, null);
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    map.put(path, sdef);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            return map;
        }
        catch (JiBXException e) {
            logger.error((Object)("Error reading service definition " + file + " for service " + path), (Throwable)e);
            throw new UnavailableException("Error reading service definition " + file + " for service " + path + ".\n" + this.getErrorDetails(e));
        }
    }

    private ServiceDefinition getServiceDefinition(HttpServletRequest req) {
        ServiceDefinition defn;
        String servicePath = req.getPathInfo();
        if (servicePath == null) {
            servicePath = req.getServletPath();
        }
        if ((defn = (ServiceDefinition)this.m_serviceDefnMap.get(servicePath)) == null && logger.isWarnEnabled()) {
            logger.warn((Object)("No service definition for service path '" + servicePath + "' based on " + (req.getPathInfo() != null ? "path info" : "servlet path") + " of request '" + req.getRequestURI() + "'"));
        }
        return defn;
    }

    public Service getServiceInstance(HttpServletRequest req) throws WsException {
        ServiceDefinition sdef = this.getServiceDefinition(req);
        if (sdef == null) {
            return null;
        }
        ServiceFactory serviceFactory = ProtocolDirectory.getProtocol(sdef.getProtocolName()).getServiceFactory();
        return ServicePool.getInstance(serviceFactory, sdef);
    }

    private String getErrorDetails(JiBXException e) {
        String errorDetails = "Error details: " + e.getMessage();
        if (e.getRootCause() != null) {
            errorDetails = errorDetails + "\nRoot cause: " + e.getRootCause().getMessage();
            logger.error((Object)"Root cause: ", e.getRootCause());
        }
        return errorDetails;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

