/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopiedInputStream
extends FilterInputStream {
    private final OutputStream m_stream;

    public CopiedInputStream(InputStream in, OutputStream out) {
        super(in);
        this.m_stream = out;
    }

    public void close() throws IOException {
        super.close();
        this.m_stream.close();
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("Method not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int actual = super.read(b, off, len);
        if (actual > 0) {
            this.m_stream.write(b, off, actual);
        }
        return actual;
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("Method not supported");
    }

    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Method not supported");
    }

    public int read() throws IOException {
        int chr = super.read();
        if (chr >= 0) {
            this.m_stream.write(chr);
        }
        return chr;
    }
}

