/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsException;
import org.jibx.ws.io.PayloadWriter;

public final class MarshallingPayloadWriter
implements PayloadWriter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$jibx$ws$io$MarshallingPayloadWriter == null ? (class$org$jibx$ws$io$MarshallingPayloadWriter = MarshallingPayloadWriter.class$("org.jibx.ws.io.MarshallingPayloadWriter")) : class$org$jibx$ws$io$MarshallingPayloadWriter));
    private final MarshallingContext m_marshaller;
    private final String[] m_namespaces;
    static /* synthetic */ Class class$org$jibx$ws$io$MarshallingPayloadWriter;

    public MarshallingPayloadWriter(Class clazz) throws WsBindingException {
        IBindingFactory factory;
        try {
            factory = BindingDirectory.getFactory((Class)clazz);
        }
        catch (JiBXException e) {
            throw new WsBindingException("Error accessing binding.", e);
        }
        this.m_marshaller = this.createMarshaller(factory);
        this.m_namespaces = this.m_marshaller.getNamespaces();
    }

    public MarshallingPayloadWriter(String bindingName, String packageName) throws WsBindingException {
        IBindingFactory factory;
        try {
            factory = BindingDirectory.getFactory((String)bindingName, (String)packageName);
        }
        catch (JiBXException e) {
            throw new WsBindingException("Error accessing binding.", e);
        }
        this.m_marshaller = this.createMarshaller(factory);
        this.m_namespaces = this.m_marshaller.getNamespaces();
    }

    public MarshallingPayloadWriter(IBindingFactory factory) throws WsBindingException {
        this.m_marshaller = this.createMarshaller(factory);
        this.m_namespaces = this.m_marshaller.getNamespaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(IXMLWriter xmlWriter, Object payload) throws IOException, WsException {
        int index;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to marshall payload '" + payload + "'"));
        }
        if (!(payload instanceof IMarshallable)) {
            throw new WsException("Payload object must have a defined mapping");
        }
        String[] nss = xmlWriter.getNamespaces();
        int limit = Math.min(nss.length, this.m_namespaces.length);
        for (index = 0; index < limit && nss[index].equals(this.m_namespaces[index]); ++index) {
        }
        if (index < this.m_namespaces.length) {
            int base = xmlWriter.getNamespaceCount();
            String[] extnss = new String[this.m_namespaces.length - index];
            System.arraycopy(this.m_namespaces, index, extnss, 0, extnss.length);
            xmlWriter.pushExtensionNamespaces(extnss);
            int[] xlates = new int[this.m_namespaces.length];
            for (int i = 0; i < xlates.length; ++i) {
                xlates[i] = i < index ? i : base + i - index;
            }
            xmlWriter.pushTranslationTable(xlates);
        }
        try {
            this.m_marshaller.setXmlWriter(xmlWriter);
            try {
                ((IMarshallable)payload).marshal((IMarshallingContext)this.m_marshaller);
            }
            catch (JiBXException e) {
                throw new WsException("Unable to marshal payload.", e);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (index < this.m_namespaces.length) {
                xmlWriter.popTranslationTable();
                xmlWriter.popExtensionNamespaces();
            }
            throw throwable;
        }
        if (index < this.m_namespaces.length) {
            xmlWriter.popTranslationTable();
            xmlWriter.popExtensionNamespaces();
        }
    }

    private MarshallingContext createMarshaller(IBindingFactory factory) throws WsBindingException {
        MarshallingContext marshaller;
        try {
            marshaller = (MarshallingContext)factory.createMarshallingContext();
        }
        catch (JiBXException e) {
            throw new WsBindingException("Unable to create MarshallingContext.", e);
        }
        return marshaller;
    }

    public void reset() {
        this.m_marshaller.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

