/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io;

import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsException;
import org.jibx.ws.io.PayloadReader;

public final class UnmarshallingPayloadReader
implements PayloadReader {
    private final UnmarshallingContext m_unmarshallCtx;

    public UnmarshallingPayloadReader(Class clazz) throws WsBindingException {
        IBindingFactory factory;
        try {
            factory = BindingDirectory.getFactory((Class)clazz);
        }
        catch (JiBXException e) {
            throw new WsBindingException("Error accessing binding.", e);
        }
        this.m_unmarshallCtx = this.createUnmarshallingContext(factory);
    }

    public UnmarshallingPayloadReader(String bindingName, String packageName) throws WsBindingException {
        IBindingFactory factory;
        try {
            factory = BindingDirectory.getFactory((String)bindingName, (String)packageName);
        }
        catch (JiBXException e) {
            throw new WsBindingException("Error accessing binding.", e);
        }
        this.m_unmarshallCtx = this.createUnmarshallingContext(factory);
    }

    public UnmarshallingPayloadReader(IBindingFactory factory) throws WsBindingException {
        this.m_unmarshallCtx = this.createUnmarshallingContext(factory);
    }

    private UnmarshallingContext createUnmarshallingContext(IBindingFactory factory) throws WsBindingException {
        UnmarshallingContext ctx = null;
        try {
            ctx = (UnmarshallingContext)factory.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            throw new WsBindingException("Unable to create UnmarshallingContext.", e);
        }
        return ctx;
    }

    public Object invoke(IXMLReader xmlReader) throws WsException {
        Object payload = null;
        this.m_unmarshallCtx.reset();
        this.m_unmarshallCtx.setDocument(xmlReader);
        try {
            String name = this.m_unmarshallCtx.toStart();
            IUnmarshaller unmarshaller = this.m_unmarshallCtx.getUnmarshaller(xmlReader.getNamespace(), name);
            if (unmarshaller != null) {
                payload = unmarshaller.unmarshal(null, (IUnmarshallingContext)this.m_unmarshallCtx);
            }
        }
        catch (JiBXException e) {
            throw new WsException("Error in unmarshalling.", e);
        }
        return payload;
    }

    public void reset() {
        this.m_unmarshallCtx.reset();
    }
}

