/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.io.handler;

import java.io.IOException;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IXMLReader;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.context.InContext;
import org.jibx.ws.io.UnmarshallingPayloadReader;
import org.jibx.ws.io.handler.InHandler;

public final class ContextAttributeUnmarshallingInHandler
implements InHandler {
    private final UnmarshallingPayloadReader m_unmarshaller;
    private final String m_attributeName;

    public ContextAttributeUnmarshallingInHandler(Class clazz, String attributeName) throws WsBindingException {
        this.m_unmarshaller = new UnmarshallingPayloadReader(clazz);
        this.m_attributeName = attributeName;
    }

    public ContextAttributeUnmarshallingInHandler(String className, String attributeName) throws WsBindingException, WsConfigurationException {
        try {
            Class<?> clazz = Class.forName(className);
            this.m_unmarshaller = new UnmarshallingPayloadReader(clazz);
            this.m_attributeName = attributeName;
        }
        catch (ClassNotFoundException e) {
            throw new WsConfigurationException("Unable to create ContextualPayloadUnmarshaller.  Class not found: " + className);
        }
    }

    public ContextAttributeUnmarshallingInHandler(String bindingName, String packageName, String attributeName) throws WsBindingException {
        this.m_unmarshaller = new UnmarshallingPayloadReader(bindingName, packageName);
        this.m_attributeName = attributeName;
    }

    public ContextAttributeUnmarshallingInHandler(IBindingFactory factory, String attributeName) throws WsBindingException {
        this.m_unmarshaller = new UnmarshallingPayloadReader(factory);
        this.m_attributeName = attributeName;
    }

    public Object invoke(InContext context, IXMLReader xmlReader) throws IOException, WsException {
        Object payload = this.m_unmarshaller.invoke(xmlReader);
        if (payload != null) {
            context.setAttribute(this.m_attributeName, payload);
            return payload;
        }
        return payload;
    }
}

