/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.pox.client;

import java.io.IOException;
import org.jibx.runtime.IBindingFactory;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.client.Client;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.pox.PoxProcessor;
import org.jibx.ws.pox.PoxProtocol;
import org.jibx.ws.process.Processor;
import org.jibx.ws.transport.DuplexConnection;
import org.jibx.ws.transport.MessageProperties;

public final class PoxClient
extends Client {
    private PoxProcessor m_processor;
    private OutContext m_outCtx;
    private InContext m_inCtx;

    public PoxClient(String location) throws WsConfigurationException {
        super(location);
    }

    public PoxClient(String location, IBindingFactory factory) throws WsBindingException, WsConfigurationException {
        super(location);
        this.setBindingFactory(factory);
    }

    public PoxClient(String location, IBindingFactory factory, MessageOptions options) throws WsBindingException, WsConfigurationException {
        this(location, factory);
        this.setMessageOptions(options);
    }

    public Object call(Object request) throws IOException, WsException {
        if (this.getBodyWriter() == null && request != null) {
            throw new WsConfigurationException("Binding factory or handler must be defined for the outbound message body");
        }
        Processor processor = this.getProcessor();
        this.m_outCtx.setBody(request);
        String opname = null;
        MessageProperties msgProps = PoxProtocol.INSTANCE.buildMessageProperties(opname, this.getMessageOptions());
        DuplexConnection duplex = this.getChannel().getDuplex(msgProps, this.getMessageOptions().getXmlOptions());
        processor.invoke(duplex.getOutbound(), duplex.getInbound());
        return this.m_inCtx.getBody();
    }

    private Processor getProcessor() throws WsException {
        if (this.m_processor != null) {
            this.m_processor.reset();
        }
        if (this.m_processor == null || this.isModified()) {
            this.m_outCtx = new OutContext();
            if (this.getBodyWriter() != null) {
                this.m_outCtx.setBodyWriter(this.getBodyWriter());
            }
            this.m_inCtx = new InContext();
            if (this.getBodyReader() != null) {
                this.m_inCtx.setBodyReader(this.getBodyReader());
            }
            this.m_processor = (PoxProcessor)PoxProtocol.INSTANCE.createProcessor(ExchangeContext.createOutInExchange(this.m_outCtx, this.m_inCtx));
        }
        return this.m_processor;
    }
}

