/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.protocol.Protocol;

public final class ProtocolDirectory {
    private static final String PROTOCOL_PROPERTIES_PATH = "/protocol.properties";
    private static final char INSTANCE_SEPARATOR = '#';
    private static final Map s_protocolMap = new HashMap();
    static /* synthetic */ Class class$org$jibx$ws$protocol$ProtocolDirectory;

    private ProtocolDirectory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void loadProperties(String path) {
        InputStream stream = null;
        try {
            try {
                Properties props = new Properties();
                stream = (class$org$jibx$ws$protocol$ProtocolDirectory == null ? (class$org$jibx$ws$protocol$ProtocolDirectory = ProtocolDirectory.class$("org.jibx.ws.protocol.ProtocolDirectory")) : class$org$jibx$ws$protocol$ProtocolDirectory).getResourceAsStream(path);
                if (stream == null) {
                    throw new RuntimeException("Unable to load required properties file '" + path + '\'');
                }
                props.load(stream);
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    String objectName = props.getProperty(name);
                    Protocol inst = ProtocolDirectory.loadProtocol(objectName);
                    s_protocolMap.put(name, inst);
                }
                Object var8_8 = null;
                if (stream == null) return;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load required properties file '" + path + '\'');
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        stream.close();
        return;
    }

    static Protocol loadProtocol(String objectName) {
        String classname;
        String fieldname = null;
        int index = objectName.indexOf(35);
        if (index >= 0) {
            classname = objectName.substring(0, index);
            fieldname = objectName.substring(index + 1);
        } else {
            classname = objectName;
        }
        try {
            Class<?> clas = (class$org$jibx$ws$protocol$ProtocolDirectory == null ? (class$org$jibx$ws$protocol$ProtocolDirectory = ProtocolDirectory.class$("org.jibx.ws.protocol.ProtocolDirectory")) : class$org$jibx$ws$protocol$ProtocolDirectory).getClassLoader().loadClass(classname);
            Object inst = null;
            inst = fieldname != null ? clas.getField(fieldname).get(null) : (Object)clas.newInstance();
            if (inst instanceof Protocol) {
                return (Protocol)inst;
            }
            throw new IllegalStateException("Class " + classname + ", specified for protocol '" + objectName + "', is not an org.jibx.ws.Protocol implementation");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load protocol class " + classname);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unable to access field " + fieldname + " of class " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Error creating an instance of protocol class " + classname + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to create an instance of protocol class " + classname);
        }
    }

    public static Protocol getProtocol(String protocolName) throws WsConfigurationException {
        Protocol protocol = (Protocol)s_protocolMap.get(protocolName);
        if (protocol == null) {
            throw new WsConfigurationException("Unknown protocol '" + protocolName);
        }
        return protocol;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ProtocolDirectory.loadProperties(PROTOCOL_PROPERTIES_PATH);
    }
}

