/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.util.ArrayList;
import java.util.List;
import org.jibx.runtime.QName;
import org.jibx.ws.WsException;
import org.jibx.ws.io.handler.OutHandler;

public final class SoapFault {
    public static final QName FAULT_CODE_CLIENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    public static final QName FAULT_CODE_SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    public static final QName FAULT_CODE_MUST_UNDERSTAND = new QName("http://schemas.xmlsoap.org/soap/envelope/", "MustUnderstand");
    public static final QName FAULT_CODE_VERSION_MISMATCH = new QName("http://schemas.xmlsoap.org/soap/envelope/", "VersionMismatch");
    private final QName m_faultCode;
    private final String m_faultString;
    private final String m_faultActor;
    private final List m_details = new ArrayList();
    private final List m_detailWriters = new ArrayList();

    public SoapFault(QName faultCode, String faultString, String faultActor) throws WsException {
        if (faultCode == null || faultString == null) {
            throw new WsException("faultCode and faultString must be non-null");
        }
        if (faultCode.getUri() == null) {
            throw new WsException("faultCode URI must be non-null");
        }
        if (!faultCode.getUri().equals("http://schemas.xmlsoap.org/soap/envelope/") && faultCode.getPrefix() == null) {
            throw new WsException("faultCode prefix must be non-null for custom URIs");
        }
        this.m_faultCode = faultCode;
        this.m_faultString = faultString;
        this.m_faultActor = faultActor;
    }

    void addDetail(Object item) {
        this.m_details.add(item);
    }

    public void addDetailWriter(OutHandler writer) {
        this.m_detailWriters.add(writer);
    }

    public QName getFaultCode() {
        return this.m_faultCode;
    }

    public String getFaultString() {
        return this.m_faultString;
    }

    public String getFaultActor() {
        return this.m_faultActor;
    }

    public List getDetails() {
        return this.m_details;
    }

    public List getDetailWriters() {
        return this.m_detailWriters;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getFaultCode().getPrefix() != null) {
            sb.append(this.getFaultCode().getPrefix()).append(":");
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getFaultCode().getUri())) {
            sb.append("SOAP").append(":");
        } else if (this.getFaultCode().getUri() != null) {
            sb.append('{').append(this.getFaultCode().getUri()).append('}');
        }
        if (this.getFaultCode().getName() != null) {
            sb.append(this.getFaultCode().getName());
        }
        sb.append(" - ").append(this.getFaultString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_details == null ? 0 : ((Object)this.m_details).hashCode());
        result = 31 * result + (this.m_faultActor == null ? 0 : this.m_faultActor.hashCode());
        result = 31 * result + (this.m_faultCode == null ? 0 : this.m_faultCode.hashCode());
        result = 31 * result + (this.m_faultString == null ? 0 : this.m_faultString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SoapFault other = (SoapFault)obj;
        if (this.m_details == null ? other.m_details != null : !((Object)this.m_details).equals(other.m_details)) {
            return false;
        }
        if (this.m_faultActor == null ? other.m_faultActor != null : !this.m_faultActor.equals(other.m_faultActor)) {
            return false;
        }
        if (this.m_faultCode == null ? other.m_faultCode != null : !this.m_faultCode.equals((Object)other.m_faultCode)) {
            return false;
        }
        return !(this.m_faultString == null ? other.m_faultString != null : !this.m_faultString.equals(other.m_faultString));
    }
}

