/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.ws.WsException;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.MessageContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.XmlReaderWrapper;
import org.jibx.ws.io.handler.OutHandler;
import org.jibx.ws.process.Processor;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.soap.SoapPhase;
import org.jibx.ws.soap.SoapReader;
import org.jibx.ws.soap.SoapVersion;
import org.jibx.ws.soap.SoapWriter;
import org.jibx.ws.soap.WsNotUnderstoodException;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.OutConnection;
import org.jibx.ws.transport.WsTransportException;

public final class SoapProcessor
implements Processor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$jibx$ws$soap$SoapProcessor == null ? (class$org$jibx$ws$soap$SoapProcessor = SoapProcessor.class$("org.jibx.ws.soap.SoapProcessor")) : class$org$jibx$ws$soap$SoapProcessor));
    private ExchangeContext m_exchangeCtx;
    private String m_encodingStyle;
    static /* synthetic */ Class class$org$jibx$ws$soap$SoapProcessor;

    public SoapProcessor(SoapVersion soapVersion) {
    }

    public SoapProcessor(SoapVersion soapVersion, ExchangeContext exchangeContext) {
        this.m_exchangeCtx = exchangeContext;
    }

    public void setSoapEncodingStyle(String encodingStyle) {
        this.m_encodingStyle = encodingStyle;
    }

    public void invoke(OutConnection oconn, InConnection iconn) throws IOException, WsException {
        MessageContext msgCtx = this.m_exchangeCtx.getCurrentMessageContext();
        while (msgCtx != null) {
            if (msgCtx.isOutbound()) {
                this.sendMessage(oconn);
            } else {
                this.receiveMessage(iconn);
            }
            this.m_exchangeCtx.switchMessageContext();
            msgCtx = this.m_exchangeCtx.getCurrentMessageContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendMessage(OutConnection conn) throws IOException, WsException {
        if (this.m_exchangeCtx.getCurrentMessageContext() == null) {
            throw new IllegalStateException("No message context available for sending message");
        }
        if (!this.m_exchangeCtx.getCurrentMessageContext().isOutbound()) {
            throw new IllegalStateException("Cannot send message when current message context is inbound");
        }
        OutContext context = (OutContext)this.m_exchangeCtx.getCurrentMessageContext();
        SoapWriter soapWriter = new SoapWriter(conn);
        boolean requestCompleted = false;
        try {
            logger.debug((Object)"Starting send message");
            soapWriter.startMessage(this.m_encodingStyle);
            IXMLWriter xmlWriter = soapWriter.getWriter();
            if (context.hasHandlers(SoapPhase.HEADER)) {
                soapWriter.startHeader();
                context.invokeHandlers(SoapPhase.HEADER, xmlWriter);
                soapWriter.endHeader();
            }
            soapWriter.startBody();
            context.invokeBodyWriter(xmlWriter);
            logger.debug((Object)"Ending send message body");
            soapWriter.endBody();
            soapWriter.sendMessageCompletely();
            logger.debug((Object)"Message sent");
            requestCompleted = true;
            Object var7_6 = null;
            conn.outputComplete();
            if (requestCompleted) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            conn.outputComplete();
            if (requestCompleted) throw throwable;
            try {
                logger.debug((Object)"Aborting send");
                soapWriter.abortMessage();
                throw throwable;
            }
            catch (IOException e) {
                logger.error((Object)"Error aborting send", (Throwable)e);
            }
            throw throwable;
        }
        try {
            logger.debug((Object)"Aborting send");
            soapWriter.abortMessage();
            return;
        }
        catch (IOException e) {
            logger.error((Object)"Error aborting send", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendFaultMessage(SoapFault error, OutConnection conn) throws IOException, WsException {
        if (this.m_exchangeCtx.getCurrentMessageContext() == null) {
            throw new IllegalStateException("No message context available for sending fault message");
        }
        if (!this.m_exchangeCtx.getCurrentMessageContext().isOutbound()) {
            throw new IllegalStateException("Cannot send fault message when current message context is inbound");
        }
        OutContext context = (OutContext)this.m_exchangeCtx.getCurrentMessageContext();
        SoapWriter soapWriter = new SoapWriter(conn);
        boolean requestCompleted = false;
        try {
            soapWriter.startMessage(this.m_encodingStyle);
            IXMLWriter xmlWriter = soapWriter.getWriter();
            logger.debug((Object)"Starting send fault");
            soapWriter.startBody();
            SoapFault fault = error;
            soapWriter.startFault(fault);
            List detailWriters = fault.getDetailWriters();
            if (detailWriters != null && detailWriters.size() > 0) {
                soapWriter.startFaultDetail();
                for (int i = 0; i < detailWriters.size(); ++i) {
                    ((OutHandler)detailWriters.get(i)).invoke(context, xmlWriter);
                }
                soapWriter.endFaultDetail();
            }
            soapWriter.endFault();
            logger.debug((Object)"Ending send fault body");
            soapWriter.endBody();
            soapWriter.sendMessageCompletely();
            logger.debug((Object)"Fault sent");
            requestCompleted = true;
            Object var11_10 = null;
            conn.outputComplete();
            if (requestCompleted) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            conn.outputComplete();
            if (requestCompleted) throw throwable;
            try {
                logger.debug((Object)"Aborting send fault");
                soapWriter.abortMessage();
                throw throwable;
            }
            catch (IOException e) {
                logger.error((Object)"Error aborting send fault", (Throwable)e);
            }
            throw throwable;
        }
        try {
            logger.debug((Object)"Aborting send fault");
            soapWriter.abortMessage();
            return;
        }
        catch (IOException e) {
            logger.error((Object)"Error aborting send fault", (Throwable)e);
        }
    }

    public void receiveMessage(InConnection conn) throws IOException, WsException {
        if (this.m_exchangeCtx.getCurrentMessageContext() == null) {
            throw new IllegalStateException("No message context available for receiving message");
        }
        if (this.m_exchangeCtx.getCurrentMessageContext().isOutbound()) {
            throw new IllegalStateException("Cannot receive message when current message context is outbound");
        }
        InContext context = (InContext)this.m_exchangeCtx.getCurrentMessageContext();
        SoapReader soapReader = new SoapReader(conn);
        try {
            try {
                logger.debug((Object)"Starting receive message");
                soapReader.startMessage();
                IXMLReader xmlReader = soapReader.getReader();
                if (soapReader.hasHeaders()) {
                    this.readSoapHeaders(xmlReader, context);
                    soapReader.endHeader();
                }
                soapReader.startBody();
                if (soapReader.hasNonEmptyBody()) {
                    if (soapReader.isBodyFault()) {
                        SoapFault fault = soapReader.startFault();
                        if (soapReader.startFaultDetail()) {
                            this.readSoapFaultDetail(xmlReader, context, fault);
                            soapReader.endFaultDetail();
                        }
                        soapReader.endFault();
                        context.setBody(fault);
                    } else {
                        context.invokeBodyReader(xmlReader);
                        if (context.getBody() == null) {
                            throw new WsException("No handlers could be found for unmarshalling the SOAP body payload");
                        }
                    }
                }
                soapReader.endBody();
                soapReader.endMessage();
            }
            catch (WsException e) {
                if (conn.hasError()) {
                    throw new WsTransportException(conn.getErrorMessage());
                }
                throw e;
            }
            Object var7_7 = null;
            conn.inputComplete();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            conn.inputComplete();
            throw throwable;
        }
    }

    private void readSoapFaultDetail(IXMLReader xmlReader, InContext context, SoapFault fault) throws IOException, WsException {
        try {
            XmlReaderWrapper wrpr = XmlReaderWrapper.createXmlReaderWrapper(xmlReader);
            while (wrpr.toTag() == 2) {
                Object detail = null;
                if (context.hasHandlers(SoapPhase.BODY_FAULT)) {
                    detail = context.invokeInHandlers(SoapPhase.BODY_FAULT, xmlReader);
                }
                if (detail != null) {
                    fault.addDetail(detail);
                    continue;
                }
                wrpr.skipPastEndTag(xmlReader.getNamespace(), xmlReader.getName());
            }
        }
        catch (JiBXException e) {
            throw new WsException("Error while unmarshalling SOAP fault details", e);
        }
    }

    private void readSoapHeaders(IXMLReader xmlReader, InContext context) throws IOException, WsException {
        try {
            XmlReaderWrapper wrpr = XmlReaderWrapper.createXmlReaderWrapper(xmlReader);
            while (wrpr.toTag() == 2) {
                Object header = context.invokeInHandlers(SoapPhase.HEADER, xmlReader);
                if (header != null) continue;
                String mustUnderstand = xmlReader.getAttributeValue("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
                if ("1".equals(mustUnderstand)) {
                    throw new WsNotUnderstoodException("");
                }
                wrpr.skipPastEndTag(xmlReader.getNamespace(), xmlReader.getName());
            }
        }
        catch (JiBXException e) {
            throw new WsException("Error while unmarshalling SOAP header details", e);
        }
    }

    public void setExchangeContext(ExchangeContext exchangeCtx) {
        this.m_exchangeCtx = exchangeCtx;
    }

    public void reset() {
        this.m_exchangeCtx.reset();
    }

    public MessageContext getCurrentMessageContext() {
        return this.m_exchangeCtx.getCurrentMessageContext();
    }

    public MessageContext getNextMessageContext() {
        return this.m_exchangeCtx.getNextMessageContext();
    }

    public void switchMessageContext() {
        this.m_exchangeCtx.switchMessageContext();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

