/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import org.jibx.runtime.IBindingFactory;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.client.Client;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.process.Processor;
import org.jibx.ws.protocol.Protocol;
import org.jibx.ws.server.MediaTypeMapper;
import org.jibx.ws.server.Service;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.server.ServiceExceptionHandlerFactory;
import org.jibx.ws.server.ServiceFactory;
import org.jibx.ws.soap.SoapProcessor;
import org.jibx.ws.soap.SoapVersion;
import org.jibx.ws.soap.client.SoapClient;
import org.jibx.ws.soap.server.SoapFaultHandler;
import org.jibx.ws.soap.server.SoapService;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.MessageProperties;

public final class SoapProtocol
implements Protocol {
    public static final String SOAPACTION_HEADER = "SOAPAction";
    public static final SoapProtocol SOAP1_1 = new SoapProtocol(SoapVersion.SOAP1_1, "http://schemas.xmlsoap.org/soap/envelope/");
    private final SoapVersion m_soapVersion;
    private final String m_soapUri;
    private static final MediaTypeMapper s_soap11MediaTypeMapper;
    private static final ServiceFactory s_serviceFactory;
    private static final ServiceExceptionHandlerFactory s_exceptionHandlerFactoryWithTrace;
    private static final ServiceExceptionHandlerFactory s_exceptionHandlerFactoryNoTrace;

    private SoapProtocol(SoapVersion soapVersion, String uri) {
        this.m_soapVersion = soapVersion;
        this.m_soapUri = uri;
    }

    public String getUri() {
        return this.m_soapUri;
    }

    public Processor createProcessor() {
        return new SoapProcessor(this.m_soapVersion);
    }

    public Processor createProcessor(ExchangeContext exchangeContext) {
        return new SoapProcessor(this.m_soapVersion, exchangeContext);
    }

    public Client createClient(String location, IBindingFactory factory, MessageOptions options) throws WsBindingException, WsConfigurationException {
        return new SoapClient(location, factory, options, this);
    }

    public ServiceFactory getServiceFactory() {
        return s_serviceFactory;
    }

    public String getName() {
        return this.m_soapVersion.toString();
    }

    public MediaTypeMapper getMediaTypeMapper() {
        return s_soap11MediaTypeMapper;
    }

    public MessageProperties buildMessageProperties(String opname, MessageOptions msgOptions) throws WsConfigurationException {
        String charset = msgOptions.getEncoding().toString();
        String outtype = msgOptions.getOutMediaTypeCode();
        String[] intypes = msgOptions.getInMediaTypeCodes();
        MessageProperties props = new MessageProperties();
        props.setContentType(this.getMediaTypeMapper().getMediaTypeFor(outtype));
        MediaType[] acceptTypes = new MediaType[intypes.length];
        for (int i = 0; i < intypes.length; ++i) {
            acceptTypes[i] = this.getMediaTypeMapper().getMediaTypeFor(intypes[i]);
        }
        props.setAcceptTypes(acceptTypes);
        if (!this.m_soapVersion.equals(SoapVersion.SOAP1_1)) {
            throw new IllegalStateException("Internal error - unsupported SOAP version " + this.m_soapVersion);
        }
        String soapAction = opname == null ? "" : "\"" + opname + "\"";
        props.setProperty(SOAPACTION_HEADER, soapAction);
        if (charset != null) {
            props.setCharset(charset);
        }
        return props;
    }

    public String getOperationName(InConnection conn) {
        String opname = null;
        if (this.m_soapVersion.equals(SoapVersion.SOAP1_1) && (opname = conn.getProperty(SOAPACTION_HEADER)) != null && opname.startsWith("\"") && opname.endsWith("\"")) {
            opname = opname.substring(1, opname.length() - 1);
        }
        return opname;
    }

    public static ServiceExceptionHandlerFactory getDefaultExceptionHandlerFactory(boolean includeStackTrace) {
        if (includeStackTrace) {
            return s_exceptionHandlerFactoryWithTrace;
        }
        return s_exceptionHandlerFactoryNoTrace;
    }

    static {
        s_serviceFactory = new ServiceFactory(){

            public Service createInstance(ServiceDefinition sdef) throws WsException {
                return new SoapService(sdef, s_soap11MediaTypeMapper, new SoapProcessor(SoapVersion.SOAP1_1), SoapProtocol.getDefaultExceptionHandlerFactory(sdef.getIncludeStackTraceOnFault()));
            }
        };
        s_exceptionHandlerFactoryWithTrace = new ServiceExceptionHandlerFactory(){

            public ServiceExceptionHandler createServiceExceptionHandler() {
                return new SoapFaultHandler(true);
            }
        };
        s_exceptionHandlerFactoryNoTrace = new ServiceExceptionHandlerFactory(){

            public ServiceExceptionHandler createServiceExceptionHandler() {
                return new SoapFaultHandler(false);
            }
        };
        s_soap11MediaTypeMapper = new MediaTypeMapper(){

            public MediaType getMediaTypeFor(String code) throws WsConfigurationException {
                if (code == null || "xml".equals(code)) {
                    return CodecDirectory.TEXT_XML_MEDIA_TYPE;
                }
                MediaType type = new MediaType("application", "soap+" + code);
                if (!CodecDirectory.hasCodecFor(type)) {
                    throw new WsConfigurationException("No codec available for media type '" + type + "' based on media type code '" + code + "' with protocol SOAP 1.1");
                }
                return type;
            }
        };
    }
}

