/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.ws.WsException;
import org.jibx.ws.io.XmlReaderWrapper;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.transport.InConnection;

public final class SoapReader {
    private XmlReaderWrapper m_wrapper;
    private IXMLReader m_reader;
    private InConnection m_conn;

    SoapReader(InConnection conn) throws IOException, WsException {
        this.m_conn = conn;
        this.m_conn.init();
        this.m_reader = conn.getReader();
        this.m_wrapper = XmlReaderWrapper.createXmlReaderWrapper(this.m_reader);
    }

    public IXMLReader getReader() {
        return this.m_reader;
    }

    public void startMessage() throws WsException {
        try {
            this.m_wrapper.toStart();
            if (!this.m_wrapper.isAtStart("http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
                throw new WsException("Message does not begin with SOAP Envelope");
            }
            this.m_wrapper.parsePastStartTag("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of SOAP message.", e);
        }
    }

    public boolean hasHeaders() throws WsException {
        boolean isStartHeader;
        try {
            isStartHeader = this.m_wrapper.isAtStart("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (isStartHeader) {
                this.m_wrapper.parsePastStartTag("http://schemas.xmlsoap.org/soap/envelope/", "Header");
                if (this.endHeader()) {
                    isStartHeader = false;
                } else {
                    this.m_wrapper.toStart();
                }
            }
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of header.", e);
        }
        return isStartHeader;
    }

    public boolean endHeader() throws WsException {
        boolean isEndHeader;
        try {
            isEndHeader = this.m_wrapper.isAtEnd("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (isEndHeader) {
                this.m_wrapper.parsePastEndTag("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            }
        }
        catch (JiBXException e) {
            throw new WsException("Error reading end of header.", e);
        }
        return isEndHeader;
    }

    public boolean hasNonEmptyBody() throws WsException {
        try {
            if (this.m_wrapper.isAtEnd("http://schemas.xmlsoap.org/soap/envelope/", "Body")) {
                return false;
            }
            this.m_wrapper.toStart();
        }
        catch (JiBXException e) {
            throw new WsException("Error checking for empty SOAP Body.", e);
        }
        return true;
    }

    public void startBody() throws WsException {
        try {
            this.m_wrapper.parsePastStartTag("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of SOAP Body.", e);
        }
    }

    public void endBody() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        }
        catch (JiBXException e) {
            throw new WsException("Expected end tag for SOAP body.", e);
        }
    }

    public SoapFault startFault() throws WsException {
        try {
            this.m_wrapper.parsePastStartTag("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            QName code = this.createQName(this.m_wrapper.parseElementText("", "faultcode"));
            String fault = this.m_wrapper.parseElementText("", "faultstring");
            String actor = null;
            if (this.m_wrapper.isAtStart("", "faultactor")) {
                actor = this.m_wrapper.parseElementText("", "faultactor");
            }
            return new SoapFault(code, fault, actor);
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of fault.", e);
        }
    }

    public boolean startFaultDetail() throws WsException {
        try {
            if (this.m_wrapper.isAtStart("", "detail")) {
                this.m_wrapper.parsePastStartTag("", "detail");
                return true;
            }
            return false;
        }
        catch (JiBXException e) {
            throw new WsException("Error reading start of fault detail.", e);
        }
    }

    public void endFaultDetail() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag("", "detail");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading end of fault detail.", e);
        }
    }

    public void endFault() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        }
        catch (JiBXException e) {
            throw new WsException("Error reading end of fault.", e);
        }
    }

    public void endMessage() throws WsException {
        try {
            this.m_wrapper.parsePastEndTag("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        }
        catch (JiBXException e) {
            throw new WsException("Expected end tag for SOAP envelope.", e);
        }
    }

    public boolean isBodyFault() throws WsException {
        try {
            return this.m_wrapper.isAtStart("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        }
        catch (JiBXException e) {
            throw new WsException("Error checking for start of SOAP Fault.", e);
        }
    }

    private QName createQName(String str) {
        QName qname = null;
        if (str != null) {
            int i = str.indexOf(58);
            if (i == -1) {
                qname = new QName(str);
            } else {
                String prefix = str.substring(0, i);
                String name = str.substring(i + 1);
                String uri = this.m_wrapper.getReader().getNamespace(prefix);
                qname = new QName(uri, prefix, name);
            }
        }
        return qname;
    }
}

