/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.ws.WsException;
import org.jibx.ws.soap.SoapConstants;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.transport.OutConnection;

final class SoapWriter {
    private static final int NO_NS_IDX = 0;
    private static final String[] SOAP_NS = new String[]{"", "http://www.w3.org/XML/1998/namespace", "http://schemas.xmlsoap.org/soap/envelope/"};
    private static final int SOAP_NS_IDX = 2;
    private OutConnection m_connection;
    private IXMLWriter m_writer;
    private boolean m_customFaultCodeNS;

    public SoapWriter(OutConnection conn) throws IOException, WsException {
        this.m_connection = conn;
        this.m_writer = conn.getNormalWriter(SOAP_NS);
    }

    public IXMLWriter getWriter() {
        return this.m_writer;
    }

    public void startMessage() throws IOException {
        this.startMessage(null);
    }

    public void startMessage(String encodingStyle) throws IOException {
        this.m_writer.startTagNamespaces(2, "Envelope", new int[]{2}, SoapConstants.SOAP_PREFIX_ARRAY);
        if (encodingStyle != null) {
            this.m_writer.addAttribute(2, "encodingStyle", encodingStyle);
        }
        this.m_writer.closeStartTag();
    }

    public void startHeader() throws IOException {
        this.m_writer.startTagClosed(2, "Header");
    }

    public void endHeader() throws IOException {
        this.m_writer.endTag(2, "Header");
    }

    public void startBody() throws IOException {
        this.m_writer.startTagClosed(2, "Body");
    }

    public void endBody() throws IOException {
        this.m_writer.endTag(2, "Body");
        this.m_writer.endTag(2, "Envelope");
    }

    public void startFault(SoapFault fault) throws IOException {
        String faultCode = null;
        String uri = fault.getFaultCode().getUri();
        String prefix = fault.getFaultCode().getPrefix();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(uri)) {
            this.m_customFaultCodeNS = false;
            this.m_writer.startTagClosed(2, "Fault");
            faultCode = "SOAP:" + fault.getFaultCode().getName();
        } else {
            this.m_customFaultCodeNS = true;
            int base = this.m_writer.getNamespaceCount();
            int[] indexes = new int[]{base};
            String[] uris = new String[]{uri};
            String[] prefs = new String[]{prefix};
            this.m_writer.pushExtensionNamespaces(uris);
            this.m_writer.startTagNamespaces(2, "Fault", indexes, prefs);
            this.m_writer.closeStartTag();
            faultCode = prefix + ":" + fault.getFaultCode().getName();
        }
        this.writeTextElement(0, "faultcode", faultCode);
        this.writeTextElement(0, "faultstring", fault.getFaultString());
        if (fault.getFaultActor() != null) {
            this.writeTextElement(0, "faultactor", fault.getFaultActor());
        }
    }

    public void startFaultDetail() throws IOException {
        this.m_writer.startTagClosed(0, "detail");
    }

    public void endFaultDetail() throws IOException {
        this.m_writer.endTag(0, "detail");
    }

    public void endFault() throws IOException {
        this.m_writer.endTag(2, "Fault");
        if (this.m_customFaultCodeNS) {
            this.m_writer.popExtensionNamespaces();
        }
    }

    public void sendMessageCompletely() throws IOException {
        this.m_connection.close();
    }

    public void abortMessage() throws IOException {
        this.m_connection.close();
    }

    private void writeTextElement(int nsi, String elementName, String text) throws IOException {
        this.m_writer.startTagClosed(nsi, elementName);
        this.m_writer.writeTextContent(text);
        this.m_writer.endTag(nsi, elementName);
    }
}

