/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jibx.runtime.IBindingFactory;
import org.jibx.ws.WsBindingException;
import org.jibx.ws.WsConfigurationException;
import org.jibx.ws.WsException;
import org.jibx.ws.client.Client;
import org.jibx.ws.context.ExchangeContext;
import org.jibx.ws.context.InContext;
import org.jibx.ws.context.OutContext;
import org.jibx.ws.io.MessageOptions;
import org.jibx.ws.io.handler.InHandler;
import org.jibx.ws.io.handler.MarshallingOutHandler;
import org.jibx.ws.io.handler.OutHandler;
import org.jibx.ws.io.handler.UnmarshallingInHandler;
import org.jibx.ws.process.Processor;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.soap.SoapFaultException;
import org.jibx.ws.soap.SoapPhase;
import org.jibx.ws.soap.SoapProcessor;
import org.jibx.ws.soap.SoapProtocol;
import org.jibx.ws.soap.client.SoapFaultResolver;
import org.jibx.ws.transport.DuplexConnection;
import org.jibx.ws.transport.MessageProperties;

public final class SoapClient
extends Client {
    private SoapProtocol m_protocol = SoapProtocol.SOAP1_1;
    private SoapProcessor m_processor;
    private List m_outHeaderHandlers;
    private List m_inHeaderHandlers;
    private List m_inFaultDetailsHandlers;
    private String m_operationName;
    private String m_encodingStyle;
    private SoapFaultResolver m_soapFaultResolver;
    private InContext m_inCtx;
    private OutContext m_outCtx;

    public SoapClient(String location) throws WsConfigurationException {
        super(location);
    }

    public SoapClient(String location, IBindingFactory factory) throws WsBindingException, WsConfigurationException {
        super(location);
        this.setBindingFactory(factory);
    }

    public SoapClient(String location, IBindingFactory factory, MessageOptions options) throws WsBindingException, WsConfigurationException {
        this(location, factory);
        this.setMessageOptions(options);
    }

    public SoapClient(String location, IBindingFactory factory, MessageOptions options, SoapProtocol protocol) throws WsBindingException, WsConfigurationException {
        this(location, factory, options);
        this.setProtocol(protocol);
    }

    public void setProtocol(SoapProtocol protocol) {
        this.m_protocol = protocol;
        this.setModified(true);
    }

    public void setBindingFactory(IBindingFactory factory) throws WsBindingException {
        this.setOutBodyBindingFactory(factory);
        this.setInBodyBindingFactory(factory);
        this.addInFaultDetailsBindingFactory(factory);
        this.setModified(true);
    }

    public void setOperationName(String operationName) {
        this.m_operationName = operationName;
    }

    public void setSoapEncodingStyle(String encodingStyle) {
        this.m_encodingStyle = encodingStyle;
    }

    public void setOutHeaderHandlers(List outHeaderHandlers) throws WsConfigurationException {
        Iterator iter = outHeaderHandlers.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof OutHandler) continue;
            throw new WsConfigurationException("The list passed to setOutHeaderHandlers must only contain objects of type OutHandler");
        }
        this.m_outHeaderHandlers = outHeaderHandlers;
        this.setModified(true);
    }

    public void addOutHeaderHandler(OutHandler headerHandler) {
        if (this.m_outHeaderHandlers == null) {
            this.m_outHeaderHandlers = new ArrayList();
        }
        this.m_outHeaderHandlers.add(headerHandler);
        this.setModified(true);
    }

    public void addOutHeader(Object obj) throws WsException {
        this.addOutHeaderHandler(new MarshallingOutHandler(obj));
    }

    public void removeOutHeaderHandlers() {
        this.m_outHeaderHandlers = null;
        this.setModified(true);
    }

    public void setInHeaderHandlers(List inHeaderHandlers) throws WsConfigurationException {
        Iterator iter = inHeaderHandlers.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof InHandler) continue;
            throw new WsConfigurationException("The list passed to setInHeaderHandlers must only contain objects of type InHandler");
        }
        this.m_inHeaderHandlers = inHeaderHandlers;
        this.setModified(true);
    }

    public void addInHeaderHandler(InHandler headerHandler) {
        if (this.m_inHeaderHandlers == null) {
            this.m_inHeaderHandlers = new ArrayList();
        }
        this.m_inHeaderHandlers.add(headerHandler);
        this.setModified(true);
    }

    public void removeInHeaderHandlers() {
        this.m_inHeaderHandlers = null;
        this.setModified(true);
    }

    public void addInFaultDetailsBindingFactory(IBindingFactory factory) throws WsBindingException {
        this.addInFaultDetailsHandler(new UnmarshallingInHandler(factory));
    }

    public void addInFaultDetailsHandler(InHandler inFaultDetailsHandler) {
        if (this.m_inFaultDetailsHandlers == null) {
            this.m_inFaultDetailsHandlers = new ArrayList();
        }
        this.m_inFaultDetailsHandlers.add(inFaultDetailsHandler);
        this.setModified(true);
    }

    public void removeInFaultDetailsHandlers() {
        this.m_inFaultDetailsHandlers = null;
        this.setModified(true);
    }

    public void removeAllHandlers() {
        this.removeOutHeaderHandlers();
        this.removeInHeaderHandlers();
        this.removeInFaultDetailsHandlers();
    }

    public void setSoapFaultResolver(SoapFaultResolver soapFaultResolver) {
        this.m_soapFaultResolver = soapFaultResolver;
    }

    public Object call(Object request) throws IOException, WsException {
        if (this.getBodyWriter() == null && request != null) {
            throw new WsConfigurationException("Binding factory or handler must be defined for the outbound SOAP body");
        }
        Processor processor = this.getProcessor();
        this.m_outCtx.setBody(request);
        MessageProperties msgProps = this.m_protocol.buildMessageProperties(this.m_operationName, this.getMessageOptions());
        DuplexConnection duplex = this.getChannel().getDuplex(msgProps, this.getMessageOptions().getXmlOptions());
        processor.invoke(duplex.getOutbound(), duplex.getInbound());
        Object body = this.m_inCtx.getBody();
        if (body instanceof SoapFault) {
            return this.handleFault((SoapFault)body);
        }
        return this.m_inCtx.getBody();
    }

    private Object handleFault(SoapFault fault) {
        if (this.m_soapFaultResolver != null) {
            return this.m_soapFaultResolver.handleFault(fault);
        }
        throw new SoapFaultException(fault);
    }

    private Processor getProcessor() throws WsException {
        if (this.m_processor != null) {
            this.m_processor.reset();
        }
        if (this.m_processor == null || this.isModified()) {
            Object handler;
            Iterator iter;
            this.m_outCtx = new OutContext();
            if (this.m_outHeaderHandlers != null) {
                iter = this.m_outHeaderHandlers.iterator();
                while (iter.hasNext()) {
                    handler = (OutHandler)iter.next();
                    this.m_outCtx.addHandler(SoapPhase.HEADER, (OutHandler)handler);
                }
            }
            if (this.getBodyWriter() != null) {
                this.m_outCtx.setBodyWriter(this.getBodyWriter());
            }
            this.m_inCtx = new InContext();
            if (this.m_inHeaderHandlers != null) {
                iter = this.m_inHeaderHandlers.iterator();
                while (iter.hasNext()) {
                    handler = (InHandler)iter.next();
                    this.m_inCtx.addHandler(SoapPhase.HEADER, (InHandler)handler);
                }
            }
            if (this.getBodyReader() != null) {
                this.m_inCtx.setBodyReader(this.getBodyReader());
            }
            if (this.m_inFaultDetailsHandlers != null) {
                iter = this.m_inFaultDetailsHandlers.iterator();
                while (iter.hasNext()) {
                    handler = (InHandler)iter.next();
                    this.m_inCtx.addHandler(SoapPhase.BODY_FAULT, (InHandler)handler);
                }
            }
            this.m_processor = (SoapProcessor)this.m_protocol.createProcessor(ExchangeContext.createOutInExchange(this.m_outCtx, this.m_inCtx));
            this.m_processor.setSoapEncodingStyle(this.m_encodingStyle);
            this.setModified(false);
        }
        return this.m_processor;
    }
}

