/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.soap.server;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.ws.io.handler.ExceptionWriter;
import org.jibx.ws.process.Processor;
import org.jibx.ws.server.ServiceExceptionHandler;
import org.jibx.ws.soap.SoapFault;
import org.jibx.ws.soap.SoapFaultException;
import org.jibx.ws.soap.SoapProcessor;
import org.jibx.ws.soap.WsNotUnderstoodException;
import org.jibx.ws.transport.OutServerConnection;

public final class SoapFaultHandler
implements ServiceExceptionHandler {
    private static final Log logger = LogFactory.getLog((Class)(class$org$jibx$ws$soap$server$SoapFaultHandler == null ? (class$org$jibx$ws$soap$server$SoapFaultHandler = SoapFaultHandler.class$("org.jibx.ws.soap.server.SoapFaultHandler")) : class$org$jibx$ws$soap$server$SoapFaultHandler));
    private boolean m_includeStackTrace;
    static /* synthetic */ Class class$org$jibx$ws$soap$server$SoapFaultHandler;

    public SoapFaultHandler(boolean includeStackTrace) {
        this.m_includeStackTrace = includeStackTrace;
    }

    public void handleException(Throwable e, Processor processor, OutServerConnection outConn) {
        logger.warn((Object)"Error processing request. Generating SOAP Fault response.", e);
        outConn.setInternalServerError();
        try {
            SoapFault fault;
            Throwable wrapped;
            if (e instanceof InvocationTargetException && (wrapped = ((InvocationTargetException)e).getTargetException()) != null) {
                e = wrapped;
            }
            SoapProcessor soapProcessor = (SoapProcessor)processor;
            if (e instanceof SoapFaultException) {
                fault = ((SoapFaultException)e).getFault();
            } else if (e instanceof WsNotUnderstoodException) {
                fault = new SoapFault(SoapFault.FAULT_CODE_MUST_UNDERSTAND, e.getMessage(), null);
            } else {
                fault = new SoapFault(SoapFault.FAULT_CODE_SERVER, e.getMessage(), null);
                if (this.m_includeStackTrace) {
                    fault.addDetailWriter(new ExceptionWriter(e, this.m_includeStackTrace));
                }
            }
            soapProcessor.sendFaultMessage(fault, outConn);
        }
        catch (Throwable ex) {
            logger.error((Object)"Error while processing prior error", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

