/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.tcp.server;

import java.io.IOException;
import java.net.Socket;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.IInByteBuffer;
import org.jibx.runtime.impl.IOutByteBuffer;
import org.jibx.runtime.impl.InByteBuffer;
import org.jibx.runtime.impl.OutByteBuffer;
import org.jibx.ws.codec.CodecCache;
import org.jibx.ws.codec.CodecDirectory;
import org.jibx.ws.codec.MediaType;
import org.jibx.ws.codec.XmlCodec;
import org.jibx.ws.encoding.dime.DimeInputBuffer;
import org.jibx.ws.encoding.dime.DimeOutputBuffer;
import org.jibx.ws.io.XmlOptions;
import org.jibx.ws.protocol.Protocol;
import org.jibx.ws.protocol.ProtocolDirectory;
import org.jibx.ws.server.Service;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.server.ServiceFactory;
import org.jibx.ws.server.ServicePool;
import org.jibx.ws.tcp.server.TcpServer;
import org.jibx.ws.transport.InConnection;
import org.jibx.ws.transport.OutConnectionBase;
import org.jibx.ws.transport.OutServerConnection;

public class SocketRunner
implements Runnable {
    private static final Log s_logger = LogFactory.getLog((Class)(class$org$jibx$ws$tcp$server$SocketRunner == null ? (class$org$jibx$ws$tcp$server$SocketRunner = SocketRunner.class$("org.jibx.ws.tcp.server.SocketRunner")) : class$org$jibx$ws$tcp$server$SocketRunner));
    private final Socket m_socket;
    private final ServiceDefinition m_sdef;
    private final TcpServer m_server;
    private final String m_clientAddress;
    private final CodecCache m_codecCache;
    SocketRunner m_next;
    SocketRunner m_last;
    private DimeInputBuffer m_dimeInput;
    private DimeOutputBuffer m_dimeOutput;
    private boolean m_exit;
    static /* synthetic */ Class class$org$jibx$ws$tcp$server$SocketRunner;

    public SocketRunner(Socket socket, ServiceDefinition sdef, TcpServer server) throws IOException {
        this.m_socket = socket;
        this.m_socket.setTcpNoDelay(true);
        this.m_sdef = sdef;
        this.m_server = server;
        this.m_clientAddress = socket.getInetAddress().getHostAddress();
        this.m_dimeInput = new DimeInputBuffer();
        InByteBuffer ibuff = new InByteBuffer();
        this.m_dimeInput.setBuffer((IInByteBuffer)ibuff);
        ibuff.setInput(socket.getInputStream());
        this.m_dimeOutput = new DimeOutputBuffer();
        OutByteBuffer obuff = new OutByteBuffer();
        obuff.setOutput(socket.getOutputStream());
        this.m_dimeOutput.setBuffer((IOutByteBuffer)obuff);
        this.m_codecCache = new CodecCache();
    }

    public synchronized void setExit(boolean exit) {
        this.m_exit = exit;
        if (exit) {
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block20: {
            while (!this.m_exit && this.m_dimeInput.nextMessage() && this.m_dimeInput.nextPart()) {
                Object var8_9;
                Service serv = null;
                try {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Beginning processing of receive message from " + this.m_clientAddress));
                    }
                    MediaType mediaType = null;
                    if (this.m_dimeInput.getPartTypeCode() == 16) {
                        String partTypeText = this.m_dimeInput.getPartTypeText();
                        try {
                            MediaType partMediaType = new MediaType(partTypeText);
                            if (CodecDirectory.hasCodecFor(partMediaType)) {
                                mediaType = partMediaType;
                            }
                        }
                        catch (ParseException e) {
                            throw new IOException("Unable to parse media type '" + partTypeText + "'");
                        }
                    }
                    if (mediaType == null) {
                        mediaType = CodecDirectory.TEXT_XML_MEDIA_TYPE;
                    }
                    XmlCodec codec = this.m_codecCache.getCodec(mediaType);
                    IXMLReader reader = codec.getReader(this.m_dimeInput, null, this.m_clientAddress, false);
                    Protocol protocol = ProtocolDirectory.getProtocol(this.m_sdef.getProtocolName());
                    ServiceFactory serviceFactory = protocol.getServiceFactory();
                    serv = ServicePool.getInstance(serviceFactory, this.m_sdef);
                    serv.processRequest(new TcpInConnection(this.m_dimeInput, reader), new TcpOutConnection(codec, serv.getXmlOptions()));
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Completed processing of receive message from " + this.m_clientAddress));
                    }
                    var8_9 = null;
                    if (serv == null) continue;
                    serv.releaseInstance();
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (serv != null) {
                        serv.releaseInstance();
                    }
                    throw throwable;
                }
            }
            Object var10_11 = null;
            try {
                this.m_socket.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            this.m_server.unlink(this);
            {
                break block20;
                catch (Exception e) {
                    e.printStackTrace();
                    s_logger.error((Object)("TCP service error with client " + this.m_clientAddress), (Throwable)e);
                    Object var10_12 = null;
                    try {
                        this.m_socket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    this.m_server.unlink(this);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    this.m_socket.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                this.m_server.unlink(this);
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TcpOutConnection
    extends OutConnectionBase
    implements OutServerConnection {
        private final XmlCodec m_codec;
        private IXMLWriter m_writer;
        private boolean m_initialized;

        public TcpOutConnection(XmlCodec codec, XmlOptions xmlOptions) {
            super(xmlOptions);
            this.m_codec = codec;
        }

        public IXMLWriter getNormalWriter(String[] uris) throws IOException {
            if (!this.m_initialized) {
                MediaType mediaType = this.m_codec.getMediaType();
                int typecode = mediaType == null ? 64 : 16;
                SocketRunner.this.m_dimeOutput.nextMessage();
                SocketRunner.this.m_dimeOutput.nextPart(null, typecode, mediaType.toString());
                this.m_writer = this.m_codec.getWriter(SocketRunner.this.m_dimeOutput, null, uris);
                this.initializeWriter(this.m_writer);
                this.m_initialized = true;
            }
            return this.m_writer;
        }

        public IXMLWriter getFaultWriter(String[] uris) throws IOException {
            return this.getNormalWriter(uris);
        }

        public void close() throws IOException {
            if (this.m_initialized) {
                this.m_writer.flush();
                SocketRunner.this.m_dimeOutput.endMessage();
                SocketRunner.this.m_dimeOutput.flush();
            }
            this.m_initialized = false;
        }

        public boolean isCommitted() {
            return true;
        }

        public void sendNotFoundError() throws IOException {
        }

        public void setInternalServerError() {
        }

        public void outputComplete() {
        }
    }

    private static class TcpInConnection
    implements InConnection {
        private final DimeInputBuffer m_dimeInput;
        private final IXMLReader m_reader;

        public TcpInConnection(DimeInputBuffer dimein, IXMLReader reader) {
            this.m_dimeInput = dimein;
            this.m_reader = reader;
        }

        public String getCharacterEncoding() {
            return this.m_reader.getInputEncoding();
        }

        public String getContentType() {
            if (this.m_dimeInput.getPartTypeCode() == 16) {
                return this.m_dimeInput.getPartTypeText();
            }
            return null;
        }

        public String getDestination() {
            return null;
        }

        public String getId() {
            return this.m_dimeInput.getPartIdentifier();
        }

        public String getOperationName() {
            return null;
        }

        public String getOrigin() {
            return null;
        }

        public String getProperty(String name) {
            return null;
        }

        public IXMLReader getReader() {
            return this.m_reader;
        }

        public void init() throws IOException {
            this.m_reader.init();
        }

        public void close() throws IOException {
            this.m_dimeInput.finish();
        }

        public boolean hasError() throws IOException {
            return false;
        }

        public String getErrorMessage() throws IOException {
            return null;
        }

        public void inputComplete() {
        }
    }
}

