/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.tcp.server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.ws.server.ServiceDefinition;
import org.jibx.ws.tcp.server.SocketRunner;

public final class TcpServer
extends Thread {
    private static final Log s_logger = LogFactory.getLog((Class)(class$org$jibx$ws$tcp$server$TcpServer == null ? (class$org$jibx$ws$tcp$server$TcpServer = TcpServer.class$("org.jibx.ws.tcp.server.TcpServer")) : class$org$jibx$ws$tcp$server$TcpServer));
    private final ServerSocket m_socket;
    private final ServiceDefinition m_service;
    private boolean m_exit;
    private SocketRunner m_head;
    private SocketRunner m_tail;
    static /* synthetic */ Class class$org$jibx$ws$tcp$server$TcpServer;
    static /* synthetic */ Class class$org$jibx$ws$server$ServiceDefinition;

    private TcpServer(ServerSocket socket, ServiceDefinition service) {
        this.m_socket = socket;
        this.m_service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    SocketRunner runner = new SocketRunner(this.m_socket.accept(), this.m_service, this);
                    TcpServer tcpServer = this;
                    synchronized (tcpServer) {
                        if (this.m_head == null) {
                            this.m_head = this.m_tail = runner;
                        } else {
                            runner.m_last = this.m_tail;
                            this.m_tail.m_next = runner;
                            this.m_tail = runner;
                        }
                    }
                    Thread thread = new Thread(runner);
                    thread.start();
                }
            }
            catch (IOException e) {
                if (!this.m_exit) {
                    s_logger.error((Object)("Error on server socket for service " + this.m_service.getServiceName()), (Throwable)e);
                    continue;
                }
                TcpServer tcpServer = this;
                synchronized (tcpServer) {
                    while (!this.m_exit) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e2) {}
                    }
                    SocketRunner runner = this.m_head;
                    while (runner != null) {
                        runner.setExit(true);
                        runner = runner.m_next;
                    }
                }
                return;
            }
            break;
        }
    }

    private synchronized void setExit(boolean exit) {
        this.m_exit = exit;
        if (exit) {
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.notify();
        }
    }

    synchronized void unlink(SocketRunner runner) {
        if (runner == this.m_head) {
            if (runner == this.m_tail) {
                this.m_tail = null;
                this.m_head = null;
            } else {
                this.m_head = runner.m_next;
                this.m_head.m_last = null;
            }
        } else {
            runner.m_last.m_next = runner.m_next;
            if (runner == this.m_tail) {
                this.m_tail = runner.m_last;
            } else {
                runner.m_next.m_last = runner.m_last;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Need at least one service definition and port number parameter");
            System.exit(1);
        }
        IUnmarshallingContext ctx = null;
        try {
            ctx = BindingDirectory.getFactory((Class)(class$org$jibx$ws$server$ServiceDefinition == null ? (class$org$jibx$ws$server$ServiceDefinition = TcpServer.class$("org.jibx.ws.server.ServiceDefinition")) : class$org$jibx$ws$server$ServiceDefinition)).createUnmarshallingContext();
        }
        catch (JiBXException e) {
            System.err.println("Unable to initialize unmarshalling: " + e.getMessage());
        }
        ServiceDefinition[] sdefs = new ServiceDefinition[args.length];
        int[] ports = new int[args.length];
        boolean valid = true;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            int split = arg.indexOf(61);
            String path = arg.substring(0, split);
            if (split > 0) {
                InputStream is = null;
                ports[i] = Integer.parseInt(arg.substring(split + 1));
                is = new FileInputStream(path);
                sdefs[i] = (ServiceDefinition)ctx.unmarshalDocument(is, null);
                Object var12_21 = null;
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ignore) {}
                continue;
                {
                    catch (NumberFormatException e) {
                        System.err.println("Error parsing port number in argument " + i + ": " + arg);
                        valid = false;
                        var12_21 = null;
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Service definition file not found for argument " + i + ": " + path);
                        valid = false;
                        var12_21 = null;
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                    catch (JiBXException e) {
                        System.err.println("Error unmarshalling service definition " + i + " (" + path + "): " + e.getMessage());
                        valid = false;
                        var12_21 = null;
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_21 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            System.err.println("Missing required '=' in argument " + i + ": " + arg);
            valid = false;
        }
        if (valid) {
            TcpServer[] servers = new TcpServer[ports.length];
            for (int i = 0; i < ports.length; ++i) {
                try {
                    ServerSocket socket = new ServerSocket(ports[i]);
                    servers[i] = new TcpServer(socket, sdefs[i]);
                    Thread thread = new Thread(servers[i]);
                    thread.start();
                    continue;
                }
                catch (IOException e) {
                    System.err.println("Error opening socket on port " + ports[i] + " for service " + sdefs[i].getServiceName());
                }
            }
            System.out.println("Type enter when ready to shutdown servers.");
            try {
                System.in.read();
            }
            catch (IOException ex) {
                // empty catch block
            }
            for (int i = 0; i < servers.length; ++i) {
                if (servers[i] == null) continue;
                servers[i].setExit(true);
            }
        } else {
            System.exit(2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

