/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jibx.ws.transport.Transport;
import org.jibx.ws.transport.TransportOptions;

public final class TransportDirectory {
    private static final String TRANSPORT_PROPERTIES_PATH = "/transport.properties";
    private static final Map s_protocolMap = new HashMap();
    static /* synthetic */ Class class$org$jibx$ws$transport$TransportDirectory;

    private TransportDirectory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void loadProperties(String path) {
        InputStream stream = null;
        try {
            try {
                Properties props = new Properties();
                stream = (class$org$jibx$ws$transport$TransportDirectory == null ? (class$org$jibx$ws$transport$TransportDirectory = TransportDirectory.class$("org.jibx.ws.transport.TransportDirectory")) : class$org$jibx$ws$transport$TransportDirectory).getResourceAsStream(path);
                if (stream == null) {
                    throw new RuntimeException("Unable to load required properties file '" + path + '\'');
                }
                props.load(stream);
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    String protocol = (String)iter.next();
                    String classname = props.getProperty(protocol);
                    try {
                        Class<?> clas = (class$org$jibx$ws$transport$TransportDirectory == null ? TransportDirectory.class$("org.jibx.ws.transport.TransportDirectory") : class$org$jibx$ws$transport$TransportDirectory).getClassLoader().loadClass(classname);
                        Object inst = clas.newInstance();
                        if (!(inst instanceof Transport)) throw new IllegalStateException("Class " + classname + ", specified for protocol '" + protocol + "', is not an org.jibx.ws.transport.Transport implementation");
                        s_protocolMap.put(protocol.toLowerCase(), inst);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to load transport class " + classname);
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException("Error creating an instance of transport class " + classname + ": " + e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Unable to create an instance of transport class " + classname);
                    }
                }
                Object var9_12 = null;
                if (stream == null) return;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load required properties file '" + path + '\'');
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignore) {}
        stream.close();
        return;
    }

    public static Transport getTransport(String endpoint) {
        Transport transport = null;
        int split = endpoint.indexOf(58);
        if (split > 0) {
            String protocol = endpoint.substring(0, split);
            transport = (Transport)s_protocolMap.get(protocol.toLowerCase());
            if (transport == null) {
                throw new IllegalArgumentException("No transport defined for protocol '" + protocol + "' of endpoint '" + endpoint + "'");
            }
        } else {
            throw new IllegalArgumentException("Unrecognized endpoint '" + endpoint + "' - missing required protocol");
        }
        return transport;
    }

    public static TransportOptions newTransportOptions(String endpoint) {
        return TransportDirectory.getTransport(endpoint).newTransportOptions();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TransportDirectory.loadProperties(TRANSPORT_PROPERTIES_PATH);
    }
}

