/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jibx.ws.WsException;
import org.jibx.ws.wsdl.WsdlProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WsdlLocationToRequestUrlAdapter
implements WsdlProvider {
    private static final String WSDLSOAP_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    private final WsdlProvider m_wsdlProvider;
    private HashMap m_wsdlMap = new HashMap();

    public WsdlLocationToRequestUrlAdapter(WsdlProvider wsdlProvider) {
        this.m_wsdlProvider = wsdlProvider;
    }

    public void writeWSDL(OutputStream outputStream, HttpServletRequest req) throws IOException, WsException {
        outputStream.write(this.getAdaptedWsdl(req));
    }

    public InputStream getWSDL(HttpServletRequest req) throws IOException, WsException {
        return new ByteArrayInputStream(this.getAdaptedWsdl(req));
    }

    private String getLocationBase(HttpServletRequest req) {
        StringBuffer locationBaseBuf = new StringBuffer(64);
        locationBaseBuf.append(req.getScheme()).append("://").append(req.getServerName()).append(":").append(req.getServerPort());
        String locationBase = locationBaseBuf.toString();
        return locationBase;
    }

    private synchronized byte[] getAdaptedWsdl(HttpServletRequest req) throws IOException, WsException {
        String locationBase = this.getLocationBase(req);
        byte[] wsdl = (byte[])this.m_wsdlMap.get(locationBase);
        if (wsdl == null) {
            wsdl = this.adaptWsdl(req, locationBase);
            this.m_wsdlMap.put(locationBase, wsdl);
        }
        return wsdl;
    }

    private byte[] adaptWsdl(HttpServletRequest req, String locationBase) throws IOException, WsException {
        Document doc;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            DocumentBuilder bldr = fact.newDocumentBuilder();
            doc = bldr.parse(this.m_wsdlProvider.getWSDL(req));
            Element schema = doc.getDocumentElement();
            NodeList services = schema.getElementsByTagNameNS(WSDLSOAP_NAMESPACE, "address");
            for (int i = 0; i < services.getLength(); ++i) {
                Node node = services.item(i).getAttributes().getNamedItem("location");
                if (node == null) continue;
                String location = node.getTextContent();
                node.setTextContent(this.adaptLocation(location, locationBase));
            }
        }
        catch (ParserConfigurationException e) {
            throw new WsException("Unable to configure parser for WSDL adapter: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new WsException("Error parsing supplied WSDL: " + e.getMessage());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new WsException("Error transforming WSDL: " + e.getMessage());
        }
        return baos.toByteArray();
    }

    private String adaptLocation(String initialLocation, String locationBase) {
        String location = initialLocation;
        if (initialLocation.startsWith("/")) {
            location = locationBase + initialLocation;
        } else {
            int idx = initialLocation.indexOf("://");
            if (idx != -1 && (idx = initialLocation.indexOf("/", idx + 3)) != -1) {
                location = locationBase + initialLocation.substring(idx);
            }
        }
        return location;
    }
}

