/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.jibx.maven.AbstractJibxMojo;
import org.jibx.maven.IncludeBaseBinding;
import org.jibx.schema.codegen.CodeGen;

public abstract class AbstractCodeGenMojo
extends AbstractJibxMojo {
    private boolean verbose;
    private String defaultPackage = null;
    private ArrayList<String> customizations;
    private String schemaLocation;
    @Deprecated
    private String directory;
    private String defaultNamespace = null;
    ArrayList<String> excludeSchemas;
    ArrayList<String> includeSchemas;
    @Deprecated
    ArrayList<String> includeBindings;
    @Deprecated
    private String targetDirectory;
    private Map<String, String> options;
    private MavenProjectHelper projectHelper;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] classpaths;
        String mode;
        this.checkConfiguration();
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Not running JiBX code generator for pom packaging");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            String option = "--" + entry.getKey() + "=" + entry.getValue();
            if (entry.getKey().toString().length() == 1 && Character.isLowerCase(entry.getKey().toString().charAt(0))) {
                this.getLog().debug((CharSequence)("Adding option : -" + entry.getKey() + " " + entry.getValue()));
                args.add("-" + entry.getKey());
                args.add(entry.getValue());
                continue;
            }
            this.getLog().debug((CharSequence)("Adding option: " + option));
            args.add(option);
        }
        if (this.verbose) {
            args.add("-v");
        }
        if (this.defaultPackage != null) {
            args.add("-n");
            args.add(this.defaultPackage);
        }
        args.add("-t");
        args.add(this.getFullPath(this.getSchemaBindingDirectory()));
        if (this.customizations.size() > 0) {
            args.add("-c");
            for (String customization : this.customizations) {
                args.add(customization);
            }
        }
        if (this.defaultNamespace != null) {
            args.add("-u");
            args.add(this.defaultNamespace);
        }
        String allBindings = "";
        String[] bindings = new String[]{};
        if (this.isMultiModuleMode()) {
            mode = this.isRestrictedMultiModuleMode() ? "restricted multi-module" : "multi-module";
            classpaths = this.getMultiModuleClasspaths();
        } else {
            mode = "single-module";
            classpaths = this.getSingleModuleClasspaths();
        }
        for (String binding : bindings = this.getBaseBindings(bindings)) {
            if (allBindings.length() > 0) {
                allBindings = allBindings + ",";
            }
            allBindings = allBindings + binding;
        }
        if (allBindings.length() > 0) {
            args.add("-i");
            args.add(allBindings);
        }
        List<String> schemas = this.getSchemas(this.getFullPath(this.getSchemaLocation()));
        for (String schema : schemas) {
            File file = new File(schema);
            if (file.exists()) {
                args.add(new File(schema).toURI().toString());
                continue;
            }
            try {
                args.add(new URL(schema).toURI().toString());
            }
            catch (URISyntaxException e) {
                this.getLog().warn((CharSequence)"Target schema is not a valid file or URL - Passing location as is");
                args.add(schema);
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)"Target schema is not a valid file or URL - Passing location as is");
                args.add(schema);
            }
        }
        this.getLog().debug((CharSequence)("Adding " + this.getSchemaBindingDirectory() + " as source directory..."));
        this.project.addCompileSourceRoot(this.getFullPath(this.getSchemaBindingDirectory()));
        try {
            this.getLog().info((CharSequence)("Generating Java sources in " + this.getSchemaBindingDirectory() + " from schemas available in " + this.getSchemaLocation() + "..."));
            CodeGen.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new MojoExecutionException(cause.getLocalizedMessage(), cause);
        }
    }

    public String getSingleModuleBindingPath(String basedir, String includeBinding) {
        File file;
        if (!includeBinding.contains(",") && !(file = new File(includeBinding)).isAbsolute()) {
            try {
                file = new File(this.addToPath(basedir, includeBinding));
                if (file.exists()) {
                    includeBinding = this.addToPath(basedir, includeBinding);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return includeBinding;
    }

    @Override
    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.includeSchemas == null || this.includeSchemas.size() == 0) {
            this.includeSchemas = new ArrayList();
        }
        if (this.excludeSchemas == null) {
            this.excludeSchemas = new ArrayList();
        }
        if (this.includes != null && this.includes.size() > 0) {
            this.includeSchemas.addAll(this.includes);
        }
        if (this.excludes != null && this.excludes.size() > 0) {
            this.excludeSchemas.addAll(this.excludes);
        }
        if (this.includeSchemas.size() == 0) {
            this.includeSchemas.add("*.xsd");
        }
        if (this.customizations == null) {
            this.customizations = new ArrayList();
        }
        if (this.includeBindings != null && this.includeBindings.size() > 0) {
            IncludeBaseBinding includeBaseBinding = new IncludeBaseBinding();
            includeBaseBinding.setIncludes(this.includeBindings);
            this.includeBaseBindings.add(includeBaseBinding);
        }
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
    }

    private List<String> getSchemas(String path) throws MojoExecutionException, MojoFailureException {
        return this.getIncludedFiles(path, this.includeSchemas, this.excludeSchemas);
    }

    protected String getSchemaLocation() {
        if (this.schemaLocation != null) {
            return this.schemaLocation;
        }
        if (this.directory != null) {
            return this.directory;
        }
        return this.getDefaultSchemaLocation();
    }

    abstract String getDefaultSchemaLocation();

    @Override
    protected String getSchemaBindingDirectory() {
        if (this.schemaBindingDirectory != null) {
            return this.schemaBindingDirectory;
        }
        if (this.targetDirectory != null) {
            return this.targetDirectory;
        }
        return super.getSchemaBindingDirectory();
    }
}

