/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jibx.maven.AbstractJibx2WsdlMojo;

public class Jibx2WsdlMojo
extends AbstractJibx2WsdlMojo {
    @Override
    protected Set<String> getProjectCompileClasspathElements(MavenProject project) throws MojoExecutionException {
        try {
            return new HashSet<String>(this.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getCompileClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.project.getDependencyArtifacts().size());
        list.add(this.project.getBuild().getOutputDirectory());
        for (Artifact a : this.project.getDependencyArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !"compile".equals(a.getScope()) && !"provided".equals(a.getScope()) && !"system".equals(a.getScope())) continue;
            String refId = Jibx2WsdlMojo.getProjectReferenceId(a.getGroupId(), a.getArtifactId());
            MavenProject project = (MavenProject)this.project.getProjectReferences().get(refId);
            if (project != null) {
                list.add(project.getBuild().getOutputDirectory());
                continue;
            }
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        return list;
    }

    private static String getProjectReferenceId(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    @Override
    protected String getDefaultSchemaBindingDirectory() {
        return "src/main/config";
    }
}

