/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.path;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueRewriterWalker;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import org.jinq.rebased.org.objectweb.asm.Type;

public class SymbExBooleanRewriter
extends TypedValueRewriterWalker<Boolean, RuntimeException> {
    public SymbExBooleanRewriter() {
        super(new TypedValueVisitor<Boolean, TypedValue, RuntimeException>(){

            @Override
            public TypedValue defaultValue(TypedValue val, Boolean in) {
                return val;
            }
        }, new TypedValueVisitor<Boolean, Boolean, RuntimeException>(){

            @Override
            public Boolean defaultValue(TypedValue val, Boolean in) {
                return false;
            }

            @Override
            public Boolean notOpValue(TypedValue.NotValue val, Boolean in) {
                return true;
            }

            @Override
            public Boolean staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, Boolean in) throws RuntimeException {
                if (val.getSignature().equals(TransformationClassAnalyzer.booleanValueOf)) {
                    return true;
                }
                return (Boolean)super.staticMethodCallValue(val, in);
            }

            @Override
            public Boolean getStaticFieldValue(TypedValue.GetStaticFieldValue val, Boolean in) throws RuntimeException {
                if ("java/lang/Boolean".equals(val.owner) && ("TRUE".equals(val.name) || "FALSE".equals(val.name))) {
                    return true;
                }
                return (Boolean)super.getStaticFieldValue(val, in);
            }

            @Override
            public Boolean binaryOpValue(TypedValue.BinaryOperationValue val, Boolean in) {
                if ("AND".equals(val.operation) || "OR".equals(val.operation)) {
                    return true;
                }
                if (val.left.getType() == Type.BOOLEAN_TYPE || val.right.getType() == Type.BOOLEAN_TYPE) {
                    return true;
                }
                return this.defaultValue((TypedValue)val, in);
            }
        });
    }

    @Override
    public TypedValue integerConstantValue(ConstantValue.IntegerConstant val, Boolean in) {
        if (in.booleanValue()) {
            if (val.getConstant() == 0) {
                return new ConstantValue.BooleanConstant(false);
            }
            return new ConstantValue.BooleanConstant(true);
        }
        return val;
    }
}

