/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.path;

import ch.epfl.labos.iu.orm.queryll2.path.CFG;
import ch.epfl.labos.iu.orm.queryll2.path.CodePath;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSupplementalFactory;
import ch.epfl.labos.iu.orm.queryll2.path.StaticMethodAnalysisStorage;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jinq.rebased.org.objectweb.asm.ClassReader;
import org.jinq.rebased.org.objectweb.asm.ClassVisitor;
import org.jinq.rebased.org.objectweb.asm.tree.ClassNode;
import org.jinq.rebased.org.objectweb.asm.tree.MethodNode;
import org.jinq.rebased.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jinq.tuples.Tuple6;
import org.jinq.tuples.Tuple7;
import org.jinq.tuples.Tuple8;

public class TransformationClassAnalyzer {
    public static final int MAX_PATHS = 64;
    public static Map<String, String> TransformationClassMethods = new HashMap<String, String>();
    public static Set<MethodSignature> KnownSafeMethods = new HashSet<MethodSignature>();
    public static Set<MethodSignature> KnownSafeStaticMethods = new HashSet<MethodSignature>();
    public static Set<Class<?>> SafeMethodAnnotations = new HashSet();
    public static final String WHERE_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$Where";
    public static final String WHERE_METHOD = "where";
    public static final String SELECT_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$Select";
    public static final String SELECT_METHOD = "select";
    public static final String AGGREGATESELECT_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateSelect";
    public static final String AGGREGATESELECT_METHOD = "aggregateSelect";
    public static final String AGGREGATEINTEGER_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateInteger";
    public static final String AGGREGATEINTEGER_METHOD = "aggregate";
    public static final String AGGREGATEDOUBLE_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateDouble";
    public static final String AGGREGATEDOUBLE_METHOD = "aggregate";
    public static final String JOIN_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$Join";
    public static final String JOIN_METHOD = "join";
    public static final String GROUP_INTERFACE = "ch/epfl/labos/iu/orm/DBSet$AggregateGroup";
    public static final String GROUP_METHOD = "aggregateSelect";
    public static final String DATESORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/DateSorter";
    public static final String DATESORTER_METHOD = "value";
    public static final String INTSORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/IntSorter";
    public static final String INTSORTER_METHOD = "value";
    public static final String DOUBLESORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/DoubleSorter";
    public static final String DOUBLESORTER_METHOD = "value";
    public static final String STRINGSORTER_SUPERCLASS = "ch/epfl/labos/iu/orm/StringSorter";
    public static final String STRINGSORTER_METHOD = "value";
    public static final String DBSET_CLASS = "Lch/epfl/labos/iu/orm/DBSet;";
    public static final String JINQSTREAM_CLASS = "Lorg/jinq/orm/stream/JinqStream;";
    public static final MethodSignature stringEquals = new MethodSignature("java/lang/String", "equals", "(Ljava/lang/Object;)Z");
    public static final MethodSignature stringCompareTo = new MethodSignature("java/lang/String", "compareTo", "(Ljava/lang/String;)I");
    public static final MethodSignature stringLike = new MethodSignature("ch/epfl/labos/iu/orm/Util", "SQLStringLike", "(Ljava/lang/String;Ljava/lang/String;)Z");
    public static final MethodSignature newStringBuilderString = new MethodSignature("java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
    public static final MethodSignature newStringBuilder = new MethodSignature("java/lang/StringBuilder", "<init>", "()V");
    public static final MethodSignature stringBuilderAppendString = new MethodSignature("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
    public static final MethodSignature stringBuilderToString = new MethodSignature("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
    public static final MethodSignature booleanEquals;
    public static final MethodSignature dateEquals;
    public static final MethodSignature dateBefore;
    public static final MethodSignature dateAfter;
    public static final MethodSignature calendarEquals;
    public static final MethodSignature calendarBefore;
    public static final MethodSignature calendarAfter;
    public static final MethodSignature sqlDateEquals;
    public static final MethodSignature sqlDateBefore;
    public static final MethodSignature sqlDateAfter;
    public static final MethodSignature sqlTimeEquals;
    public static final MethodSignature sqlTimeBefore;
    public static final MethodSignature sqlTimeAfter;
    public static final MethodSignature sqlTimestampEquals;
    public static final MethodSignature sqlTimestampBefore;
    public static final MethodSignature sqlTimestampAfter;
    public static final MethodSignature localDateIsBefore;
    public static final MethodSignature localDateIsAfter;
    public static final MethodSignature localDateIsEqual;
    public static final MethodSignature localTimeIsBefore;
    public static final MethodSignature localTimeIsAfter;
    public static final MethodSignature localDateTimeIsBefore;
    public static final MethodSignature localDateTimeIsAfter;
    public static final MethodSignature localDateTimeIsEqual;
    public static final MethodSignature offsetTimeIsBefore;
    public static final MethodSignature offsetTimeIsAfter;
    public static final MethodSignature offsetTimeIsEqual;
    public static final MethodSignature offsetDateTimeIsBefore;
    public static final MethodSignature offsetDateTimeIsAfter;
    public static final MethodSignature offsetDateTimeIsEqual;
    public static final MethodSignature zonedDateTimeIsBefore;
    public static final MethodSignature zonedDateTimeIsAfter;
    public static final MethodSignature zonedDateTimeIsEqual;
    public static final MethodSignature instantIsBefore;
    public static final MethodSignature instantIsAfter;
    public static final MethodSignature bigDecimalCompareTo;
    public static final MethodSignature bigDecimalEquals;
    public static final MethodSignature bigDecimalAdd;
    public static final MethodSignature bigDecimalDivide;
    public static final MethodSignature bigDecimalMultiply;
    public static final MethodSignature bigDecimalSubtract;
    public static final MethodSignature bigIntegerCompareTo;
    public static final MethodSignature bigIntegerEquals;
    public static final MethodSignature bigIntegerAdd;
    public static final MethodSignature bigIntegerDivide;
    public static final MethodSignature bigIntegerMultiply;
    public static final MethodSignature bigIntegerSubtract;
    public static final MethodSignature uuidEquals;
    public static final MethodSignature uuidCompareTo;
    public static final MethodSignature newPair;
    public static final MethodSignature pairGetOne;
    public static final MethodSignature pairGetTwo;
    public static final MethodSignature newTuple3;
    public static final MethodSignature tuple3GetOne;
    public static final MethodSignature tuple3GetTwo;
    public static final MethodSignature tuple3GetThree;
    public static final MethodSignature newTuple4;
    public static final MethodSignature tuple4GetOne;
    public static final MethodSignature tuple4GetTwo;
    public static final MethodSignature tuple4GetThree;
    public static final MethodSignature tuple4GetFour;
    public static final MethodSignature newTuple5;
    public static final MethodSignature tuple5GetOne;
    public static final MethodSignature tuple5GetTwo;
    public static final MethodSignature tuple5GetThree;
    public static final MethodSignature tuple5GetFour;
    public static final MethodSignature tuple5GetFive;
    public static final MethodSignature newTuple6;
    public static final MethodSignature tuple6GetOne;
    public static final MethodSignature tuple6GetTwo;
    public static final MethodSignature tuple6GetThree;
    public static final MethodSignature tuple6GetFour;
    public static final MethodSignature tuple6GetFive;
    public static final MethodSignature tuple6GetSix;
    public static final MethodSignature newTuple7;
    public static final MethodSignature tuple7GetOne;
    public static final MethodSignature tuple7GetTwo;
    public static final MethodSignature tuple7GetThree;
    public static final MethodSignature tuple7GetFour;
    public static final MethodSignature tuple7GetFive;
    public static final MethodSignature tuple7GetSix;
    public static final MethodSignature tuple7GetSeven;
    public static final MethodSignature newTuple8;
    public static final MethodSignature tuple8GetOne;
    public static final MethodSignature tuple8GetTwo;
    public static final MethodSignature tuple8GetThree;
    public static final MethodSignature tuple8GetFour;
    public static final MethodSignature tuple8GetFive;
    public static final MethodSignature tuple8GetSix;
    public static final MethodSignature tuple8GetSeven;
    public static final MethodSignature tuple8GetEight;
    public static final MethodSignature streamSumInt;
    public static final MethodSignature streamSumDouble;
    public static final MethodSignature streamMax;
    public static final MethodSignature streamMin;
    public static final MethodSignature streamFrom;
    public static final MethodSignature streamOf;
    public static final MethodSignature dbsetSumInt;
    public static final MethodSignature dbsetSumDouble;
    public static final MethodSignature dbsetMaxInt;
    public static final MethodSignature dbsetMaxDouble;
    public static final MethodSignature dbsetWhere;
    public static final MethodSignature dbsetToStream;
    public static final MethodSignature integerValueOf;
    public static final MethodSignature longValueOf;
    public static final MethodSignature doubleValueOf;
    public static final MethodSignature floatValueOf;
    public static final MethodSignature booleanValueOf;
    public static final MethodSignature integerIntValue;
    public static final MethodSignature longLongValue;
    public static final MethodSignature doubleDoubleValue;
    public static final MethodSignature floatFloatValue;
    public static final MethodSignature booleanBooleanValue;
    public static final MethodSignature bigIntegerValueOfLong;
    public static final MethodSignature newBigDecimalLong;
    public static final MethodSignature newBigDecimalDouble;
    public static final MethodSignature newBigDecimalInt;
    public static final MethodSignature newBigDecimalBigInteger;
    public static final MethodSignature bigDecimalDoubleValue;
    public static final MethodSignature bigIntegerDoubleValue;
    ClassNode cl = new ClassNode();

    public TransformationClassAnalyzer(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        ClassReader reader = new ClassReader((InputStream)fis);
        reader.accept((ClassVisitor)this.cl, 0);
        fis.close();
    }

    public TransformationClassAnalyzer(String className) throws IOException {
        this(className, null);
    }

    public TransformationClassAnalyzer(String className, ClassLoader alternateClassLoader) throws IOException {
        ClassReader reader = null;
        try {
            reader = new ClassReader(className);
        }
        catch (IOException e) {
            String classFileName = className.replace(".", "/") + ".class";
            InputStream classStream = this.getClass().getClassLoader().getResourceAsStream(classFileName);
            if (classStream == null && alternateClassLoader != null) {
                classStream = alternateClassLoader.getResourceAsStream(classFileName);
            }
            reader = new ClassReader(classStream);
        }
        reader.accept((ClassVisitor)this.cl, 0);
    }

    public <T, U> void analyze(StaticMethodAnalysisStorage analysisResults, PathAnalysisSupplementalFactory<T, U> pathAnalysisFactory) {
        ArrayList<String> interfacesAndParent = new ArrayList<String>();
        interfacesAndParent.addAll(this.cl.interfaces);
        interfacesAndParent.add(this.cl.superName);
        for (String i : interfacesAndParent) {
            String expectedMethodName = TransformationClassMethods.get(i);
            if (expectedMethodName == null) continue;
            MethodNode nonSpecificMethod = null;
            MethodNode specificMethod = null;
            int specificity = Integer.MAX_VALUE;
            for (MethodNode m : this.cl.methods) {
                if (!m.name.equals(expectedMethodName)) continue;
                if (m.desc.split("Ljava/lang/Object").length < specificity) {
                    specificMethod = m;
                    specificity = m.desc.split("Ljava/lang/Object").length;
                    continue;
                }
                nonSpecificMethod = m;
            }
            try {
                U analysis = this.analyzeMethod(specificMethod, pathAnalysisFactory);
                if (analysis == null) continue;
                analysisResults.storeMethodAnalysis(i, this.cl.name, analysis);
            }
            catch (AnalyzerException e) {
                e.printStackTrace();
            }
        }
    }

    public <T, U> U analyzeLambdaMethod(String methodName, String methodSignature, PathAnalysisSupplementalFactory<T, U> pathAnalysisFactory) throws AnalyzerException {
        MethodNode specificMethod = null;
        for (MethodNode m : this.cl.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals(methodSignature)) continue;
            specificMethod = m;
        }
        if (specificMethod != null) {
            return this.analyzeMethod(specificMethod, pathAnalysisFactory);
        }
        return null;
    }

    <T, U> U analyzeMethod(MethodNode m, PathAnalysisSupplementalFactory<T, U> pathAnalysisFactory) throws AnalyzerException {
        if (m.tryCatchBlocks.size() > 0) {
            return null;
        }
        CFG cfg = new CFG(this.cl.name, m);
        int[] visitStatus = new int[m.instructions.size()];
        if (this.hasLoops(cfg, visitStatus, 0)) {
            return null;
        }
        List<CodePath> paths = CodePath.breakIntoPaths(cfg, m, this.cl.name, 64);
        if (paths == null) {
            return null;
        }
        U analysis = pathAnalysisFactory.createMethodAnalysisResults();
        for (CodePath path : paths) {
            PathAnalysisMethodChecker methodChecker = pathAnalysisFactory.createMethodChecker();
            PathAnalysis pathResults = path.calculateReturnValueAndConditions(this.cl, m, methodChecker);
            pathAnalysisFactory.addPath(analysis, pathResults.sideEffects, pathResults.returnValue, pathResults.conditions, methodChecker);
        }
        return analysis;
    }

    boolean hasLoops(CFG cfg, int[] visitStatus, int index) {
        boolean VISITING = true;
        int VISITED = 2;
        if (cfg.succsOf(index) == null) {
            return false;
        }
        if (visitStatus[index] == 2) {
            return false;
        }
        if (visitStatus[index] == 1) {
            return true;
        }
        visitStatus[index] = 1;
        for (int succ : cfg.succsOf(index)) {
            if (!this.hasLoops(cfg, visitStatus, succ)) continue;
            return true;
        }
        visitStatus[index] = 2;
        return false;
    }

    static {
        dateEquals = new MethodSignature("java/util/Date", "equals", "(Ljava/lang/Object;)Z");
        dateBefore = new MethodSignature("java/util/Date", "before", "(Ljava/util/Date;)Z");
        dateAfter = new MethodSignature("java/util/Date", "after", "(Ljava/util/Date;)Z");
        calendarEquals = new MethodSignature("java/util/Calendar", "equals", "(Ljava/lang/Object;)Z");
        calendarBefore = new MethodSignature("java/util/Calendar", "before", "(Ljava/lang/Object;)Z");
        calendarAfter = new MethodSignature("java/util/Calendar", "after", "(Ljava/lang/Object;)Z");
        sqlDateEquals = new MethodSignature("java/sql/Date", "equals", "(Ljava/lang/Object;)Z");
        sqlDateBefore = new MethodSignature("java/sql/Date", "before", "(Ljava/util/Date;)Z");
        sqlDateAfter = new MethodSignature("java/sql/Date", "after", "(Ljava/util/Date;)Z");
        sqlTimeEquals = new MethodSignature("java/sql/Time", "equals", "(Ljava/lang/Object;)Z");
        sqlTimeBefore = new MethodSignature("java/sql/Time", "before", "(Ljava/util/Date;)Z");
        sqlTimeAfter = new MethodSignature("java/sql/Time", "after", "(Ljava/util/Date;)Z");
        sqlTimestampEquals = new MethodSignature("java/sql/Timestamp", "equals", "(Ljava/sql/Timestamp;)Z");
        sqlTimestampBefore = new MethodSignature("java/sql/Timestamp", "before", "(Ljava/sql/Timestamp;)Z");
        sqlTimestampAfter = new MethodSignature("java/sql/Timestamp", "after", "(Ljava/sql/Timestamp;)Z");
        bigDecimalCompareTo = new MethodSignature("java/math/BigDecimal", "compareTo", "(Ljava/math/BigDecimal;)I");
        bigDecimalEquals = new MethodSignature("java/math/BigDecimal", "equals", "(Ljava/lang/Object;)Z");
        bigDecimalAdd = new MethodSignature("java/math/BigDecimal", "add", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
        bigDecimalDivide = new MethodSignature("java/math/BigDecimal", "divide", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
        bigDecimalMultiply = new MethodSignature("java/math/BigDecimal", "multiply", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
        bigDecimalSubtract = new MethodSignature("java/math/BigDecimal", "subtract", "(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
        bigIntegerCompareTo = new MethodSignature("java/math/BigInteger", "compareTo", "(Ljava/math/BigInteger;)I");
        bigIntegerEquals = new MethodSignature("java/math/BigInteger", "equals", "(Ljava/lang/Object;)Z");
        bigIntegerAdd = new MethodSignature("java/math/BigInteger", "add", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigIntegerDivide = new MethodSignature("java/math/BigInteger", "divide", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigIntegerMultiply = new MethodSignature("java/math/BigInteger", "multiply", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        bigIntegerSubtract = new MethodSignature("java/math/BigInteger", "subtract", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
        uuidEquals = new MethodSignature("java/util/UUID", "equals", "(Ljava/lang/Object;)Z");
        uuidCompareTo = new MethodSignature("java/util/UUID", "compareTo", "(Ljava/util/UUID;)I");
        newPair = new MethodSignature("org/jinq/tuples/Pair", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        pairGetOne = new MethodSignature("org/jinq/tuples/Pair", "getOne", "()Ljava/lang/Object;");
        pairGetTwo = new MethodSignature("org/jinq/tuples/Pair", "getTwo", "()Ljava/lang/Object;");
        newTuple3 = new MethodSignature("org/jinq/tuples/Tuple3", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
        tuple3GetOne = new MethodSignature("org/jinq/tuples/Tuple3", "getOne", "()Ljava/lang/Object;");
        tuple3GetTwo = new MethodSignature("org/jinq/tuples/Tuple3", "getTwo", "()Ljava/lang/Object;");
        tuple3GetThree = new MethodSignature("org/jinq/tuples/Tuple3", "getThree", "()Ljava/lang/Object;");
        newTuple4 = new MethodSignature("org/jinq/tuples/Tuple4", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
        tuple4GetOne = new MethodSignature("org/jinq/tuples/Tuple4", "getOne", "()Ljava/lang/Object;");
        tuple4GetTwo = new MethodSignature("org/jinq/tuples/Tuple4", "getTwo", "()Ljava/lang/Object;");
        tuple4GetThree = new MethodSignature("org/jinq/tuples/Tuple4", "getThree", "()Ljava/lang/Object;");
        tuple4GetFour = new MethodSignature("org/jinq/tuples/Tuple4", "getFour", "()Ljava/lang/Object;");
        newTuple5 = new MethodSignature("org/jinq/tuples/Tuple5", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V");
        tuple5GetOne = new MethodSignature("org/jinq/tuples/Tuple5", "getOne", "()Ljava/lang/Object;");
        tuple5GetTwo = new MethodSignature("org/jinq/tuples/Tuple5", "getTwo", "()Ljava/lang/Object;");
        tuple5GetThree = new MethodSignature("org/jinq/tuples/Tuple5", "getThree", "()Ljava/lang/Object;");
        tuple5GetFour = new MethodSignature("org/jinq/tuples/Tuple5", "getFour", "()Ljava/lang/Object;");
        tuple5GetFive = new MethodSignature("org/jinq/tuples/Tuple5", "getFive", "()Ljava/lang/Object;");
        streamSumInt = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumInteger", "(Lorg/jinq/orm/stream/JinqStream$CollectInteger;)Ljava/lang/Long;");
        streamSumDouble = new MethodSignature("org/jinq/orm/stream/JinqStream", "sumDouble", "(Lorg/jinq/orm/stream/JinqStream$CollectDouble;)Ljava/lang/Double;");
        streamMax = new MethodSignature("org/jinq/orm/stream/JinqStream", "max", "(Lorg/jinq/orm/stream/JinqStream$CollectComparable;)Ljava/lang/Comparable;");
        streamMin = new MethodSignature("org/jinq/orm/stream/JinqStream", "min", "(Lorg/jinq/orm/stream/JinqStream$CollectComparable;)Ljava/lang/Comparable;");
        streamFrom = new MethodSignature("org/jinq/orm/stream/JinqStream", "from", "(Ljava/util/Collection;)Lorg/jinq/orm/stream/JinqStream;");
        streamOf = new MethodSignature("org/jinq/orm/stream/JinqStream", "of", "(Ljava/lang/Object;)Lorg/jinq/orm/stream/JinqStream;");
        dbsetSumInt = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "sumInt", "(Lch/epfl/labos/iu/orm/DBSet$AggregateInteger;)I");
        dbsetSumDouble = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "sumDouble", "(Lch/epfl/labos/iu/orm/DBSet$AggregateDouble;)D");
        dbsetMaxInt = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "maxInt", "(Lch/epfl/labos/iu/orm/DBSet$AggregateInteger;)I");
        dbsetMaxDouble = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "maxDouble", "(Lch/epfl/labos/iu/orm/DBSet$AggregateDouble;)D");
        dbsetWhere = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", WHERE_METHOD, "(Lch/epfl/labos/iu/orm/DBSet$Where;)Lch/epfl/labos/iu/orm/DBSet;");
        dbsetToStream = new MethodSignature("ch/epfl/labos/iu/orm/DBSet", "jinqStream", "()Lorg/jinq/orm/stream/JinqStream;");
        integerValueOf = new MethodSignature("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        longValueOf = new MethodSignature("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        doubleValueOf = new MethodSignature("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        floatValueOf = new MethodSignature("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        booleanValueOf = new MethodSignature("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        integerIntValue = new MethodSignature("java/lang/Integer", "intValue", "()I");
        longLongValue = new MethodSignature("java/lang/Long", "longValue", "()J");
        doubleDoubleValue = new MethodSignature("java/lang/Double", "doubleValue", "()D");
        floatFloatValue = new MethodSignature("java/lang/Float", "floatValue", "()F");
        booleanBooleanValue = new MethodSignature("java/lang/Boolean", "booleanValue", "()Z");
        bigIntegerValueOfLong = new MethodSignature("java/math/BigInteger", "valueOf", "(J)Ljava/math/BigInteger;");
        newBigDecimalLong = new MethodSignature("java/math/BigDecimal", "<init>", "(J)V");
        newBigDecimalDouble = new MethodSignature("java/math/BigDecimal", "<init>", "(D)V");
        newBigDecimalInt = new MethodSignature("java/math/BigDecimal", "<init>", "(I)V");
        newBigDecimalBigInteger = new MethodSignature("java/math/BigDecimal", "<init>", "(Ljava/math/BigInteger;)V");
        bigDecimalDoubleValue = new MethodSignature("java/math/BigDecimal", "doubleValue", "()D");
        bigIntegerDoubleValue = new MethodSignature("java/math/BigInteger", "doubleValue", "()D");
        try {
            booleanEquals = MethodSignature.fromMethod(Boolean.class.getMethod("equals", Object.class));
            localDateIsBefore = MethodSignature.fromMethod(LocalDate.class.getMethod("isBefore", ChronoLocalDate.class));
            localDateIsAfter = MethodSignature.fromMethod(LocalDate.class.getMethod("isAfter", ChronoLocalDate.class));
            localDateIsEqual = MethodSignature.fromMethod(LocalDate.class.getMethod("isEqual", ChronoLocalDate.class));
            localTimeIsBefore = MethodSignature.fromMethod(LocalTime.class.getMethod("isBefore", LocalTime.class));
            localTimeIsAfter = MethodSignature.fromMethod(LocalTime.class.getMethod("isAfter", LocalTime.class));
            localDateTimeIsBefore = MethodSignature.fromMethod(LocalDateTime.class.getMethod("isBefore", ChronoLocalDateTime.class));
            localDateTimeIsAfter = MethodSignature.fromMethod(LocalDateTime.class.getMethod("isAfter", ChronoLocalDateTime.class));
            localDateTimeIsEqual = MethodSignature.fromMethod(LocalDateTime.class.getMethod("isEqual", ChronoLocalDateTime.class));
            offsetDateTimeIsBefore = MethodSignature.fromMethod(OffsetDateTime.class.getMethod("isBefore", OffsetDateTime.class));
            offsetDateTimeIsAfter = MethodSignature.fromMethod(OffsetDateTime.class.getMethod("isAfter", OffsetDateTime.class));
            offsetDateTimeIsEqual = MethodSignature.fromMethod(OffsetDateTime.class.getMethod("isEqual", OffsetDateTime.class));
            offsetTimeIsBefore = MethodSignature.fromMethod(OffsetTime.class.getMethod("isBefore", OffsetTime.class));
            offsetTimeIsAfter = MethodSignature.fromMethod(OffsetTime.class.getMethod("isAfter", OffsetTime.class));
            offsetTimeIsEqual = MethodSignature.fromMethod(OffsetTime.class.getMethod("isEqual", OffsetTime.class));
            zonedDateTimeIsBefore = new MethodSignature("java/time/ZonedDateTime", "isBefore", "(Ljava/time/chrono/ChronoZonedDateTime;)Z");
            zonedDateTimeIsAfter = new MethodSignature("java/time/ZonedDateTime", "isAfter", "(Ljava/time/chrono/ChronoZonedDateTime;)Z");
            zonedDateTimeIsEqual = new MethodSignature("java/time/ZonedDateTime", "isEqual", "(Ljava/time/chrono/ChronoZonedDateTime;)Z");
            instantIsBefore = MethodSignature.fromMethod(Instant.class.getMethod("isBefore", Instant.class));
            instantIsAfter = MethodSignature.fromMethod(Instant.class.getMethod("isAfter", Instant.class));
            newTuple6 = MethodSignature.fromConstructor(Tuple6.class.getConstructor(Object.class, Object.class, Object.class, Object.class, Object.class, Object.class));
            tuple6GetOne = MethodSignature.fromMethod(Tuple6.class.getMethod("getOne", new Class[0]));
            tuple6GetTwo = MethodSignature.fromMethod(Tuple6.class.getMethod("getTwo", new Class[0]));
            tuple6GetThree = MethodSignature.fromMethod(Tuple6.class.getMethod("getThree", new Class[0]));
            tuple6GetFour = MethodSignature.fromMethod(Tuple6.class.getMethod("getFour", new Class[0]));
            tuple6GetFive = MethodSignature.fromMethod(Tuple6.class.getMethod("getFive", new Class[0]));
            tuple6GetSix = MethodSignature.fromMethod(Tuple6.class.getMethod("getSix", new Class[0]));
            newTuple7 = MethodSignature.fromConstructor(Tuple7.class.getConstructor(Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class));
            tuple7GetOne = MethodSignature.fromMethod(Tuple7.class.getMethod("getOne", new Class[0]));
            tuple7GetTwo = MethodSignature.fromMethod(Tuple7.class.getMethod("getTwo", new Class[0]));
            tuple7GetThree = MethodSignature.fromMethod(Tuple7.class.getMethod("getThree", new Class[0]));
            tuple7GetFour = MethodSignature.fromMethod(Tuple7.class.getMethod("getFour", new Class[0]));
            tuple7GetFive = MethodSignature.fromMethod(Tuple7.class.getMethod("getFive", new Class[0]));
            tuple7GetSix = MethodSignature.fromMethod(Tuple7.class.getMethod("getSix", new Class[0]));
            tuple7GetSeven = MethodSignature.fromMethod(Tuple7.class.getMethod("getSeven", new Class[0]));
            newTuple8 = MethodSignature.fromConstructor(Tuple8.class.getConstructor(Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class));
            tuple8GetOne = MethodSignature.fromMethod(Tuple8.class.getMethod("getOne", new Class[0]));
            tuple8GetTwo = MethodSignature.fromMethod(Tuple8.class.getMethod("getTwo", new Class[0]));
            tuple8GetThree = MethodSignature.fromMethod(Tuple8.class.getMethod("getThree", new Class[0]));
            tuple8GetFour = MethodSignature.fromMethod(Tuple8.class.getMethod("getFour", new Class[0]));
            tuple8GetFive = MethodSignature.fromMethod(Tuple8.class.getMethod("getFive", new Class[0]));
            tuple8GetSix = MethodSignature.fromMethod(Tuple8.class.getMethod("getSix", new Class[0]));
            tuple8GetSeven = MethodSignature.fromMethod(Tuple8.class.getMethod("getSeven", new Class[0]));
            tuple8GetEight = MethodSignature.fromMethod(Tuple8.class.getMethod("getEight", new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Cannot find a method needed for analysis", e);
        }
        TransformationClassMethods.put(GROUP_INTERFACE, "aggregateSelect");
        TransformationClassMethods.put(JOIN_INTERFACE, JOIN_METHOD);
        TransformationClassMethods.put(AGGREGATEDOUBLE_INTERFACE, "aggregate");
        TransformationClassMethods.put(AGGREGATEINTEGER_INTERFACE, "aggregate");
        TransformationClassMethods.put(AGGREGATESELECT_INTERFACE, "aggregateSelect");
        TransformationClassMethods.put(SELECT_INTERFACE, SELECT_METHOD);
        TransformationClassMethods.put(WHERE_INTERFACE, WHERE_METHOD);
        TransformationClassMethods.put(DATESORTER_SUPERCLASS, "value");
        TransformationClassMethods.put(INTSORTER_SUPERCLASS, "value");
        TransformationClassMethods.put(DOUBLESORTER_SUPERCLASS, "value");
        TransformationClassMethods.put(STRINGSORTER_SUPERCLASS, "value");
        KnownSafeMethods.add(stringEquals);
        KnownSafeMethods.add(stringCompareTo);
        KnownSafeStaticMethods.add(stringLike);
        KnownSafeMethods.add(newStringBuilderString);
        KnownSafeMethods.add(newStringBuilder);
        KnownSafeMethods.add(stringBuilderAppendString);
        KnownSafeMethods.add(stringBuilderToString);
        KnownSafeMethods.add(booleanEquals);
        KnownSafeMethods.add(dateEquals);
        KnownSafeMethods.add(dateBefore);
        KnownSafeMethods.add(dateAfter);
        KnownSafeMethods.add(calendarEquals);
        KnownSafeMethods.add(calendarBefore);
        KnownSafeMethods.add(calendarAfter);
        KnownSafeMethods.add(sqlDateEquals);
        KnownSafeMethods.add(sqlDateBefore);
        KnownSafeMethods.add(sqlDateAfter);
        KnownSafeMethods.add(sqlTimeEquals);
        KnownSafeMethods.add(sqlTimeBefore);
        KnownSafeMethods.add(sqlTimeAfter);
        KnownSafeMethods.add(sqlTimestampEquals);
        KnownSafeMethods.add(sqlTimestampBefore);
        KnownSafeMethods.add(sqlTimestampAfter);
        KnownSafeMethods.add(localDateIsBefore);
        KnownSafeMethods.add(localDateIsAfter);
        KnownSafeMethods.add(localDateIsEqual);
        KnownSafeMethods.add(localTimeIsBefore);
        KnownSafeMethods.add(localTimeIsAfter);
        KnownSafeMethods.add(localDateTimeIsBefore);
        KnownSafeMethods.add(localDateTimeIsAfter);
        KnownSafeMethods.add(localDateTimeIsEqual);
        KnownSafeMethods.add(offsetDateTimeIsBefore);
        KnownSafeMethods.add(offsetDateTimeIsAfter);
        KnownSafeMethods.add(offsetDateTimeIsEqual);
        KnownSafeMethods.add(offsetTimeIsBefore);
        KnownSafeMethods.add(offsetTimeIsAfter);
        KnownSafeMethods.add(offsetTimeIsEqual);
        KnownSafeMethods.add(zonedDateTimeIsBefore);
        KnownSafeMethods.add(zonedDateTimeIsAfter);
        KnownSafeMethods.add(zonedDateTimeIsEqual);
        KnownSafeMethods.add(instantIsBefore);
        KnownSafeMethods.add(instantIsAfter);
        KnownSafeMethods.add(bigDecimalCompareTo);
        KnownSafeMethods.add(bigDecimalEquals);
        KnownSafeMethods.add(bigDecimalAdd);
        KnownSafeMethods.add(bigDecimalDivide);
        KnownSafeMethods.add(bigDecimalMultiply);
        KnownSafeMethods.add(bigDecimalSubtract);
        KnownSafeMethods.add(bigIntegerCompareTo);
        KnownSafeMethods.add(bigIntegerEquals);
        KnownSafeMethods.add(bigIntegerAdd);
        KnownSafeMethods.add(bigIntegerDivide);
        KnownSafeMethods.add(bigIntegerMultiply);
        KnownSafeMethods.add(bigIntegerSubtract);
        KnownSafeMethods.add(uuidEquals);
        KnownSafeMethods.add(uuidCompareTo);
        KnownSafeMethods.add(newPair);
        KnownSafeMethods.add(pairGetOne);
        KnownSafeMethods.add(pairGetTwo);
        KnownSafeMethods.add(newTuple3);
        KnownSafeMethods.add(tuple3GetOne);
        KnownSafeMethods.add(tuple3GetTwo);
        KnownSafeMethods.add(tuple3GetThree);
        KnownSafeMethods.add(newTuple4);
        KnownSafeMethods.add(tuple4GetOne);
        KnownSafeMethods.add(tuple4GetTwo);
        KnownSafeMethods.add(tuple4GetThree);
        KnownSafeMethods.add(tuple4GetFour);
        KnownSafeMethods.add(newTuple5);
        KnownSafeMethods.add(tuple5GetOne);
        KnownSafeMethods.add(tuple5GetTwo);
        KnownSafeMethods.add(tuple5GetThree);
        KnownSafeMethods.add(tuple5GetFour);
        KnownSafeMethods.add(tuple5GetFive);
        KnownSafeMethods.add(newTuple6);
        KnownSafeMethods.add(tuple6GetOne);
        KnownSafeMethods.add(tuple6GetTwo);
        KnownSafeMethods.add(tuple6GetThree);
        KnownSafeMethods.add(tuple6GetFour);
        KnownSafeMethods.add(tuple6GetFive);
        KnownSafeMethods.add(tuple6GetSix);
        KnownSafeMethods.add(newTuple7);
        KnownSafeMethods.add(tuple7GetOne);
        KnownSafeMethods.add(tuple7GetTwo);
        KnownSafeMethods.add(tuple7GetThree);
        KnownSafeMethods.add(tuple7GetFour);
        KnownSafeMethods.add(tuple7GetFive);
        KnownSafeMethods.add(tuple7GetSix);
        KnownSafeMethods.add(tuple7GetSeven);
        KnownSafeMethods.add(newTuple8);
        KnownSafeMethods.add(tuple8GetOne);
        KnownSafeMethods.add(tuple8GetTwo);
        KnownSafeMethods.add(tuple8GetThree);
        KnownSafeMethods.add(tuple8GetFour);
        KnownSafeMethods.add(tuple8GetFive);
        KnownSafeMethods.add(tuple8GetSix);
        KnownSafeMethods.add(tuple8GetSeven);
        KnownSafeMethods.add(tuple8GetEight);
        KnownSafeStaticMethods.add(streamFrom);
        KnownSafeStaticMethods.add(streamOf);
        KnownSafeStaticMethods.add(bigIntegerValueOfLong);
        KnownSafeMethods.add(newBigDecimalLong);
        KnownSafeMethods.add(newBigDecimalDouble);
        KnownSafeMethods.add(newBigDecimalInt);
        KnownSafeMethods.add(newBigDecimalBigInteger);
        KnownSafeMethods.add(bigDecimalDoubleValue);
        KnownSafeMethods.add(bigIntegerDoubleValue);
    }
}

