/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import java.util.List;
import java.util.Objects;
import org.jinq.rebased.org.objectweb.asm.Type;

public class MethodCallValue
extends TypedValue {
    public String owner;
    public String name;
    public String desc;
    public List<TypedValue> args;

    public MethodCallValue(String owner, String name, String desc, List<TypedValue> args, Type returnType) {
        super(returnType);
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        this.args = args;
    }

    public String toString() {
        String str = this.name + "(";
        boolean isFirst = true;
        for (TypedValue val : this.args) {
            if (!isFirst) {
                str = str + ", ";
            }
            isFirst = false;
            str = str + val.toString();
        }
        str = str + ")";
        return str;
    }

    @Override
    public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
        return visitor.methodCallValue(this, input);
    }

    public MethodCallValue withNewArgs(List<TypedValue> newArgs) {
        return new MethodCallValue(this.owner, this.name, this.desc, newArgs, this.type);
    }

    public MethodSignature getSignature() {
        return new MethodSignature(this.owner, this.name, this.desc);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.args == null ? 0 : this.args.hashCode());
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodCallValue other = (MethodCallValue)obj;
        if (this.args == null ? other.args != null : !this.args.equals(other.args)) {
            return false;
        }
        if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    public static class StringConcatFactoryValue
    extends MethodCallValue {
        public String recipe;

        public StringConcatFactoryValue(String desc, String recipe, List<TypedValue> args) {
            super("StringConcatFactory", "makeConcatWithConstants", desc, args, Type.getReturnType((String)desc));
            this.recipe = recipe;
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.stringConcatFactoryValue(this, input);
        }

        @Override
        public StringConcatFactoryValue withNewArgs(List<TypedValue> newArgs) {
            return new StringConcatFactoryValue(this.desc, this.recipe, newArgs);
        }

        @Override
        public String toString() {
            String argString = "";
            boolean isFirst = true;
            for (TypedValue val : this.args) {
                if (!isFirst) {
                    argString = argString + ",";
                }
                isFirst = false;
                argString = argString + val;
            }
            return "StringConcatFactory.makeConcatWithConstants(\"" + this.recipe + "\"," + argString + ")";
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.recipe);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringConcatFactoryValue other = (StringConcatFactoryValue)obj;
            return Objects.equals(this.recipe, other.recipe);
        }
    }

    public static class VirtualMethodCallValue
    extends MethodCallValue {
        public TypedValue base;

        public VirtualMethodCallValue(String owner, String name, String desc, List<TypedValue> args, TypedValue base) {
            super(owner, name, desc, args, name.equals("<init>") ? Type.getObjectType((String)owner) : Type.getReturnType((String)desc));
            this.base = base;
        }

        public boolean isConstructor() {
            return this.name.equals("<init>");
        }

        @Override
        public String toString() {
            return this.base.toString() + "." + super.toString();
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.virtualMethodCallValue(this, input);
        }

        public VirtualMethodCallValue withNewArgs(List<TypedValue> newArgs, TypedValue newBase) {
            return new VirtualMethodCallValue(this.owner, this.name, this.desc, newArgs, newBase);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VirtualMethodCallValue other = (VirtualMethodCallValue)obj;
            return !(this.base == null ? other.base != null : !this.base.equals(other.base));
        }
    }

    public static class StaticMethodCallValue
    extends MethodCallValue {
        public StaticMethodCallValue(String owner, String name, String desc, List<TypedValue> args) {
            super(owner, name, desc, args, Type.getReturnType((String)desc));
        }

        @Override
        public <I, O, E extends Exception> O visit(TypedValueVisitor<I, O, E> visitor, I input) throws E {
            return visitor.staticMethodCallValue(this, input);
        }

        @Override
        public StaticMethodCallValue withNewArgs(List<TypedValue> newArgs) {
            return new StaticMethodCallValue(this.owner, this.name, this.desc, newArgs);
        }
    }
}

